/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.interop.JSMetaType;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.WeakMap;
import java.util.Map;
import java.util.Objects;

@ExportLibrary(value=InteropLibrary.class)
public final class Symbol
implements TruffleObject {
    public static final Symbol SYMBOL_HAS_INSTANCE = Symbol.createWellKnown(Strings.constant("Symbol.hasInstance"));
    public static final Symbol SYMBOL_IS_CONCAT_SPREADABLE = Symbol.createWellKnown(Strings.constant("Symbol.isConcatSpreadable"));
    public static final Symbol SYMBOL_ITERATOR = Symbol.createWellKnown(Strings.constant("Symbol.iterator"));
    public static final Symbol SYMBOL_ASYNC_ITERATOR = Symbol.createWellKnown(Strings.constant("Symbol.asyncIterator"));
    public static final Symbol SYMBOL_MATCH = Symbol.createWellKnown(Strings.constant("Symbol.match"));
    public static final Symbol SYMBOL_MATCH_ALL = Symbol.createWellKnown(Strings.constant("Symbol.matchAll"));
    public static final Symbol SYMBOL_REPLACE = Symbol.createWellKnown(Strings.constant("Symbol.replace"));
    public static final Symbol SYMBOL_SEARCH = Symbol.createWellKnown(Strings.constant("Symbol.search"));
    public static final Symbol SYMBOL_SPECIES = Symbol.createWellKnown(Strings.constant("Symbol.species"));
    public static final Symbol SYMBOL_SPLIT = Symbol.createWellKnown(Strings.constant("Symbol.split"));
    public static final Symbol SYMBOL_TO_PRIMITIVE = Symbol.createWellKnown(Strings.constant("Symbol.toPrimitive"));
    public static final Symbol SYMBOL_TO_STRING_TAG = Symbol.createWellKnown(Strings.constant("Symbol.toStringTag"));
    public static final Symbol SYMBOL_UNSCOPABLES = Symbol.createWellKnown(Strings.constant("Symbol.unscopables"));
    private final TruffleString description;
    private final boolean registered;
    private final boolean isPrivate;
    private Map<WeakMap, Object> invertedMap;

    private Symbol(TruffleString description, boolean registered, boolean isPrivate) {
        this.description = description;
        this.registered = registered;
        this.isPrivate = isPrivate;
    }

    public static Symbol create(TruffleString description) {
        Symbol symbol = new Symbol(description, false, false);
        JavaScriptLanguage.getCurrentLanguage().getJSContext().unregisteredSymbolCreated(symbol);
        return symbol;
    }

    private static Symbol createWellKnown(TruffleString description) {
        return new Symbol(description, false, false);
    }

    public static Symbol createRegistered(TruffleString description) {
        return new Symbol(Objects.requireNonNull(description), true, false);
    }

    public static Symbol createPrivate(TruffleString description) {
        return new Symbol(description, false, true);
    }

    public static Symbol createPrivateRegistered(TruffleString description) {
        return new Symbol(Objects.requireNonNull(description), true, true);
    }

    public Object getDescription() {
        return this.description == null ? Undefined.instance : this.description;
    }

    public TruffleString getName() {
        return this.description == null ? Strings.EMPTY_STRING : this.description;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return Strings.toJavaString(this.toTString());
    }

    public TruffleString toTString() {
        return Strings.concatAll(Strings.SYMBOL_PAREN_OPEN, this.getName(), Strings.PAREN_CLOSE);
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleString toFunctionNameString() {
        return this.description == null ? Strings.EMPTY_STRING : Strings.concatAll(Strings.BRACKET_OPEN, this.description, Strings.BRACKET_CLOSE);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return JavaScriptLanguage.class;
    }

    @ExportMessage
    Object toDisplayString(boolean allowSideEffects) {
        return this.toString();
    }

    @ExportMessage
    boolean hasMetaObject() {
        return true;
    }

    @ExportMessage
    Object getMetaObject() {
        return JSMetaType.JS_SYMBOL;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    int identityHashCode() {
        return super.hashCode();
    }

    public Map<WeakMap, Object> getInvertedMap() {
        return this.invertedMap;
    }

    public void setInvertedMap(Map<WeakMap, Object> invMap) {
        assert (this.invertedMap == null);
        this.invertedMap = invMap;
    }

    void clearInvertedMap() {
        this.invertedMap = null;
    }

    @ExportMessage
    static final class IsIdenticalOrUndefined {
        IsIdenticalOrUndefined() {
        }

        @Specialization
        static TriState doHostObject(Symbol receiver, Symbol other) {
            return TriState.valueOf((receiver == other ? 1 : 0) != 0);
        }

        @Fallback
        static TriState doOther(Symbol receiver, Object other) {
            return TriState.UNDEFINED;
        }
    }
}

