/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.exec.PTFRollingPartition;
import org.apache.hadoop.hive.ql.exec.WindowFunctionInfo;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.PTFExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PartitionedTableFunctionDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFunctionDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowTableFunctionDef;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.ISupportStreamingModeForWindowing;
import org.apache.hadoop.hive.ql.udf.ptf.BasePartitionEvaluator;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionEvaluator;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionResolver;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowingTableFunction
extends TableFunctionEvaluator {
    public static final Logger LOG = LoggerFactory.getLogger((String)WindowingTableFunction.class.getName());
    StreamingState streamingState;
    RankLimit rnkLimitDef;
    Map<String, WindowingFunctionInfoHelper> windowingFunctionHelpers = null;

    public Map<String, WindowingFunctionInfoHelper> getWindowingFunctionHelpers() {
        return this.windowingFunctionHelpers;
    }

    public void setWindowingFunctionHelpers(Map<String, WindowingFunctionInfoHelper> windowingFunctionHelpers) {
        this.windowingFunctionHelpers = windowingFunctionHelpers;
    }

    @Override
    public void execute(PTFPartition.PTFPartitionIterator<Object> pItr, PTFPartition outP) throws HiveException {
        ArrayList<List> oColumns = new ArrayList<List>();
        PTFPartition iPart = pItr.getPartition();
        StructObjectInspector inputOI = iPart.getOutputOI();
        WindowTableFunctionDef wTFnDef = (WindowTableFunctionDef)this.getTableDef();
        for (WindowFunctionDef wFn : wTFnDef.getWindowFunctions()) {
            boolean processWindow = WindowingTableFunction.processWindow(wFn.getWindowFrame());
            pItr.reset();
            if (!processWindow) {
                SameList<Object> out = this.evaluateFunctionOnPartition(wFn, iPart);
                if (!wFn.isPivotResult()) {
                    out = new SameList<Object>(iPart.size(), out);
                }
                oColumns.add(out);
                continue;
            }
            oColumns.add(this.executeFnwithWindow(wFn, iPart));
        }
        for (int i = 0; i < iPart.size(); ++i) {
            ArrayList<Object> oRow = new ArrayList<Object>();
            Object iRow = iPart.getAt(i);
            for (int j = 0; j < oColumns.size(); ++j) {
                oRow.add(((List)oColumns.get(j)).get(i));
            }
            for (StructField f : inputOI.getAllStructFieldRefs()) {
                oRow.add(inputOI.getStructFieldData(iRow, f));
            }
            outP.append(oRow);
        }
    }

    private Object evaluateWindowFunction(WindowFunctionDef wFn, int rowToProcess, PTFPartition partition) throws HiveException {
        BasePartitionEvaluator partitionEval = wFn.getWFnEval().getPartitionWindowingEvaluator(wFn.getWindowFrame(), partition, wFn.getArgs(), wFn.getOI(), this.nullsLast);
        return partitionEval.iterate(rowToProcess, this.ptfDesc.getLlInfo());
    }

    private Object evaluateFunctionOnPartition(WindowFunctionDef wFn, PTFPartition partition) throws HiveException {
        BasePartitionEvaluator partitionEval = wFn.getWFnEval().getPartitionWindowingEvaluator(wFn.getWindowFrame(), partition, wFn.getArgs(), wFn.getOI(), this.nullsLast);
        return partitionEval.getPartitionAgg();
    }

    ArrayList<Object> executeFnwithWindow(WindowFunctionDef wFnDef, PTFPartition iPart) throws HiveException {
        ArrayList<Object> vals = new ArrayList<Object>();
        for (int i = 0; i < iPart.size(); ++i) {
            Object out = this.evaluateWindowFunction(wFnDef, i, iPart);
            vals.add(out);
        }
        return vals;
    }

    private static boolean processWindow(WindowFrameDef frame) {
        if (frame == null) {
            return false;
        }
        return frame.getStart().getAmt() != Integer.MAX_VALUE || frame.getEnd().getAmt() != Integer.MAX_VALUE;
    }

    private boolean streamingPossible(Configuration cfg, WindowFunctionDef wFnDef) throws HiveException {
        WindowFrameDef wdwFrame = wFnDef.getWindowFrame();
        WindowingFunctionInfoHelper wFnInfo = this.getWindowingFunctionInfoHelper(wFnDef.getName());
        if (!wFnInfo.isSupportsWindow()) {
            return true;
        }
        BoundaryDef start = wdwFrame.getStart();
        BoundaryDef end = wdwFrame.getEnd();
        if (wdwFrame.getWindowType() == WindowingSpec.WindowType.RANGE) {
            return false;
        }
        if (end.getAmt() == Integer.MAX_VALUE) {
            return false;
        }
        if (start.getAmt() == Integer.MAX_VALUE) {
            return true;
        }
        int windowLimit = HiveConf.getIntVar((Configuration)cfg, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_JOIN_CACHE_SIZE);
        return windowLimit >= start.getAmt() + end.getAmt() + 1;
    }

    private int[] setCanAcceptInputAsStream(Configuration cfg) throws HiveException {
        this.canAcceptInputAsStream = false;
        if (this.ptfDesc.getLlInfo().getLeadLagExprs() != null) {
            return null;
        }
        WindowTableFunctionDef tabDef = (WindowTableFunctionDef)this.getTableDef();
        int startPos = Integer.MAX_VALUE;
        int endPos = Integer.MIN_VALUE;
        for (int i = 0; i < tabDef.getWindowFunctions().size(); ++i) {
            GenericUDAFEvaluator streamingEval;
            WindowFunctionDef wFnDef = tabDef.getWindowFunctions().get(i);
            WindowFrameDef wdwFrame = wFnDef.getWindowFrame();
            GenericUDAFEvaluator fnEval = wFnDef.getWFnEval();
            boolean streamingPossible = this.streamingPossible(cfg, wFnDef);
            GenericUDAFEvaluator genericUDAFEvaluator = streamingEval = streamingPossible ? fnEval.getWindowingEvaluator(wdwFrame) : null;
            if (streamingEval != null && streamingEval instanceof ISupportStreamingModeForWindowing) continue;
            BoundaryDef start = wdwFrame.getStart();
            BoundaryDef end = wdwFrame.getEnd();
            if (wdwFrame.getWindowType() == WindowingSpec.WindowType.ROWS && !end.isUnbounded() && !start.isUnbounded()) {
                startPos = Math.min(startPos, wdwFrame.getStart().getRelativeOffset());
                endPos = Math.max(endPos, wdwFrame.getEnd().getRelativeOffset());
                continue;
            }
            return null;
        }
        int windowLimit = HiveConf.getIntVar((Configuration)cfg, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_JOIN_CACHE_SIZE);
        if (windowLimit < endPos - startPos + 1) {
            return null;
        }
        this.canAcceptInputAsStream = true;
        return new int[]{startPos, endPos};
    }

    private void initializeWindowingFunctionInfoHelpers() throws SemanticException {
        if (this.windowingFunctionHelpers != null) {
            return;
        }
        this.windowingFunctionHelpers = new HashMap<String, WindowingFunctionInfoHelper>();
        WindowTableFunctionDef tabDef = (WindowTableFunctionDef)this.getTableDef();
        for (int i = 0; i < tabDef.getWindowFunctions().size(); ++i) {
            WindowFunctionDef wFn = tabDef.getWindowFunctions().get(i);
            WindowFunctionInfo wFnInfo = FunctionRegistry.getWindowFunctionInfo(wFn.getName());
            boolean supportsWindow = wFnInfo.isSupportsWindow();
            this.windowingFunctionHelpers.put(wFn.getName(), new WindowingFunctionInfoHelper(supportsWindow));
        }
    }

    @Override
    protected void setOutputOI(StructObjectInspector outputOI) {
        super.setOutputOI(outputOI);
        try {
            this.initializeWindowingFunctionInfoHelpers();
        }
        catch (SemanticException err) {
            throw new RuntimeException("Unexpected error while setting up windowing function", err);
        }
    }

    private WindowingFunctionInfoHelper getWindowingFunctionInfoHelper(String fnName) {
        WindowingFunctionInfoHelper wFnInfoHelper = this.windowingFunctionHelpers.get(fnName);
        if (wFnInfoHelper == null) {
            throw new RuntimeException("No cached WindowingFunctionInfoHelper for " + fnName);
        }
        return wFnInfoHelper;
    }

    @Override
    public void initializeStreaming(Configuration cfg, StructObjectInspector inputOI, boolean isMapSide) throws HiveException {
        int[] span = this.setCanAcceptInputAsStream(cfg);
        if (!this.canAcceptInputAsStream) {
            return;
        }
        WindowTableFunctionDef tabDef = (WindowTableFunctionDef)this.getTableDef();
        for (int i = 0; i < tabDef.getWindowFunctions().size(); ++i) {
            WindowFunctionDef wFnDef = tabDef.getWindowFunctions().get(i);
            WindowFrameDef wdwFrame = wFnDef.getWindowFrame();
            GenericUDAFEvaluator fnEval = wFnDef.getWFnEval();
            GenericUDAFEvaluator streamingEval = fnEval.getWindowingEvaluator(wdwFrame);
            if (streamingEval == null) continue;
            wFnDef.setWFnEval(streamingEval);
            if (!wFnDef.isPivotResult()) continue;
            ListObjectInspector listOI = (ListObjectInspector)wFnDef.getOI();
            wFnDef.setOI(listOI.getListElementObjectInspector());
        }
        if (tabDef.getRankLimit() != -1) {
            this.rnkLimitDef = new RankLimit(tabDef.getRankLimit(), tabDef.getRankLimitFunction(), tabDef.getWindowFunctions());
        }
        this.streamingState = new StreamingState(this, cfg, inputOI, isMapSide, tabDef, span[0], span[1]);
    }

    @Override
    public void startPartition() throws HiveException {
        WindowTableFunctionDef tabDef = (WindowTableFunctionDef)this.getTableDef();
        this.streamingState.reset(tabDef);
    }

    @Override
    public List<Object> processRow(Object row) throws HiveException {
        boolean hasRow;
        if (this.streamingState.rankLimitReached()) {
            return null;
        }
        this.streamingState.rollingPart.append(row);
        row = this.streamingState.rollingPart.getAt(this.streamingState.rollingPart.size() - 1);
        WindowTableFunctionDef tabDef = (WindowTableFunctionDef)this.tableDef;
        for (int i = 0; i < tabDef.getWindowFunctions().size(); ++i) {
            WindowFunctionDef wFn = tabDef.getWindowFunctions().get(i);
            GenericUDAFEvaluator fnEval = wFn.getWFnEval();
            int a = 0;
            if (wFn.getArgs() != null) {
                for (PTFExpressionDef arg : wFn.getArgs()) {
                    this.streamingState.funcArgs[i][a++] = arg.getExprEvaluator().evaluate(row);
                }
            }
            if (fnEval != null && fnEval instanceof ISupportStreamingModeForWindowing) {
                fnEval.aggregate(this.streamingState.aggBuffers[i], this.streamingState.funcArgs[i]);
                Object out = ((ISupportStreamingModeForWindowing)((Object)fnEval)).getNextResult(this.streamingState.aggBuffers[i]);
                if (out == null) continue;
                this.streamingState.fnOutputs[i].add(out == ISupportStreamingModeForWindowing.NULL_RESULT ? null : out);
                continue;
            }
            int rowToProcess = this.streamingState.rollingPart.rowToProcess(wFn.getWindowFrame());
            if (rowToProcess < 0) continue;
            Object out = this.evaluateWindowFunction(wFn, rowToProcess, this.streamingState.rollingPart);
            this.streamingState.fnOutputs[i].add(out);
        }
        ArrayList<Object> oRows = new ArrayList<Object>();
        while (hasRow = this.streamingState.hasOutputRow()) {
            oRows.add(this.streamingState.nextOutputRow());
        }
        return oRows.size() == 0 ? null : oRows;
    }

    @Override
    public List<Object> finishPartition() throws HiveException {
        if (this.streamingState.rankLimitReached()) {
            return null;
        }
        WindowTableFunctionDef tabDef = (WindowTableFunctionDef)this.getTableDef();
        for (int i = 0; i < tabDef.getWindowFunctions().size(); ++i) {
            Object out;
            int numRowsRemaining;
            WindowFunctionDef wFn = tabDef.getWindowFunctions().get(i);
            GenericUDAFEvaluator fnEval = wFn.getWFnEval();
            if (fnEval != null && fnEval instanceof ISupportStreamingModeForWindowing) {
                fnEval.terminate(this.streamingState.aggBuffers[i]);
                WindowingFunctionInfoHelper wFnInfo = this.getWindowingFunctionInfoHelper(wFn.getName());
                if (!wFnInfo.isSupportsWindow()) {
                    numRowsRemaining = ((ISupportStreamingModeForWindowing)((Object)fnEval)).getRowsRemainingAfterTerminate();
                }
                if (numRowsRemaining == Integer.MAX_VALUE) continue;
                while (numRowsRemaining > 0) {
                    out = ((ISupportStreamingModeForWindowing)((Object)fnEval)).getNextResult(this.streamingState.aggBuffers[i]);
                    if (out != null) {
                        this.streamingState.fnOutputs[i].add(out == ISupportStreamingModeForWindowing.NULL_RESULT ? null : out);
                    }
                    --numRowsRemaining;
                }
                continue;
            }
            for (numRowsRemaining = wFn.getWindowFrame().getEnd().getRelativeOffset(); numRowsRemaining > 0; --numRowsRemaining) {
                int rowToProcess = this.streamingState.rollingPart.size() - numRowsRemaining;
                if (rowToProcess < 0) continue;
                out = this.evaluateWindowFunction(wFn, rowToProcess, this.streamingState.rollingPart);
                this.streamingState.fnOutputs[i].add(out);
            }
        }
        ArrayList<Object> oRows = new ArrayList<Object>();
        while (!this.streamingState.rollingPart.processedAllRows() && !this.streamingState.rankLimitReached()) {
            boolean hasRow = this.streamingState.hasOutputRow();
            if (!hasRow && !this.streamingState.rankLimitReached()) {
                throw new HiveException("Internal Error: cannot generate all output rows for a Partition");
            }
            if (!hasRow) continue;
            oRows.add(this.streamingState.nextOutputRow());
        }
        return oRows.size() == 0 ? null : oRows;
    }

    @Override
    public boolean canIterateOutput() {
        return true;
    }

    @Override
    public Iterator<Object> iterator(PTFPartition.PTFPartitionIterator<Object> pItr) throws HiveException {
        WindowTableFunctionDef wTFnDef = (WindowTableFunctionDef)this.getTableDef();
        ArrayList<Object> output = new ArrayList<Object>();
        List[] outputFromPivotFunctions = new List[wTFnDef.getWindowFunctions().size()];
        ArrayList<Integer> wFnsWithWindows = new ArrayList<Integer>();
        PTFPartition iPart = pItr.getPartition();
        int i = 0;
        for (WindowFunctionDef wFn : wTFnDef.getWindowFunctions()) {
            boolean processWindow = WindowingTableFunction.processWindow(wFn.getWindowFrame());
            pItr.reset();
            if (!processWindow && !wFn.isPivotResult()) {
                Object out = this.evaluateFunctionOnPartition(wFn, iPart);
                output.add(out);
            } else if (wFn.isPivotResult()) {
                GenericUDAFEvaluator streamingEval = wFn.getWFnEval().getWindowingEvaluator(wFn.getWindowFrame());
                if (streamingEval != null && streamingEval instanceof ISupportStreamingModeForWindowing) {
                    ISupportStreamingModeForWindowing strEval = (ISupportStreamingModeForWindowing)((Object)streamingEval);
                    if (strEval.getRowsRemainingAfterTerminate() == 0) {
                        wFn.setWFnEval(streamingEval);
                        if (wFn.getOI() instanceof ListObjectInspector) {
                            ListObjectInspector listOI = (ListObjectInspector)wFn.getOI();
                            wFn.setOI(listOI.getListElementObjectInspector());
                        }
                        output.add(null);
                        wFnsWithWindows.add(i);
                    } else {
                        outputFromPivotFunctions[i] = (List)this.evaluateFunctionOnPartition(wFn, iPart);
                        output.add(null);
                    }
                } else {
                    outputFromPivotFunctions[i] = (List)this.evaluateFunctionOnPartition(wFn, iPart);
                    output.add(null);
                }
            } else {
                output.add(null);
                wFnsWithWindows.add(i);
            }
            ++i;
        }
        for (i = 0; i < iPart.getOutputOI().getAllStructFieldRefs().size(); ++i) {
            output.add(null);
        }
        if (wTFnDef.getRankLimit() != -1) {
            this.rnkLimitDef = new RankLimit(wTFnDef.getRankLimit(), wTFnDef.getRankLimitFunction(), wTFnDef.getWindowFunctions());
        }
        return new WindowingIterator(iPart, output, outputFromPivotFunctions, ArrayUtils.toPrimitive((Integer[])wFnsWithWindows.toArray(new Integer[wFnsWithWindows.size()])));
    }

    public static class SameList<E>
    extends AbstractList<E> {
        int sz;
        E val;

        public SameList(int sz, E val) {
            this.sz = sz;
            this.val = val;
        }

        @Override
        public E get(int index) {
            return this.val;
        }

        @Override
        public int size() {
            return this.sz;
        }
    }

    static class WindowingFunctionInfoHelper {
        private boolean supportsWindow;

        WindowingFunctionInfoHelper() {
        }

        public WindowingFunctionInfoHelper(boolean supportsWindow) {
            this.supportsWindow = supportsWindow;
        }

        public boolean isSupportsWindow() {
            return this.supportsWindow;
        }

        public void setSupportsWindow(boolean supportsWindow) {
            this.supportsWindow = supportsWindow;
        }
    }

    static class RankLimit {
        final int rankLimit;
        int currentRank;
        final int rankFnIdx;
        final PrimitiveObjectInspector fnOutOI;

        RankLimit(int rankLimit, int rankFnIdx, List<WindowFunctionDef> wdwFnDefs) {
            this.rankLimit = rankLimit;
            this.rankFnIdx = rankFnIdx;
            this.fnOutOI = (PrimitiveObjectInspector)wdwFnDefs.get(rankFnIdx).getOI();
            this.currentRank = -1;
        }

        RankLimit(RankLimit rl) {
            this.rankLimit = rl.rankLimit;
            this.rankFnIdx = rl.rankFnIdx;
            this.fnOutOI = rl.fnOutOI;
            this.currentRank = -1;
        }

        void reset() {
            this.currentRank = -1;
        }

        void updateRank(List<Object> oRow) {
            int r = (Integer)this.fnOutOI.getPrimitiveJavaObject(oRow.get(this.rankFnIdx));
            if (r > this.currentRank) {
                this.currentRank = r;
            }
        }

        boolean limitReached() {
            return this.currentRank >= this.rankLimit;
        }
    }

    class StreamingState {
        PTFRollingPartition rollingPart;
        List<Object>[] fnOutputs;
        GenericUDAFEvaluator.AggregationBuffer[] aggBuffers;
        Object[][] funcArgs;
        RankLimit rnkLimit;

        StreamingState(WindowingTableFunction this$0, Configuration cfg, StructObjectInspector inputOI, boolean isMapSide, WindowTableFunctionDef tabDef, int precedingSpan, int followingSpan) throws HiveException {
            AbstractSerDe serde = isMapSide ? tabDef.getInput().getOutputShape().getSerde() : tabDef.getRawInputShape().getSerde();
            StructObjectInspector outputOI = isMapSide ? tabDef.getInput().getOutputShape().getOI() : tabDef.getRawInputShape().getOI();
            this.rollingPart = PTFPartition.createRolling(cfg, serde, inputOI, outputOI, precedingSpan, followingSpan);
            int numFns = tabDef.getWindowFunctions().size();
            this.fnOutputs = new ArrayList[numFns];
            this.aggBuffers = new GenericUDAFEvaluator.AggregationBuffer[numFns];
            this.funcArgs = new Object[numFns][];
            for (int i = 0; i < numFns; ++i) {
                this.fnOutputs[i] = new ArrayList<Object>();
                WindowFunctionDef wFn = tabDef.getWindowFunctions().get(i);
                this.funcArgs[i] = new Object[wFn.getArgs() == null ? 0 : wFn.getArgs().size()];
                this.aggBuffers[i] = wFn.getWFnEval().getNewAggregationBuffer();
            }
            if (this$0.rnkLimitDef != null) {
                this.rnkLimit = new RankLimit(this$0.rnkLimitDef);
            }
        }

        void reset(WindowTableFunctionDef tabDef) throws HiveException {
            int i;
            int numFns = tabDef.getWindowFunctions().size();
            this.rollingPart.reset();
            for (i = 0; i < this.fnOutputs.length; ++i) {
                this.fnOutputs[i].clear();
            }
            for (i = 0; i < numFns; ++i) {
                WindowFunctionDef wFn = tabDef.getWindowFunctions().get(i);
                this.aggBuffers[i] = wFn.getWFnEval().getNewAggregationBuffer();
            }
            if (this.rnkLimit != null) {
                this.rnkLimit.reset();
            }
        }

        boolean hasOutputRow() {
            if (this.rankLimitReached()) {
                return false;
            }
            for (int i = 0; i < this.fnOutputs.length; ++i) {
                if (this.fnOutputs[i].size() != 0) continue;
                return false;
            }
            return true;
        }

        private List<Object> nextOutputRow() throws HiveException {
            ArrayList<Object> oRow = new ArrayList<Object>();
            Object iRow = this.rollingPart.nextOutputRow();
            for (int i = 0; i < this.fnOutputs.length; ++i) {
                oRow.add(this.fnOutputs[i].remove(0));
            }
            for (StructField f : this.rollingPart.getOutputOI().getAllStructFieldRefs()) {
                oRow.add(this.rollingPart.getOutputOI().getStructFieldData(iRow, f));
            }
            if (this.rnkLimit != null) {
                this.rnkLimit.updateRank(oRow);
            }
            return oRow;
        }

        boolean rankLimitReached() {
            return this.rnkLimit != null && this.rnkLimit.limitReached();
        }
    }

    public class WindowingIterator
    implements Iterator<Object> {
        ArrayList<Object> output;
        List<?>[] outputFromPivotFunctions;
        int currIdx;
        PTFPartition iPart;
        int[] wFnsToProcess;
        WindowTableFunctionDef wTFnDef;
        PTFDesc ptfDesc;
        StructObjectInspector inputOI;
        GenericUDAFEvaluator.AggregationBuffer[] aggBuffers;
        Object[][] args;
        RankLimit rnkLimit;

        WindowingIterator(PTFPartition iPart, ArrayList<Object> output, List<?>[] outputFromPivotFunctions, int[] wFnsToProcess) {
            this.iPart = iPart;
            this.output = output;
            this.outputFromPivotFunctions = outputFromPivotFunctions;
            this.wFnsToProcess = wFnsToProcess;
            this.currIdx = 0;
            this.wTFnDef = (WindowTableFunctionDef)WindowingTableFunction.this.getTableDef();
            this.ptfDesc = WindowingTableFunction.this.getQueryDef();
            this.inputOI = iPart.getOutputOI();
            this.aggBuffers = new GenericUDAFEvaluator.AggregationBuffer[this.wTFnDef.getWindowFunctions().size()];
            this.args = new Object[this.wTFnDef.getWindowFunctions().size()][];
            try {
                for (int j : wFnsToProcess) {
                    WindowFunctionDef wFn = this.wTFnDef.getWindowFunctions().get(j);
                    this.aggBuffers[j] = wFn.getWFnEval().getNewAggregationBuffer();
                    this.args[j] = new Object[wFn.getArgs() == null ? 0 : wFn.getArgs().size()];
                }
            }
            catch (HiveException he) {
                throw new RuntimeException(he);
            }
            if (WindowingTableFunction.this.rnkLimitDef != null) {
                this.rnkLimit = new RankLimit(WindowingTableFunction.this.rnkLimitDef);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.rnkLimit != null && this.rnkLimit.limitReached()) {
                return false;
            }
            return this.currIdx < this.iPart.size();
        }

        @Override
        public Object next() {
            int i;
            for (i = 0; i < this.outputFromPivotFunctions.length; ++i) {
                if (this.outputFromPivotFunctions[i] == null) continue;
                this.output.set(i, this.outputFromPivotFunctions[i].get(this.currIdx));
            }
            try {
                for (int j : this.wFnsToProcess) {
                    WindowFunctionDef wFn = this.wTFnDef.getWindowFunctions().get(j);
                    if (wFn.getWFnEval() instanceof ISupportStreamingModeForWindowing) {
                        Object iRow = this.iPart.getAt(this.currIdx);
                        int a = 0;
                        if (wFn.getArgs() != null) {
                            for (PTFExpressionDef arg : wFn.getArgs()) {
                                this.args[j][a++] = arg.getExprEvaluator().evaluate(iRow);
                            }
                        }
                        wFn.getWFnEval().aggregate(this.aggBuffers[j], this.args[j]);
                        Object out = ((ISupportStreamingModeForWindowing)((Object)wFn.getWFnEval())).getNextResult(this.aggBuffers[j]);
                        if (out != null) {
                            out = out == ISupportStreamingModeForWindowing.NULL_RESULT ? null : ObjectInspectorUtils.copyToStandardObject((Object)out, (ObjectInspector)wFn.getOI());
                        }
                        this.output.set(j, out);
                        continue;
                    }
                    Object out = WindowingTableFunction.this.evaluateWindowFunction(wFn, this.currIdx, this.iPart);
                    this.output.set(j, out);
                }
                Object iRow = this.iPart.getAt(this.currIdx);
                i = this.wTFnDef.getWindowFunctions().size();
                for (StructField f : this.inputOI.getAllStructFieldRefs()) {
                    this.output.set(i++, this.inputOI.getStructFieldData(iRow, f));
                }
            }
            catch (HiveException he) {
                throw new RuntimeException(he);
            }
            if (this.rnkLimit != null) {
                this.rnkLimit.updateRank(this.output);
            }
            ++this.currIdx;
            return this.output;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class WindowingTableFunctionResolver
    extends TableFunctionResolver {
        private transient StructObjectInspector wdwProcessingOutputOI;

        public StructObjectInspector getWdwProcessingOutputOI() {
            return this.wdwProcessingOutputOI;
        }

        public void setWdwProcessingOutputOI(StructObjectInspector wdwProcessingOutputOI) {
            this.wdwProcessingOutputOI = wdwProcessingOutputOI;
        }

        @Override
        protected TableFunctionEvaluator createEvaluator(PTFDesc ptfDesc, PartitionedTableFunctionDef tDef) {
            return new WindowingTableFunction();
        }

        @Override
        public void setupOutputOI() throws SemanticException {
            this.setOutputOI(this.wdwProcessingOutputOI);
        }

        @Override
        public void initializeOutputOI() throws HiveException {
            this.setupOutputOI();
        }

        @Override
        public boolean transformsRawInput() {
            return false;
        }

        @Override
        public boolean carryForwardNames() {
            return true;
        }

        public ArrayList<String> getOutputColumnNames() {
            return null;
        }
    }
}

