/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="locate,position", value="_FUNC_(substr, str[, pos]) - Returns the position of the first occurance of substr in str after position pos", extended="Example:\n  > SELECT _FUNC_('bar', 'foobarbar', 5) FROM src LIMIT 1;\n  7")
public class GenericUDFLocate
extends GenericUDF {
    private transient ObjectInspectorConverters.Converter[] converters;
    private final IntWritable intWritable = new IntWritable(0);

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        int i;
        if (arguments.length != 2 && arguments.length != 3) {
            throw new UDFArgumentLengthException("The function LOCATE accepts exactly 2 or 3 arguments.");
        }
        for (i = 0; i < arguments.length; ++i) {
            ObjectInspector.Category category = arguments[i].getCategory();
            if (category == ObjectInspector.Category.PRIMITIVE) continue;
            throw new UDFArgumentTypeException(i, "The " + GenericUDFUtils.getOrdinal(i + 1) + " argument of function LOCATE is expected to a " + ObjectInspector.Category.PRIMITIVE.toString().toLowerCase() + " type, but " + category.toString().toLowerCase() + " is found");
        }
        this.converters = new ObjectInspectorConverters.Converter[arguments.length];
        for (i = 0; i < arguments.length; ++i) {
            if (i == 0 || i == 1) {
                this.converters[i] = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[i], (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                continue;
            }
            if (i != 2) continue;
            this.converters[i] = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[i], (ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        }
        return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments[0].get() == null || arguments[1].get() == null) {
            return null;
        }
        Text subtext = (Text)this.converters[0].convert(arguments[0].get());
        Text text = (Text)this.converters[1].convert(arguments[1].get());
        int start = 1;
        if (arguments.length == 3) {
            IntWritable startWritable = (IntWritable)this.converters[2].convert(arguments[2].get());
            if (startWritable == null) {
                this.intWritable.set(0);
                return this.intWritable;
            }
            start = startWritable.get();
        }
        this.intWritable.set(GenericUDFUtils.findText(text, subtext, start - 1) + 1);
        return this.intWritable;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 2 || children.length == 3);
        return this.getStandardDisplayString("locate", children);
    }
}

