/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCLineString;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.udf.esri.GeometryUtils;
import org.apache.hadoop.hive.ql.udf.esri.LogUtils;
import org.apache.hadoop.hive.ql.udf.esri.ST_GeometryAccessor;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="ST_IsRing", value="_FUNC_(ST_LineString) - return true if the linestring is closed & simple", extended="Example:\n  SELECT _FUNC_(ST_LineString(0.,0., 3.,4., 0.,4., 0.,0.)) FROM src LIMIT 1;  -- true\n  SELECT _FUNC_(ST_LineString(0.,0., 1.,1., 1.,2., 2.,1., 1.,1., 0.,0.)) FROM src LIMIT 1;  -- false\n  SELECT _FUNC_(ST_LineString(0.,0., 3.,4.)) FROM src LIMIT 1;  -- false\n")
public class ST_IsRing
extends ST_GeometryAccessor {
    final BooleanWritable resultBoolean = new BooleanWritable();
    static final Logger LOG = LoggerFactory.getLogger((String)ST_IsRing.class.getName());

    public BooleanWritable evaluate(BytesWritable geomref) {
        if (geomref == null || geomref.getLength() == 0) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape(geomref);
        if (ogcGeometry == null) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        try {
            switch (GeometryUtils.getType(geomref)) {
                case ST_LINESTRING: {
                    OGCLineString lns = (OGCLineString)ogcGeometry;
                    this.resultBoolean.set(lns.isClosed() && lns.isSimple());
                    return this.resultBoolean;
                }
            }
            LogUtils.Log_InvalidType(LOG, GeometryUtils.OGCType.ST_LINESTRING, GeometryUtils.getType(geomref));
            return null;
        }
        catch (Exception e) {
            LogUtils.Log_InternalError(LOG, "ST_IsRing" + String.valueOf(e));
            return null;
        }
    }
}

