/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncSinhDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncSinhLongToDouble;
import org.apache.hadoop.hive.ql.udf.UDFMath;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@Description(name="sinh", value="_FUNC_(x) - returns the hyperbolic sin of x (x is in radians)", extended="Example:\n   > SELECT _FUNC_(0) FROM src LIMIT 1;\n  0")
@VectorizedExpressions(value={FuncSinhLongToDouble.class, FuncSinhDoubleToDouble.class})
public class UDFSinh
extends UDFMath {
    private final DoubleWritable result = new DoubleWritable();

    @Override
    protected DoubleWritable doEvaluate(DoubleWritable a) {
        this.result.set(StrictMath.sinh(a.get()));
        return this.result;
    }
}

