/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFMethodResolver;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class TimestampCastRestrictorResolver
implements UDFMethodResolver {
    private UDFMethodResolver parentResolver;
    private boolean strictTsConversion;

    public TimestampCastRestrictorResolver(UDFMethodResolver parentResolver) {
        this.parentResolver = parentResolver;
        SessionState ss = SessionState.get();
        if (ss != null && ss.getConf().getBoolVar(HiveConf.ConfVars.HIVE_STRICT_TIMESTAMP_CONVERSION)) {
            this.strictTsConversion = true;
        }
    }

    public Method getEvalMethod(List<TypeInfo> argClasses) throws UDFArgumentException {
        PrimitiveTypeInfo primitiveTypeInfo;
        PrimitiveObjectInspector.PrimitiveCategory category;
        PrimitiveObjectInspectorUtils.PrimitiveGrouping group;
        TypeInfo arg;
        if (this.strictTsConversion && (arg = argClasses.get(0)) instanceof PrimitiveTypeInfo && (group = PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)(category = (primitiveTypeInfo = (PrimitiveTypeInfo)arg).getPrimitiveCategory()))) == PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP) {
            throw new UDFArgumentException("Casting DATE/TIMESTAMP types to NUMERIC is prohibited (" + String.valueOf(HiveConf.ConfVars.HIVE_STRICT_TIMESTAMP_CONVERSION) + ")");
        }
        return this.parentResolver.getEvalMethod(argClasses);
    }
}

