/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.reexec;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHook;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHookContext;
import org.apache.hadoop.hive.ql.reexec.IReExecutionPlugin;
import org.apache.hadoop.hive.ql.reexec.ReCompileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReCompileWithoutCBOPlugin
implements IReExecutionPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ReCompileWithoutCBOPlugin.class);
    private Driver driver;
    private boolean retryPossible;
    private String cboMsg;

    @Override
    public void initialize(Driver driver) {
        this.driver = driver;
        driver.getHookRunner().addLifeTimeHook(new LocalHook());
    }

    @Override
    public void prepareToReCompile() {
        HiveConf conf = this.driver.getConf();
        conf.setBoolVar(HiveConf.ConfVars.HIVE_CBO_ENABLED, false);
        this.driver.getContext().setCboInfo(this.cboMsg);
    }

    @Override
    public boolean shouldReCompile(int executionNum) {
        return this.retryPossible && executionNum == 1;
    }

    class LocalHook
    implements QueryLifeTimeHook {
        LocalHook() {
        }

        @Override
        public void beforeCompile(QueryLifeTimeHookContext ctx) {
        }

        @Override
        public void afterCompile(QueryLifeTimeHookContext ctx, boolean hasError) {
            if (hasError) {
                Throwable throwable = ctx.getHookContext().getException();
                ReCompileWithoutCBOPlugin.this.retryPossible = throwable != null && throwable instanceof ReCompileException;
                ReCompileWithoutCBOPlugin.this.cboMsg = ReCompileWithoutCBOPlugin.this.retryPossible ? ((ReCompileException)throwable).getCboMessage() : null;
                LOG.debug("Recompile check result {} with CBO message {}", (Object)ReCompileWithoutCBOPlugin.this.retryPossible, (Object)ReCompileWithoutCBOPlugin.this.cboMsg);
            } else {
                ReCompileWithoutCBOPlugin.this.retryPossible = false;
            }
        }

        @Override
        public void beforeExecution(QueryLifeTimeHookContext ctx) {
        }

        @Override
        public void afterExecution(QueryLifeTimeHookContext ctx, boolean hasError) {
        }
    }
}

