/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.queryhistory.schema;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.queryhistory.schema.Schema;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.io.Writable;
import org.apache.hive.common.util.HiveVersionInfo;

public class Record {
    private long estimatedSizeInMemoryBytes = 0L;
    protected final Map<String, Object> record = new HashMap<String, Object>();

    public Record() {
        this.set(Schema.Field.QUERY_HISTORY_SCHEMA_VERSION, 1);
        this.set(Schema.Field.HIVE_VERSION, HiveVersionInfo.getVersion());
    }

    public void setQueryId(String queryId) {
        this.set(Schema.Field.QUERY_ID, queryId);
    }

    public void setSessionId(String sessionId) {
        this.set(Schema.Field.SESSION_ID, sessionId);
    }

    public void setOperationId(String operationId) {
        this.set(Schema.Field.OPERATION_ID, operationId);
    }

    public void setExecutionEngine(String executionEngine) {
        this.set(Schema.Field.EXECUTION_ENGINE, executionEngine);
    }

    public void setExecutionMode(String executionMode) {
        this.set(Schema.Field.EXECUTION_MODE, executionMode);
    }

    public void setDagId(String dagId) {
        this.set(Schema.Field.TEZ_DAG_ID, dagId);
    }

    public void setClusterId(String clusterId) {
        this.set(Schema.Field.CLUSTER_ID, clusterId);
    }

    public void setTezApplicationId(String applicationId) {
        this.set(Schema.Field.TEZ_APP_ID, applicationId);
    }

    public void setTezSessionId(String sessionId) {
        this.set(Schema.Field.TEZ_SESSION_ID, sessionId);
    }

    public void setSessionType(String sessionType) {
        this.set(Schema.Field.SESSION_TYPE, sessionType);
    }

    public void setClientProtocol(int clientProtocol) {
        this.set(Schema.Field.HIVERSERVER2_PROTOCOL_VERSION, clientProtocol);
    }

    public void setClusterUser(String username) {
        this.set(Schema.Field.CLUSTER_USER, username);
    }

    public void setEndUser(String userNameConnection) {
        this.set(Schema.Field.END_USER, userNameConnection);
    }

    public void setQuerySql(String querySql) {
        this.set(Schema.Field.SQL, querySql);
    }

    public void setCurrentDatabase(String currentDatabase) {
        this.set(Schema.Field.DB_NAME, currentDatabase);
    }

    public void setTezAmAddress(String amAddress) {
        this.set(Schema.Field.TEZ_COORDINATOR, amAddress);
    }

    public void setQueryState(String state) {
        this.set(Schema.Field.QUERY_STATE, state);
    }

    public void setQueryType(QueryProperties.QueryType type) {
        this.set(Schema.Field.QUERY_TYPE, type == null ? QueryProperties.QueryType.OTHER.getName() : type.getName());
    }

    public void setOperation(String operation) {
        this.set(Schema.Field.OPERATION, operation);
    }

    public void setServerAddress(String serverAddress) {
        this.set(Schema.Field.SERVER_ADDRESS, serverAddress);
    }

    public void setServerPort(int serverPort) {
        this.set(Schema.Field.SERVER_PORT, serverPort);
    }

    public void setClientAddress(String userIpAddress) {
        this.set(Schema.Field.CLIENT_ADDRESS, userIpAddress);
    }

    public void setQueryStartTime(long beginTimeEpochMillis) {
        this.set(Schema.Field.START_TIME_UTC, Timestamp.ofEpochMilli((long)beginTimeEpochMillis));
        this.set(Schema.Field.START_TIME, Timestamp.ofEpochMilli((long)beginTimeEpochMillis, (ZoneId)ZoneId.systemDefault()));
    }

    public void setQueryEndTime(long endTimeEpochMillis) {
        this.set(Schema.Field.END_TIME_UTC, Timestamp.ofEpochMilli((long)endTimeEpochMillis));
        this.set(Schema.Field.END_TIME, Timestamp.ofEpochMilli((long)endTimeEpochMillis, (ZoneId)ZoneId.systemDefault()));
    }

    public void setTotalTime(long elapsedTime) {
        this.set(Schema.Field.TOTAL_TIME_MS, elapsedTime);
    }

    public void setPlanningDuration(long duration) {
        this.set(Schema.Field.PLANNING_DURATION, duration);
    }

    public void setPlanningStartTime(long startTime) {
        this.set(Schema.Field.PLANNING_START_TIME, this.timeToNullDefault(startTime));
    }

    public void setPreparePlanDuration(long duration) {
        this.set(Schema.Field.PREPARE_PLAN_DURATION, duration);
    }

    public void setPreparePlanStartTime(long startTime) {
        this.set(Schema.Field.PREPARE_PLAN_START_TIME, this.timeToNullDefault(startTime));
    }

    public void setGetSessionDuration(long duration) {
        this.set(Schema.Field.GET_SESSION_DURATION, duration);
    }

    public void setGetSessionStartTime(long startTime) {
        this.set(Schema.Field.GET_SESSION_START_TIME, this.timeToNullDefault(startTime));
    }

    public void setExecutionDuration(long duration) {
        this.set(Schema.Field.EXECUTION_DURATION, duration);
    }

    public void setExecutionStartTime(long startTime) {
        this.set(Schema.Field.EXECUTION_START_TIME, this.timeToNullDefault(startTime));
    }

    public void setFailureReason(String errorMessage) {
        this.set(Schema.Field.FAILURE_REASON, errorMessage);
    }

    public void setNumRowsFetched(int totalRows) {
        this.set(Schema.Field.NUM_ROWS_FETCHED, totalRows);
    }

    public void setPlan(String explainPlan) {
        this.set(Schema.Field.PLAN, explainPlan);
    }

    public void setUsedTables(Set<String> usedTables) {
        this.set(Schema.Field.USED_TABLES, String.join((CharSequence)",", usedTables));
    }

    public void setExecSummary(String summary) {
        this.set(Schema.Field.EXEC_SUMMARY, summary);
    }

    public void setConfigurationOptionsChanged(Map<String, String> overriddenConfigurations) {
        this.set(Schema.Field.CONFIGURATION_OPTIONS_CHANGED, Joiner.on((String)";").withKeyValueSeparator("=").join(overriddenConfigurations));
    }

    public void setTotalNumberOfTasks(int numTasks) {
        this.set(Schema.Field.TOTAL_LAUNCHED_TASKS, numTasks);
    }

    public void setNumberOfSucceededTasks(int numSucceededTasks) {
        this.set(Schema.Field.NUM_SUCCEEDED_TASKS, numSucceededTasks);
    }

    public void setNumberOfKilledTasks(int numKilledTasks) {
        this.set(Schema.Field.NUM_KILLED_TASKS, numKilledTasks);
    }

    public void setNumberOfFailedTasks(int numFailedTasks) {
        this.set(Schema.Field.NUM_FAILED_TASKS, numFailedTasks);
    }

    public void setNodeUsedCount(int nodeUsedCount) {
        this.set(Schema.Field.NODE_USED_COUNT, nodeUsedCount);
    }

    public void setNodeTotalCount(int nodeTotalCount) {
        this.set(Schema.Field.NODE_TOTAL_COUNT, nodeTotalCount);
    }

    public void setReduceInputGroups(long reduceInputGroups) {
        this.set(Schema.Field.REDUCE_INPUT_GROUPS, reduceInputGroups);
    }

    public void setReduceInputRecords(long reduceInputRecords) {
        this.set(Schema.Field.REDUCE_INPUT_RECORDS, reduceInputRecords);
    }

    public void setSpilledRecords(long spilledRecords) {
        this.set(Schema.Field.SPILLED_RECORDS, spilledRecords);
    }

    public void setNumShuffledInputs(long numShuffledInputs) {
        this.set(Schema.Field.NUM_SHUFFLED_INPUTS, numShuffledInputs);
    }

    public void setNumFailedShuffleInputs(long numFailedShuffleInputs) {
        this.set(Schema.Field.NUM_FAILED_SHUFFLE_INPUTS, numFailedShuffleInputs);
    }

    public void setTaskDurationMillis(long taskDurationMillis) {
        this.set(Schema.Field.TASK_DURATION_MILLIS, taskDurationMillis);
    }

    public void setInputRecordsProcessed(long inputRecordsProcessed) {
        this.set(Schema.Field.INPUT_RECORDS_PROCESSED, inputRecordsProcessed);
    }

    public void setInputSplitLengthBytes(long inputSplitLengthBytes) {
        this.set(Schema.Field.INPUT_SPLIT_LENGTH_BYTES, inputSplitLengthBytes);
    }

    public void setOutputRecords(long outputRecords) {
        this.set(Schema.Field.OUTPUT_RECORDS, outputRecords);
    }

    public void setOutputBytesPhysical(long outputBytesPhysical) {
        this.set(Schema.Field.OUTPUT_BYTES_PHYSICAL, outputBytesPhysical);
    }

    public void setShuffleChunkCount(long shuffleChunkCount) {
        this.set(Schema.Field.SHUFFLE_CHUNK_COUNT, shuffleChunkCount);
    }

    public void setShuffleBytes(long shuffleBytes) {
        this.set(Schema.Field.SHUFFLE_BYTES, shuffleBytes);
    }

    public void setShuffleBytesDiskDirect(long shuffleBytesDiskDirect) {
        this.set(Schema.Field.SHUFFLE_BYTES_DISK_DIRECT, shuffleBytesDiskDirect);
    }

    public void setShufflePhaseTime(long shufflePhaseTime) {
        this.set(Schema.Field.SHUFFLE_PHASE_TIME, shufflePhaseTime);
    }

    public void setMergePhaseTime(long phaseTime) {
        this.set(Schema.Field.MERGE_PHASE_TIME, phaseTime);
    }

    public Object get(Schema.Field field) {
        return this.record.get(field.name);
    }

    private void set(Schema.Field field, Object value) {
        this.record.put(field.name, value);
    }

    public String toString() {
        return String.format("QueryHistoryRecord [queryId: %s, sessionId: %s]", this.get(Schema.Field.QUERY_ID), this.get(Schema.Field.SESSION_ID));
    }

    public Writable serialize(Serializer serializer) throws Exception {
        return serializer.serialize((Object)this.toSerializable(), Schema.INSPECTOR);
    }

    Object[] toSerializable() {
        Object[] record = new Object[Schema.Field.values().length];
        for (Schema.Field field : Schema.Field.values()) {
            record[field.ordinal()] = this.getFieldValue(field);
        }
        return record;
    }

    private Object getFieldValue(Schema.Field field) {
        return this.record.get(field.name);
    }

    private Timestamp timeToNullDefault(long time) {
        return time == 0L ? null : Timestamp.ofEpochMilli((long)time, (ZoneId)ZoneId.systemDefault());
    }

    public long getEstimatedSizeInMemoryBytes() {
        if (this.estimatedSizeInMemoryBytes > 0L) {
            return this.estimatedSizeInMemoryBytes;
        }
        long calculatedSize = Schema.BASE_RECORD_SIZE_IN_MEMORY_BYTES;
        calculatedSize += (long)this.getFieldSize(Schema.Field.FAILURE_REASON);
        calculatedSize += (long)this.getFieldSize(Schema.Field.CONFIGURATION_OPTIONS_CHANGED);
        calculatedSize += (long)this.getFieldSize(Schema.Field.EXEC_SUMMARY);
        calculatedSize += (long)this.getFieldSize(Schema.Field.PLAN);
        this.estimatedSizeInMemoryBytes = calculatedSize += (long)this.getFieldSize(Schema.Field.SQL);
        return this.estimatedSizeInMemoryBytes;
    }

    private int getFieldSize(Schema.Field field) {
        return Strings.nullToEmpty((String)((String)this.get(field))).length() * 2;
    }
}

