/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.plan.ConditionalResolver;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.LoadMultiFilesDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.MergeTaskProperties;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalResolverMergeFiles
implements ConditionalResolver,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ConditionalResolverMergeFiles.class);

    @Override
    public List<Task<?>> getTasks(HiveConf conf, Object objCtx) {
        ConditionalResolverMergeFilesCtx ctx = (ConditionalResolverMergeFilesCtx)objCtx;
        String dirName = ctx.getDir();
        ArrayList resTsks = new ArrayList();
        long trgtSize = conf.getLongVar(HiveConf.ConfVars.HIVE_MERGE_MAP_FILES_SIZE);
        long avgConditionSize = conf.getLongVar(HiveConf.ConfVars.HIVE_MERGE_MAP_FILES_AVG_SIZE);
        trgtSize = Math.max(trgtSize, avgConditionSize);
        Task<?> mvTask = ctx.getListTasks().get(0);
        Task<?> mrTask = ctx.getListTasks().get(1);
        Task<?> mrAndMvTask = ctx.getListTasks().get(2);
        try {
            Path dirPath = new Path(dirName);
            FileSystem inpFs = dirPath.getFileSystem((Configuration)conf);
            DynamicPartitionCtx dpCtx = ctx.getDPCtx();
            HiveStorageHandler storageHandler = HiveUtils.getStorageHandler((Configuration)conf, ctx.getStorageHandlerClass());
            boolean dirExists = inpFs.exists(dirPath);
            boolean useCustomStorageHandler = storageHandler != null && storageHandler.supportsMergeFiles();
            MapWork work = null;
            work = mrTask.getWork() instanceof MapredWork ? ((MapredWork)mrTask.getWork()).getMapWork() : (mrTask.getWork() instanceof TezWork ? (MapWork)((TezWork)mrTask.getWork()).getAllWork().get(0) : (MapWork)mrTask.getWork());
            if (dirExists) {
                int lbLevel = ctx.getLbCtx() == null ? 0 : ctx.getLbCtx().calculateListBucketingLevel();
                boolean manifestFilePresent = false;
                FileSystem manifestFs = dirPath.getFileSystem((Configuration)conf);
                if (manifestFs.exists(new Path(dirPath, "_blob_manifest_file"))) {
                    manifestFilePresent = true;
                }
                if (dpCtx != null && dpCtx.getNumDPCols() > 0) {
                    int numDPCols = dpCtx.getNumDPCols();
                    int dpLbLevel = numDPCols + lbLevel;
                    this.generateActualTasks(conf, resTsks, trgtSize, avgConditionSize, mvTask, mrTask, mrAndMvTask, dirPath, inpFs, ctx, work, dpLbLevel, manifestFilePresent, storageHandler);
                } else if (lbLevel == 0) {
                    long totalSize;
                    List<Object> manifestFilePaths = Lists.newArrayList();
                    if (manifestFilePresent) {
                        manifestFilePaths = this.getManifestFilePaths(conf, dirPath);
                        totalSize = this.getMergeSize(manifestFilePaths, avgConditionSize);
                    } else {
                        totalSize = this.getMergeSize(inpFs, dirPath, avgConditionSize);
                        Utilities.FILE_OP_LOGGER.debug("merge resolve simple case - totalSize " + totalSize + " from " + String.valueOf(dirPath));
                    }
                    if (totalSize >= 0L) {
                        if (manifestFilePresent) {
                            this.setupWorkWhenUsingManifestFile(work, manifestFilePaths, dirPath, true);
                        }
                        this.setupMapRedWork(conf, work, trgtSize, totalSize);
                        resTsks.add(mrTask);
                    } else {
                        resTsks.add(mvTask);
                    }
                } else {
                    this.generateActualTasks(conf, resTsks, trgtSize, avgConditionSize, mvTask, mrTask, mrAndMvTask, dirPath, inpFs, ctx, work, lbLevel, manifestFilePresent, storageHandler);
                }
            } else if (useCustomStorageHandler) {
                this.generateActualTasks(conf, resTsks, trgtSize, avgConditionSize, mvTask, mrTask, mrAndMvTask, dirPath, inpFs, ctx, work, 0, false, storageHandler);
            } else {
                Utilities.FILE_OP_LOGGER.info("Resolver returning movetask for " + String.valueOf(dirPath));
                resTsks.add(mvTask);
            }
        }
        catch (IOException e) {
            LOG.warn("Exception while getting tasks", (Throwable)e);
        }
        catch (ClassNotFoundException | HiveException e) {
            throw new RuntimeException("Failed to load storage handler: {}" + e.getMessage());
        }
        assert (resTsks.size() == 1);
        return resTsks;
    }

    private void generateActualTasks(HiveConf conf, List<Task<?>> resTsks, long trgtSize, long avgConditionSize, Task<?> mvTask, Task<?> mrTask, Task<?> mrAndMvTask, Path dirPath, FileSystem inpFs, ConditionalResolverMergeFilesCtx ctx, MapWork work, int dpLbLevel, boolean manifestFilePresent, HiveStorageHandler storageHandler) throws IOException, ClassNotFoundException {
        List statusList;
        MergeTaskProperties mergeProperties;
        DynamicPartitionCtx dpCtx = ctx.getDPCtx();
        Map<Object, Object> parentDirToFile = new HashMap();
        boolean useCustomStorageHandler = storageHandler != null && storageHandler.supportsMergeFiles();
        MergeTaskProperties mergeTaskProperties = mergeProperties = useCustomStorageHandler ? storageHandler.getMergeTaskProperties(ctx.getTaskProperties()) : null;
        if (manifestFilePresent) {
            fileStatuses = this.getManifestFilePaths(conf, dirPath);
            this.setupWorkWhenUsingManifestFile(work, fileStatuses, dirPath, false);
            parentDirToFile = this.getParentDirToFileMap(inpFs, fileStatuses);
            statusList = Lists.newArrayList(parentDirToFile.keySet());
        } else if (useCustomStorageHandler) {
            fileStatuses = storageHandler.getMergeTaskInputFiles(ctx.getTaskProperties());
            this.setupWorkWithCustomHandler(work, dirPath, mergeProperties);
            parentDirToFile = this.getParentDirToFileMap(inpFs, fileStatuses);
            statusList = Lists.newArrayList(parentDirToFile.keySet());
        } else {
            statusList = HiveStatsUtils.getFileStatusRecurse((Path)dirPath, (int)dpLbLevel, (FileSystem)inpFs);
        }
        FileStatus[] status = statusList.toArray(new FileStatus[statusList.size()]);
        Map<Path, PartitionDesc> ptpi = work.getPathToPartitionInfo();
        assert (ptpi.size() == 1);
        Path path = ptpi.keySet().iterator().next();
        PartitionDesc partDesc = ptpi.get(path);
        TableDesc tblDesc = partDesc.getTableDesc();
        Utilities.FILE_OP_LOGGER.debug("merge resolver removing " + String.valueOf(path));
        work.removePathToPartitionInfo(path);
        Map<Path, List<String>> pta = work.getPathToAliases();
        assert (pta.size() == 1);
        path = pta.keySet().iterator().next();
        List<String> aliases = pta.get(path);
        work.removePathToAlias(path);
        long totalSize = 0L;
        boolean doMerge = false;
        ArrayList<Path> toMove = new ArrayList<Path>();
        ArrayList<Path> toMerge = new ArrayList<Path>();
        for (int i = 0; i < status.length; ++i) {
            long len = manifestFilePresent || useCustomStorageHandler ? this.getMergeSize((List)parentDirToFile.get(status[i]), avgConditionSize) : this.getMergeSize(inpFs, status[i].getPath(), avgConditionSize);
            if (len >= 0L) {
                PartitionDesc pDesc;
                doMerge = true;
                totalSize += len;
                PartitionDesc partitionDesc = pDesc = dpCtx != null ? this.generateDPFullPartSpec(dpCtx, status, tblDesc, i) : partDesc;
                if (pDesc == null) {
                    Utilities.FILE_OP_LOGGER.warn("merger ignoring invalid DP path " + String.valueOf(status[i].getPath()));
                    continue;
                }
                Utilities.FILE_OP_LOGGER.debug("merge resolver will merge " + String.valueOf(status[i].getPath()));
                work.resolveDynamicPartitionStoredAsSubDirsMerge(conf, status[i].getPath(), tblDesc, aliases, pDesc);
                if (manifestFilePresent || useCustomStorageHandler) {
                    toMerge.addAll(((List)parentDirToFile.get(status[i])).stream().map(FileStatus::getPath).collect(Collectors.toList()));
                    continue;
                }
                toMerge.add(status[i].getPath());
                continue;
            }
            Utilities.FILE_OP_LOGGER.debug("merge resolver will move " + String.valueOf(status[i].getPath()));
            toMove.add(status[i].getPath());
        }
        if (doMerge) {
            if (work.getInputPaths() != null && !work.getInputPaths().isEmpty()) {
                toMerge.addAll(work.getInputPaths());
            }
            work.setInputPaths(toMerge);
            this.setupMapRedWork(conf, work, trgtSize, totalSize);
            if (toMove.size() > 0) {
                resTsks.add(mrAndMvTask);
                Task<?> mergeAndMoveMoveTask = mrAndMvTask.getChildTasks().get(0);
                MoveWork mvWork = (MoveWork)mergeAndMoveMoveTask.getWork();
                LoadFileDesc lfd = mvWork.getLoadFileWork();
                Path targetDir = lfd.getTargetDir();
                ArrayList<Path> targetDirs = new ArrayList<Path>(toMove.size());
                for (int i = 0; i < toMove.size(); ++i) {
                    String[] moveStrSplits = ((Path)toMove.get(i)).toString().split("/");
                    Path target = targetDir;
                    for (int dpIndex = moveStrSplits.length - dpLbLevel; dpIndex < moveStrSplits.length; ++dpIndex) {
                        target = new Path(target, moveStrSplits[dpIndex]);
                    }
                    targetDirs.add(target);
                }
                mvWork.setLoadFileWork(null);
                mvWork.setLoadTableWork(null);
                if (!useCustomStorageHandler) {
                    LoadMultiFilesDesc lmfd = new LoadMultiFilesDesc(toMove, targetDirs, lfd.getIsDfsDir(), lfd.getColumns(), lfd.getColumnTypes());
                    mvWork.setMultiFilesDesc(lmfd);
                }
            } else {
                resTsks.add(mrTask);
            }
        } else {
            resTsks.add(mvTask);
        }
    }

    private PartitionDesc generateDPFullPartSpec(DynamicPartitionCtx dpCtx, FileStatus[] status, TableDesc tblDesc, int i) {
        LinkedHashMap<String, String> fullPartSpec = new LinkedHashMap<String, String>(dpCtx.getPartSpec());
        if (!Warehouse.makeSpecFromName(fullPartSpec, (Path)status[i].getPath(), new HashSet<String>(dpCtx.getPartSpec().keySet()))) {
            return null;
        }
        return new PartitionDesc(tblDesc, fullPartSpec);
    }

    private void setupMapRedWork(HiveConf conf, MapWork mWork, long targetSize, long totalSize) {
        mWork.setMaxSplitSize(targetSize);
        mWork.setMinSplitSize(targetSize);
        mWork.setMinSplitSizePerNode(targetSize);
        mWork.setMinSplitSizePerRack(targetSize);
        mWork.setIsMergeFromResolver(true);
    }

    private FileSummary getFileSummary(List<FileStatus> fileStatusList) {
        LongSummaryStatistics stats = fileStatusList.stream().filter(FileStatus::isFile).mapToLong(FileStatus::getLen).summaryStatistics();
        return new FileSummary(stats.getSum(), stats.getCount());
    }

    private List<FileStatus> getManifestFilePaths(HiveConf conf, Path dirPath) throws IOException {
        ArrayList filesKept;
        FileSystem manifestFs = dirPath.getFileSystem((Configuration)conf);
        ArrayList<FileStatus> pathsKept = new ArrayList<FileStatus>();
        try (FSDataInputStream inStream = manifestFs.open(new Path(dirPath, "_blob_manifest_file"));){
            String paths = IOUtils.toString((InputStream)inStream, (Charset)Charset.defaultCharset());
            filesKept = Lists.newArrayList((Object[])paths.split(System.lineSeparator()));
        }
        filesKept.remove(0);
        for (String file : filesKept) {
            pathsKept.add(manifestFs.getFileStatus(new Path(file)));
        }
        return pathsKept;
    }

    private long getMergeSize(FileSystem inpFs, Path dirPath, long avgSize) {
        List result = FileUtils.getFileStatusRecurse((Path)dirPath, (FileSystem)inpFs);
        return this.getMergeSize(result, avgSize);
    }

    private long getMergeSize(List<FileStatus> fileStatuses, long avgSize) {
        FileSummary fileSummary = this.getFileSummary(fileStatuses);
        if (fileSummary.getTotalSize() <= 0L) {
            return -1L;
        }
        if (fileSummary.getNumFiles() <= 1L) {
            return -1L;
        }
        if (fileSummary.getTotalSize() / fileSummary.getNumFiles() < avgSize) {
            return fileSummary.getTotalSize();
        }
        return -1L;
    }

    private void setupWorkWhenUsingManifestFile(MapWork mapWork, List<FileStatus> fileStatuses, Path dirPath, boolean isTblLevel) {
        Map<String, Operator<? extends OperatorDesc>> aliasToWork = mapWork.getAliasToWork();
        Map<Path, PartitionDesc> pathToPartitionInfo = mapWork.getPathToPartitionInfo();
        Operator<? extends OperatorDesc> op = aliasToWork.get(dirPath.toString());
        PartitionDesc partitionDesc = pathToPartitionInfo.get(dirPath);
        Path tmpDirPath = Utilities.toTempPath(dirPath);
        if (op != null) {
            aliasToWork.remove(dirPath.toString());
            aliasToWork.put(tmpDirPath.toString(), op);
            mapWork.setAliasToWork(aliasToWork);
        }
        if (partitionDesc != null) {
            pathToPartitionInfo.remove(dirPath);
            pathToPartitionInfo.put(tmpDirPath, partitionDesc);
            mapWork.setPathToPartitionInfo(pathToPartitionInfo);
        }
        mapWork.removePathToAlias(dirPath);
        mapWork.addPathToAlias(tmpDirPath, tmpDirPath.toString());
        if (isTblLevel) {
            List<Path> inputPaths = fileStatuses.stream().filter(FileStatus::isFile).map(FileStatus::getPath).collect(Collectors.toList());
            mapWork.setInputPaths(inputPaths);
        }
        mapWork.setUseInputPathsDirectly(true);
    }

    private void setupWorkWithCustomHandler(MapWork mapWork, Path dirPath, MergeTaskProperties mergeProperties) throws IOException, ClassNotFoundException {
        Map<String, Operator<? extends OperatorDesc>> aliasToWork = mapWork.getAliasToWork();
        Map<Path, PartitionDesc> pathToPartitionInfo = mapWork.getPathToPartitionInfo();
        Operator<? extends OperatorDesc> op = aliasToWork.get(dirPath.toString());
        PartitionDesc partitionDesc = pathToPartitionInfo.get(dirPath);
        Path tmpDir = mergeProperties.getTmpLocation();
        if (op != null) {
            aliasToWork.remove(dirPath.toString());
            aliasToWork.put(tmpDir.toString(), op);
            mapWork.setAliasToWork(aliasToWork);
        }
        if (partitionDesc != null) {
            pathToPartitionInfo.remove(dirPath);
            pathToPartitionInfo.put(tmpDir, partitionDesc);
            mapWork.setPathToPartitionInfo(pathToPartitionInfo);
        }
        mapWork.setMergeSplitProperties(mergeProperties.getSplitProperties());
        mapWork.removePathToAlias(dirPath);
        mapWork.addPathToAlias(tmpDir, tmpDir.toString());
        mapWork.setUseInputPathsDirectly(true);
    }

    private Map<FileStatus, List<FileStatus>> getParentDirToFileMap(FileSystem inpFs, List<FileStatus> fileStatuses) throws IOException {
        HashMap<FileStatus, List<FileStatus>> manifestDirsToPaths = new HashMap<FileStatus, List<FileStatus>>();
        for (FileStatus fileStatus : fileStatuses) {
            if (fileStatus.isDirectory()) continue;
            FileStatus parentDir = inpFs.getFileStatus(fileStatus.getPath().getParent());
            ArrayList fileStatusList = Lists.newArrayList((Object[])new FileStatus[]{fileStatus});
            manifestDirsToPaths.merge(parentDir, fileStatusList, (oldValue, newValue) -> {
                oldValue.addAll(newValue);
                return oldValue;
            });
        }
        return manifestDirsToPaths;
    }

    public static class ConditionalResolverMergeFilesCtx
    implements Serializable {
        private static final long serialVersionUID = 1L;
        List<Task<?>> listTasks;
        private String dir;
        private DynamicPartitionCtx dpCtx;
        private ListBucketingCtx lbCtx;
        private Properties properties;
        private String storageHandlerClass;

        public ConditionalResolverMergeFilesCtx() {
        }

        public ConditionalResolverMergeFilesCtx(List<Task<?>> listTasks, String dir) {
            this.listTasks = listTasks;
            this.dir = dir;
        }

        public String getDir() {
            return this.dir;
        }

        public List<Task<?>> getListTasks() {
            return this.listTasks;
        }

        public void setListTasks(List<Task<?>> listTasks) {
            this.listTasks = listTasks;
        }

        public DynamicPartitionCtx getDPCtx() {
            return this.dpCtx;
        }

        public void setDPCtx(DynamicPartitionCtx dp) {
            this.dpCtx = dp;
        }

        public ListBucketingCtx getLbCtx() {
            return this.lbCtx;
        }

        public void setLbCtx(ListBucketingCtx lbCtx) {
            this.lbCtx = lbCtx;
        }

        public void setTaskProperties(Properties properties) {
            this.properties = properties;
        }

        public Properties getTaskProperties() {
            return this.properties;
        }

        public void setStorageHandlerClass(String className) {
            this.storageHandlerClass = className;
        }

        public String getStorageHandlerClass() {
            return this.storageHandlerClass;
        }
    }

    private static class FileSummary {
        private final long totalSize;
        private final long numFiles;

        public FileSummary(long totalSize, long numFiles) {
            this.totalSize = totalSize;
            this.numFiles = numFiles;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public long getNumFiles() {
            return this.numFiles;
        }
    }
}

