/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.messaging.CreateFunctionMessage;
import org.apache.hadoop.hive.ql.metadata.HiveFatalException;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.repl.CopyUtils;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AbstractEventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.FunctionSerializer;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.JsonWriter;

class CreateFunctionHandler
extends AbstractEventHandler<CreateFunctionMessage> {
    CreateFunctionHandler(NotificationEvent event) {
        super(event);
    }

    @Override
    CreateFunctionMessage eventMessage(String stringRepresentation) {
        return this.deserializer.getCreateFunctionMessage(stringRepresentation);
    }

    @Override
    public void handle(EventHandler.Context withinContext) throws Exception {
        Function functionObj = ((CreateFunctionMessage)this.eventMessage).getFunctionObj();
        if (functionObj.getResourceUris() == null || functionObj.getResourceUris().isEmpty()) {
            LOG.info("Not replicating function: " + functionObj.getFunctionName() + " as it seems to have been created without USING clause");
            return;
        }
        LOG.info("Processing#{} CREATE_FUNCTION message : {}", (Object)this.fromEventId(), (Object)this.eventMessageAsJSON);
        Path metadataPath = new Path(withinContext.eventRoot, "_metadata");
        Path dataPath = new Path(withinContext.eventRoot, "data");
        FileSystem fileSystem = metadataPath.getFileSystem((Configuration)withinContext.hiveConf);
        boolean copyAtLoad = withinContext.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_RUN_DATA_COPY_TASKS_ON_TARGET);
        ArrayList<EximUtil.DataCopyPath> functionBinaryCopyPaths = new ArrayList<EximUtil.DataCopyPath>();
        try (JsonWriter jsonWriter = new JsonWriter(fileSystem, metadataPath);){
            FunctionSerializer serializer = new FunctionSerializer(functionObj, dataPath, copyAtLoad, withinContext.hiveConf);
            serializer.writeTo(jsonWriter, withinContext.replicationSpec);
            functionBinaryCopyPaths.addAll(serializer.getFunctionBinaryCopyPaths());
        }
        withinContext.createDmd(this).write();
        this.copyFunctionBinaries(functionBinaryCopyPaths, withinContext.hiveConf);
    }

    private void copyFunctionBinaries(List<EximUtil.DataCopyPath> functionBinaryCopyPaths, HiveConf hiveConf) throws IOException, HiveFatalException {
        if (!functionBinaryCopyPaths.isEmpty()) {
            String distCpDoAsUser = hiveConf.getVar(HiveConf.ConfVars.HIVE_DISTCP_DOAS_USER);
            ArrayList<ReplChangeManager.FileInfo> filePaths = new ArrayList<ReplChangeManager.FileInfo>();
            for (EximUtil.DataCopyPath funcBinCopyPath : functionBinaryCopyPaths) {
                String[] decodedURISplits = ReplChangeManager.decodeFileUri((String)funcBinCopyPath.getSrcPath().toString());
                ReplChangeManager.FileInfo fileInfo = ReplChangeManager.getFileInfo((Path)new Path(decodedURISplits[0]), (String)decodedURISplits[1], (String)decodedURISplits[2], (String)decodedURISplits[3], (Configuration)hiveConf);
                filePaths.add(fileInfo);
                Path destRoot = funcBinCopyPath.getTargetPath().getParent();
                FileSystem dstFs = destRoot.getFileSystem((Configuration)hiveConf);
                CopyUtils copyUtils = new CopyUtils(distCpDoAsUser, hiveConf, dstFs);
                copyUtils.copyAndVerify(destRoot, filePaths, funcBinCopyPath.getSrcPath(), true, false);
                copyUtils.renameFileCopiedFromCmPath(destRoot, dstFs, filePaths);
            }
        }
    }

    @Override
    public DumpType dumpType() {
        return DumpType.EVENT_CREATE_FUNCTION;
    }
}

