/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.repl.util.FileList;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.PartitionIterable;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.repl.dump.TableExport;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.FileOperations;
import org.apache.hadoop.hive.ql.plan.ExportWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PartitionExport {
    private final TableExport.Paths paths;
    private final PartitionIterable partitionIterable;
    private final String distCpDoAsUser;
    private final HiveConf hiveConf;
    private final int nThreads;
    private final SessionState callersSession;
    private final ExportWork.MmContext mmCtx;
    private static final Logger LOG = LoggerFactory.getLogger(PartitionExport.class);

    PartitionExport(TableExport.Paths paths, PartitionIterable partitionIterable, String distCpDoAsUser, HiveConf hiveConf, ExportWork.MmContext mmCtx) {
        this.paths = paths;
        this.partitionIterable = partitionIterable;
        this.distCpDoAsUser = distCpDoAsUser;
        this.hiveConf = hiveConf;
        this.mmCtx = mmCtx;
        this.nThreads = hiveConf.getIntVar(HiveConf.ConfVars.REPL_PARTITIONS_DUMP_PARALLELISM);
        this.callersSession = SessionState.get();
    }

    List<EximUtil.DataCopyPath> write(ReplicationSpec forReplicationSpec, boolean isExportTask, FileList fileList, boolean dataCopyAtLoad) throws InterruptedException, HiveException {
        LinkedList futures = new LinkedList();
        LinkedList<EximUtil.DataCopyPath> managedTableCopyPaths = new LinkedList<EximUtil.DataCopyPath>();
        ThreadFactory namingThreadFactory = new ThreadFactoryBuilder().setNameFormat("partition-dump-thread-%d").build();
        ExecutorService consumer = Executors.newFixedThreadPool(this.nThreads, namingThreadFactory);
        for (Partition partition : this.partitionIterable) {
            LOG.debug("scheduling partition dump {}", (Object)partition.getName());
            Runnable r = () -> {
                String partitionName = part.getName();
                String threadName = Thread.currentThread().getName();
                LOG.debug("Thread: {}, start partition dump {}", (Object)threadName, (Object)partitionName);
                try {
                    List<Path> dataPathList = Utils.getDataPathList(part.getDataLocation(), forReplicationSpec, this.hiveConf);
                    Path rootDataDumpDir = isExportTask ? this.paths.partitionMetadataExportDir(partitionName) : this.paths.partitionDataExportDir(partitionName);
                    new FileOperations(dataPathList, rootDataDumpDir, this.distCpDoAsUser, this.hiveConf, this.mmCtx).export(isExportTask, dataCopyAtLoad);
                    Path dataDumpDir = new Path(this.paths.dataExportRootDir(), partitionName);
                    LOG.debug("Thread: {}, finish partition dump {}", (Object)threadName, (Object)partitionName);
                    if (!isExportTask && !dataCopyAtLoad) {
                        fileList.add(new EximUtil.DataCopyPath(forReplicationSpec, part.getDataLocation(), dataDumpDir).convertToString());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            };
            futures.add(consumer.submit(r));
        }
        consumer.shutdown();
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                LOG.error("Partition dump thread failed", e.getCause());
                throw new HiveException(e.getCause().getMessage(), e.getCause());
            }
        }
        consumer.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        return managedTableCopyPaths;
    }
}

