/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.stats.annotation;

import java.nio.ByteBuffer;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hive.common.util.Murmur3;

public class HiveMurmur3Adapter {
    private PrimitiveObjectInspector.PrimitiveCategory type;
    private PrimitiveObjectInspector inputOI;
    private final ByteBuffer LONG_BUFFER = ByteBuffer.allocate(8);

    public HiveMurmur3Adapter(PrimitiveObjectInspector oi) throws HiveException {
        this.inputOI = oi;
        this.type = oi.getTypeInfo().getPrimitiveCategory();
    }

    public long murmur3(Object objVal) throws HiveException {
        Object p = objVal;
        switch (this.type) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case TIMESTAMP: {
                long val = PrimitiveObjectInspectorUtils.getLong((Object)objVal, (PrimitiveObjectInspector)this.inputOI);
                this.LONG_BUFFER.putLong(0, val);
                return Murmur3.hash64((byte[])this.LONG_BUFFER.array());
            }
            case FLOAT: 
            case DOUBLE: {
                double val = PrimitiveObjectInspectorUtils.getDouble((Object)objVal, (PrimitiveObjectInspector)this.inputOI);
                this.LONG_BUFFER.putDouble(0, val);
                return Murmur3.hash64((byte[])this.LONG_BUFFER.array());
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                String val = PrimitiveObjectInspectorUtils.getString((Object)objVal, (PrimitiveObjectInspector)this.inputOI);
                return Murmur3.hash64((byte[])val.getBytes());
            }
            case DECIMAL: {
                HiveDecimal decimal = PrimitiveObjectInspectorUtils.getHiveDecimal((Object)p, (PrimitiveObjectInspector)this.inputOI);
                this.LONG_BUFFER.putDouble(0, decimal.doubleValue());
                return Murmur3.hash64((byte[])this.LONG_BUFFER.array());
            }
            case DATE: {
                DateWritable v = new DateWritable((DateWritable)this.inputOI.getPrimitiveWritableObject(p));
                int days = v.getDays();
                this.LONG_BUFFER.putLong(0, days);
                return Murmur3.hash64((byte[])this.LONG_BUFFER.array());
            }
        }
        throw new HiveException("type: " + String.valueOf(this.type) + " is not supported");
    }
}

