/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql2rel.CorrelationReferenceFinder;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveMultiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortExchange;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableFunctionScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.RelFieldTrimmer;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveRelFieldTrimmer
extends RelFieldTrimmer {
    protected static final Logger LOG = LoggerFactory.getLogger(HiveRelFieldTrimmer.class);
    private static final HiveRelFieldTrimmer FIELD_TRIMMER_STATS = new HiveRelFieldTrimmer(true);
    private static final HiveRelFieldTrimmer FIELD_TRIMMER_NO_STATS = new HiveRelFieldTrimmer(false);
    private static final HiveRelFieldTrimmer FIELD_TRIMMER_STATS_METHOD_DISPATCHER = new HiveRelFieldTrimmer(true, false);
    private static final HiveRelFieldTrimmer FIELD_TRIMMER_NO_STATS_METHOD_DISPATCHER = new HiveRelFieldTrimmer(false, false);
    private final boolean fetchStats;
    private static final ThreadLocal<ColumnAccessInfo> COLUMN_ACCESS_INFO = new ThreadLocal();
    private static final ThreadLocal<Map<RelNode, Table>> REL_TO_TABLE = new ThreadLocal();

    protected HiveRelFieldTrimmer(boolean fetchStats) {
        this(fetchStats, true);
    }

    private HiveRelFieldTrimmer(boolean fetchStats, boolean useLMFBasedDispatcher) {
        super(useLMFBasedDispatcher);
        this.fetchStats = fetchStats;
    }

    public static HiveRelFieldTrimmer get() {
        return HiveRelFieldTrimmer.get(false);
    }

    public static HiveRelFieldTrimmer get(boolean fetchStats) {
        return HiveRelFieldTrimmer.get(fetchStats, true);
    }

    public static HiveRelFieldTrimmer get(boolean fetchStats, boolean useLMFBasedDispatcher) {
        return fetchStats ? (useLMFBasedDispatcher ? FIELD_TRIMMER_STATS : FIELD_TRIMMER_STATS_METHOD_DISPATCHER) : (useLMFBasedDispatcher ? FIELD_TRIMMER_NO_STATS : FIELD_TRIMMER_NO_STATS_METHOD_DISPATCHER);
    }

    @Override
    public RelNode trim(RelBuilder relBuilder, RelNode root) {
        return this.trim(relBuilder, root, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelNode trim(RelBuilder relBuilder, RelNode root, ColumnAccessInfo columnAccessInfo, Map<RelNode, Table> relNodeToTable) {
        try {
            COLUMN_ACCESS_INFO.set(columnAccessInfo);
            REL_TO_TABLE.set(relNodeToTable);
            RelNode relNode = super.trim(relBuilder, root);
            return relNode;
        }
        finally {
            COLUMN_ACCESS_INFO.remove();
            REL_TO_TABLE.remove();
        }
    }

    @Override
    protected RelFieldTrimmer.TrimResult trimChild(RelNode rel, RelNode input, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        final ImmutableBitSet.Builder fieldsUsedBuilder = fieldsUsed.rebuild();
        for (final CorrelationId correlation : rel.getVariablesSet()) {
            rel.accept((RelShuttle)new CorrelationReferenceFinder(this){

                protected RexNode handle(RexFieldAccess fieldAccess) {
                    RexCorrelVariable v = (RexCorrelVariable)fieldAccess.getReferenceExpr();
                    if (v.id.equals((Object)correlation)) {
                        fieldsUsedBuilder.set(fieldAccess.getField().getIndex());
                    }
                    return fieldAccess;
                }
            });
        }
        return this.dispatchTrimFields(input, fieldsUsedBuilder.build(), extraFields);
    }

    @Override
    protected void preTrim(RelNode rel, ImmutableBitSet fieldsUsed) {
        this.setColumnAccessInfoForViews(rel, fieldsUsed);
    }

    protected void setColumnAccessInfoForViews(RelNode rel, ImmutableBitSet fieldsUsed) {
        ColumnAccessInfo columnAccessInfo = COLUMN_ACCESS_INFO.get();
        Map<RelNode, Table> relToTable = REL_TO_TABLE.get();
        if (!(rel instanceof HiveTableScan) && columnAccessInfo != null && relToTable != null && relToTable.containsKey(rel)) {
            Table table = relToTable.get(rel);
            String tableName = table.getCompleteName();
            List<FieldSchema> tableAllCols = table.getAllCols();
            Iterator iterator = fieldsUsed.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                columnAccessInfo.add(tableName, tableAllCols.get(i).getName());
            }
        }
    }

    public RelFieldTrimmer.TrimResult trimFields(HiveMultiJoin join, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        int fieldCount = join.getRowType().getFieldCount();
        RexNode conditionExpr = join.getCondition();
        List<RexNode> joinFilters = join.getJoinFilters();
        LinkedHashSet<RelDataTypeField> combinedInputExtraFields = new LinkedHashSet<RelDataTypeField>(extraFields);
        RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(combinedInputExtraFields, fieldsUsed);
        conditionExpr.accept((RexVisitor)inputFinder);
        ImmutableBitSet fieldsUsedPlus = inputFinder.build();
        int inputStartPos = 0;
        int changeCount = 0;
        int newFieldCount = 0;
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
        ArrayList<Mapping> inputMappings = new ArrayList<Mapping>();
        for (RelNode input : join.getInputs()) {
            RelDataType inputRowType = input.getRowType();
            int inputFieldCount = inputRowType.getFieldCount();
            ImmutableBitSet.Builder inputFieldsUsed = ImmutableBitSet.builder();
            Iterator iterator = fieldsUsedPlus.iterator();
            while (iterator.hasNext()) {
                int bit = (Integer)iterator.next();
                if (bit < inputStartPos || bit >= inputStartPos + inputFieldCount) continue;
                inputFieldsUsed.set(bit - inputStartPos);
            }
            Set inputExtraFields = Collections.emptySet();
            RelFieldTrimmer.TrimResult trimResult = this.trimChild((RelNode)join, input, inputFieldsUsed.build(), inputExtraFields);
            newInputs.add((RelNode)trimResult.left);
            if (trimResult.left != input) {
                ++changeCount;
            }
            Mapping inputMapping = (Mapping)trimResult.right;
            inputMappings.add(inputMapping);
            inputStartPos += inputFieldCount;
            newFieldCount += inputMapping.getTargetCount();
        }
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_SURJECTION, (int)fieldCount, (int)newFieldCount);
        int offset = 0;
        int newOffset = 0;
        for (int i = 0; i < inputMappings.size(); ++i) {
            Mapping inputMapping = (Mapping)inputMappings.get(i);
            for (Object pair : inputMapping) {
                mapping.set(((IntPair)pair).source + offset, ((IntPair)pair).target + newOffset);
            }
            offset += inputMapping.getSourceCount();
            newOffset += inputMapping.getTargetCount();
        }
        if (changeCount == 0 && mapping.isIdentity()) {
            return new RelFieldTrimmer.TrimResult((RelNode)join, (Mapping)Mappings.createIdentity((int)fieldCount));
        }
        RexPermuteInputsShuttle shuttle = new RexPermuteInputsShuttle((Mappings.TargetMapping)mapping, newInputs.toArray(new RelNode[newInputs.size()]));
        RexNode newConditionExpr = (RexNode)conditionExpr.accept((RexVisitor)shuttle);
        ArrayList newJoinFilters = Lists.newArrayList();
        for (RexNode joinFilter : joinFilters) {
            newJoinFilters.add((RexNode)joinFilter.accept((RexVisitor)shuttle));
        }
        RelDataType newRowType = RelOptUtil.permute((RelDataTypeFactory)join.getCluster().getTypeFactory(), (RelDataType)join.getRowType(), (Mapping)mapping);
        HiveMultiJoin newJoin = new HiveMultiJoin(join.getCluster(), newInputs, newConditionExpr, newRowType, join.getJoinInputs(), join.getJoinTypes(), newJoinFilters);
        return new RelFieldTrimmer.TrimResult((RelNode)newJoin, mapping);
    }

    public RelFieldTrimmer.TrimResult trimFields(DruidQuery dq, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        int fieldCount = dq.getRowType().getFieldCount();
        if (fieldsUsed.equals((Object)ImmutableBitSet.range((int)fieldCount)) && extraFields.isEmpty()) {
            return this.trimFields((RelNode)dq, fieldsUsed, extraFields);
        }
        RelNode newTableAccessRel = HiveRelFieldTrimmer.project(dq, fieldsUsed, extraFields, (RelBuilder)REL_BUILDER.get());
        if (fieldsUsed.cardinality() == 0) {
            Project project;
            RelNode input = newTableAccessRel;
            if (input instanceof Project && (project = (Project)input).getRowType().getFieldCount() == 0) {
                input = project.getInput();
            }
            return this.dummyProject(fieldCount, input);
        }
        Mapping mapping = this.createMapping(fieldsUsed, fieldCount);
        return this.result(newTableAccessRel, mapping);
    }

    private static RelNode project(DruidQuery dq, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields, RelBuilder relBuilder) {
        int fieldCount = dq.getRowType().getFieldCount();
        if (fieldsUsed.equals((Object)ImmutableBitSet.range((int)fieldCount)) && extraFields.isEmpty()) {
            return dq;
        }
        ArrayList<Object> exprList = new ArrayList<Object>();
        ArrayList<String> nameList = new ArrayList<String>();
        RexBuilder rexBuilder = dq.getCluster().getRexBuilder();
        List fields = dq.getRowType().getFieldList();
        Iterator<RelDataTypeField> iterator = fieldsUsed.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            RelDataTypeField field = (RelDataTypeField)fields.get(i);
            exprList.add(rexBuilder.makeInputRef((RelNode)dq, i));
            nameList.add(field.getName());
        }
        for (RelDataTypeField extraField : extraFields) {
            exprList.add(rexBuilder.ensureType(extraField.getType(), (RexNode)rexBuilder.constantNull(), true));
            nameList.add(extraField.getName());
        }
        HiveProject hp = (HiveProject)relBuilder.push((RelNode)dq).project(exprList, nameList).build();
        hp.setSynthetic();
        return hp;
    }

    private boolean isRexLiteral(RexNode rexNode) {
        if (rexNode instanceof RexLiteral) {
            return true;
        }
        if (rexNode instanceof RexCall && ((RexCall)rexNode).getOperator().getKind() == SqlKind.CAST) {
            return this.isRexLiteral((RexNode)((RexCall)rexNode).getOperands().get(0));
        }
        return false;
    }

    private ImmutableBitSet generateGroupSetIfCardinalitySame(Aggregate aggregate, ImmutableBitSet originalGroupSet, ImmutableBitSet fieldsUsed) {
        RexBuilder rexBuilder = aggregate.getCluster().getRexBuilder();
        RelMetadataQuery mq = aggregate.getCluster().getMetadataQuery();
        HashMap mapGBKeysLineage = new HashMap();
        HashMap candidateKeys = new HashMap();
        Iterator iterator = originalGroupSet.iterator();
        while (iterator.hasNext()) {
            List<Integer> candidateGBKeys;
            Set tableRefs;
            int key = (Integer)iterator.next();
            RexInputRef inputRef = rexBuilder.makeInputRef(aggregate.getInput(), key);
            Set exprLineage = mq.getExpressionLineage(aggregate.getInput(), (RexNode)inputRef);
            if (exprLineage == null || exprLineage.size() != 1) continue;
            RexNode expr = (RexNode)exprLineage.iterator().next();
            if (expr instanceof RexTableInputRef) {
                RexTableInputRef tblRef = (RexTableInputRef)expr;
                if (mapGBKeysLineage.containsKey(tblRef.getTableRef())) {
                    ((List)mapGBKeysLineage.get(tblRef.getTableRef())).add(Pair.of((Object)tblRef.getIndex(), (Object)key));
                    continue;
                }
                ArrayList<Pair> newList = new ArrayList<Pair>();
                newList.add(Pair.of((Object)tblRef.getIndex(), (Object)key));
                mapGBKeysLineage.put(tblRef.getTableRef(), newList);
                continue;
            }
            if (!RexUtil.isDeterministic((RexNode)expr) || (tableRefs = RexUtil.gatherTableReferences((List)Lists.newArrayList((Object[])new RexNode[]{expr}))).size() != 1) continue;
            RexTableInputRef.RelTableRef tblRef = (RexTableInputRef.RelTableRef)tableRefs.iterator().next();
            if (candidateKeys.containsKey(tblRef)) {
                candidateGBKeys = (List)candidateKeys.get(tblRef);
                candidateGBKeys.add(key);
                continue;
            }
            candidateGBKeys = new ArrayList();
            candidateGBKeys.add(key);
            candidateKeys.put(tblRef, candidateGBKeys);
        }
        ImmutableBitSet.Builder builder = ImmutableBitSet.builder();
        for (Map.Entry entry : mapGBKeysLineage.entrySet()) {
            RelOptHiveTable tbl = (RelOptHiveTable)((RexTableInputRef.RelTableRef)entry.getKey()).getTable();
            List gbKeyCols = (List)entry.getValue();
            ImmutableBitSet.Builder btBuilder = ImmutableBitSet.builder();
            gbKeyCols.forEach(pair -> btBuilder.set(((Integer)pair.left).intValue()));
            ImmutableBitSet backtrackedGBSet = btBuilder.build();
            List<ImmutableBitSet> allKeys = tbl.getNonNullableKeys();
            ImmutableBitSet currentKey = null;
            for (ImmutableBitSet key : allKeys) {
                if (!backtrackedGBSet.contains(key)) continue;
                currentKey = key;
                break;
            }
            if (currentKey == null || currentKey.isEmpty()) continue;
            for (Pair gbKeyColPair : gbKeyCols) {
                Integer backtrackedCol = (Integer)gbKeyColPair.left;
                Integer orgCol = (Integer)gbKeyColPair.right;
                if (fieldsUsed.get(orgCol.intValue()) || currentKey.get(backtrackedCol.intValue())) continue;
                builder.set(orgCol.intValue());
            }
            if (!candidateKeys.containsKey(entry.getKey())) continue;
            List candidateGbKeys = (List)candidateKeys.get(entry.getKey());
            for (Integer keyToRemove : candidateGbKeys) {
                if (fieldsUsed.get(keyToRemove.intValue())) continue;
                builder.set(keyToRemove.intValue());
            }
        }
        ImmutableBitSet keysToRemove = builder.build();
        ImmutableBitSet newGroupSet = originalGroupSet.except(keysToRemove);
        assert (!newGroupSet.isEmpty());
        return newGroupSet;
    }

    private ImmutableBitSet generateNewGroupset(Aggregate aggregate, ImmutableBitSet fieldsUsed) {
        ImmutableBitSet originalGroupSet = aggregate.getGroupSet();
        if (aggregate.getGroupSets().size() > 1 || aggregate.getIndicatorCount() > 0 || fieldsUsed.contains(originalGroupSet)) {
            return originalGroupSet;
        }
        RelNode input = aggregate.getInput();
        RelMetadataQuery mq = aggregate.getCluster().getMetadataQuery();
        Set uniqueKeys = mq.getUniqueKeys(input, false);
        if (uniqueKeys == null || uniqueKeys.isEmpty()) {
            return this.generateGroupSetIfCardinalitySame(aggregate, originalGroupSet, fieldsUsed);
        }
        ImmutableBitSet columnsToRemove = ImmutableBitSet.of();
        ImmutableBitSet unusedGroupingColumns = aggregate.getGroupSet().except(fieldsUsed);
        for (ImmutableBitSet key : uniqueKeys) {
            ImmutableBitSet removeCandidate = unusedGroupingColumns.except(key);
            if (!aggregate.getGroupSet().contains(key) || removeCandidate.cardinality() <= columnsToRemove.cardinality()) continue;
            columnsToRemove = removeCandidate;
        }
        return aggregate.getGroupSet().except(columnsToRemove);
    }

    private Aggregate rewriteGBConstantKeys(Aggregate aggregate, ImmutableBitSet fieldsUsed, ImmutableBitSet aggCallFields) {
        List inputExprs;
        if (aggregate.getIndicatorCount() > 0 || aggregate.getGroupSet().isEmpty() || fieldsUsed.contains(aggregate.getGroupSet())) {
            return aggregate;
        }
        RelNode input = aggregate.getInput();
        RelDataType rowType = input.getRowType();
        RexBuilder rexBuilder = aggregate.getCluster().getRexBuilder();
        ArrayList<Object> newProjects = new ArrayList<Object>();
        List list = inputExprs = input instanceof Project ? ((Project)input).getProjects() : null;
        if (inputExprs == null || inputExprs.isEmpty()) {
            return aggregate;
        }
        boolean allConstants = true;
        Iterator iterator = aggregate.getGroupSet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            if (inputExprs.size() > key && this.isRexLiteral((RexNode)inputExprs.get(key))) continue;
            allConstants = false;
            break;
        }
        if (allConstants) {
            for (int i = 0; i < rowType.getFieldCount(); ++i) {
                if (aggregate.getGroupSet().get(i) && !aggCallFields.get(i)) {
                    newProjects.add(rexBuilder.makeLiteral(true));
                    continue;
                }
                newProjects.add(rexBuilder.makeInputRef(input, i));
            }
            RelBuilder relBuilder = (RelBuilder)REL_BUILDER.get();
            relBuilder.push(input);
            relBuilder.project(newProjects);
            HiveAggregate newAggregate = new HiveAggregate(aggregate.getCluster(), aggregate.getTraitSet(), relBuilder.build(), aggregate.getGroupSet(), (List<ImmutableBitSet>)aggregate.getGroupSets(), aggregate.getAggCallList());
            return newAggregate;
        }
        return aggregate;
    }

    @Override
    public RelFieldTrimmer.TrimResult trimFields(Aggregate aggregate, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        int originalGroupCount;
        ImmutableBitSet.Builder aggCallFieldsUsedBuilder = ImmutableBitSet.builder();
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            Iterator iterator = aggCall.getArgList().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                aggCallFieldsUsedBuilder.set(i);
            }
            if (aggCall.filterArg >= 0) {
                aggCallFieldsUsedBuilder.set(aggCall.filterArg);
            }
            aggCallFieldsUsedBuilder.addAll((Iterable)RelCollations.ordinals((RelCollation)aggCall.collation));
        }
        ImmutableBitSet aggCallFieldsUsed = aggCallFieldsUsedBuilder.build();
        aggregate = this.rewriteGBConstantKeys(aggregate, fieldsUsed, aggCallFieldsUsed);
        ImmutableBitSet.Builder inputFieldsUsed = aggregate.getGroupSet().rebuild();
        inputFieldsUsed.addAll(aggCallFieldsUsed);
        RelDataType rowType = aggregate.getRowType();
        RelNode input = aggregate.getInput();
        Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
        RelFieldTrimmer.TrimResult trimResult = this.trimChild((RelNode)aggregate, input, inputFieldsUsed.build(), inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        ImmutableBitSet originalGroupSet = aggregate.getGroupSet();
        ImmutableBitSet updatedGroupSet = this.generateNewGroupset(aggregate, fieldsUsed);
        ImmutableBitSet gbKeysDeleted = originalGroupSet.except(updatedGroupSet);
        ImmutableBitSet updatedGroupFields = ImmutableBitSet.range((int)originalGroupSet.cardinality());
        int updatedGroupCount = updatedGroupSet.cardinality();
        int setIdx = 0;
        while (setIdx != -1) {
            if ((setIdx = gbKeysDeleted.nextSetBit(setIdx)) == -1) continue;
            updatedGroupFields = updatedGroupFields.clear(setIdx);
            ++setIdx;
        }
        fieldsUsed = fieldsUsed.union(updatedGroupFields);
        if (input == newInput && fieldsUsed.equals((Object)ImmutableBitSet.range((int)rowType.getFieldCount()))) {
            return this.result((RelNode)aggregate, (Mapping)Mappings.createIdentity((int)rowType.getFieldCount()));
        }
        ImmutableBitSet newGroupSet = Mappings.apply((Mapping)inputMapping, (ImmutableBitSet)updatedGroupSet);
        int j = originalGroupCount = aggregate.getGroupSet().cardinality();
        int usedAggCallCount = 0;
        for (int i = 0; i < aggregate.getAggCallList().size(); ++i) {
            if (!fieldsUsed.get(j++)) continue;
            ++usedAggCallCount;
        }
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_SURJECTION, (int)rowType.getFieldCount(), (int)(updatedGroupCount + usedAggCallCount));
        ImmutableList newGroupSets = null;
        newGroupSets = !updatedGroupSet.equals((Object)aggregate.getGroupSet()) ? ImmutableList.of((Object)newGroupSet) : ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)aggregate.getGroupSets(), input1 -> Mappings.apply((Mapping)inputMapping, (ImmutableBitSet)input1)));
        int gbKeyIdx = 0;
        for (j = 0; j < originalGroupCount; ++j) {
            if (!fieldsUsed.get(j)) continue;
            mapping.set(j, gbKeyIdx);
            ++gbKeyIdx;
        }
        RelBuilder relBuilder = (RelBuilder)REL_BUILDER.get();
        relBuilder.push(newInput);
        ArrayList<RelBuilder.AggCall> newAggCallList = new ArrayList<RelBuilder.AggCall>();
        j = originalGroupCount;
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            if (fieldsUsed.get(j)) {
                ImmutableList args = relBuilder.fields(Mappings.apply2((Mapping)inputMapping, (List)aggCall.getArgList()));
                RexInputRef filterArg = aggCall.filterArg < 0 ? null : relBuilder.field(Mappings.apply((Mappings.TargetMapping)inputMapping, (int)aggCall.filterArg));
                RelBuilder.AggCall newAggCall = relBuilder.aggregateCall(aggCall.getAggregation(), (Iterable)args).distinct(aggCall.isDistinct()).filter((RexNode)filterArg).approximate(aggCall.isApproximate()).sort((Iterable)relBuilder.fields(aggCall.collation)).as(aggCall.name);
                mapping.set(j, updatedGroupCount + newAggCallList.size());
                newAggCallList.add(newAggCall);
            }
            ++j;
        }
        RelBuilder.GroupKey groupKey = relBuilder.groupKey(newGroupSet, (Iterable)newGroupSets);
        relBuilder.aggregate(groupKey, newAggCallList);
        return this.result(relBuilder.build(), mapping);
    }

    public RelFieldTrimmer.TrimResult trimFields(HiveTableScan tableAccessRel, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelFieldTrimmer.TrimResult result = super.trimFields(tableAccessRel, fieldsUsed, extraFields);
        ColumnAccessInfo columnAccessInfo = COLUMN_ACCESS_INFO.get();
        if (columnAccessInfo != null) {
            RelOptHiveTable tab = (RelOptHiveTable)tableAccessRel.getTable();
            String qualifiedName = tab.getHiveTableMD().getCompleteName();
            List<FieldSchema> allCols = tab.getHiveTableMD().getAllCols();
            boolean insideView = tableAccessRel.isInsideView();
            fieldsUsed.asList().stream().filter(idx -> idx < tab.getNoOfNonVirtualCols()).forEach(idx -> {
                if (insideView) {
                    columnAccessInfo.addIndirect(qualifiedName, ((FieldSchema)allCols.get((int)idx)).getName());
                } else {
                    columnAccessInfo.add(qualifiedName, ((FieldSchema)allCols.get((int)idx)).getName());
                }
            });
        }
        if (this.fetchStats) {
            this.fetchColStats((RelNode)result.getKey(), tableAccessRel, fieldsUsed, extraFields);
        }
        return result;
    }

    private void fetchColStats(RelNode key, TableScan tableAccessRel, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelOptTable table;
        ArrayList iRefSet = Lists.newArrayList();
        if (key instanceof Project) {
            Project project = (Project)key;
            for (RexNode rx : project.getProjects()) {
                iRefSet.addAll(HiveCalciteUtil.getInputRefs(rx));
            }
        } else {
            int fieldCount = tableAccessRel.getRowType().getFieldCount();
            if (fieldsUsed.equals((Object)ImmutableBitSet.range((int)fieldCount)) && extraFields.isEmpty()) {
                iRefSet.addAll(ImmutableBitSet.range((int)fieldCount).asList());
            }
        }
        if (tableAccessRel instanceof HiveTableScan) {
            iRefSet.removeAll(((HiveTableScan)tableAccessRel).getVirtualCols());
        }
        if (!iRefSet.isEmpty() && (table = tableAccessRel.getTable()) instanceof RelOptHiveTable) {
            ((RelOptHiveTable)table).getColStat(iRefSet, true);
            LOG.debug("Got col stats for {} in {}", (Object)iRefSet, (Object)tableAccessRel.getTable().getQualifiedName());
        }
    }

    @Override
    protected RelFieldTrimmer.TrimResult result(RelNode r, Mapping mapping) {
        return new RelFieldTrimmer.TrimResult(r, mapping);
    }

    public RelFieldTrimmer.TrimResult trimFields(HiveTableFunctionScan tabFun, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = tabFun.getRowType();
        int fieldCount = rowType.getFieldCount();
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
        for (RelNode input : tabFun.getInputs()) {
            int inputFieldCount = input.getRowType().getFieldCount();
            ImmutableBitSet inputFieldsUsed = ImmutableBitSet.range((int)inputFieldCount);
            Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
            RelFieldTrimmer.TrimResult trimResult = this.trimChildRestore(tabFun, input, inputFieldsUsed, inputExtraFields);
            assert (((Mapping)trimResult.right).isIdentity());
            newInputs.add((RelNode)trimResult.left);
        }
        HiveTableFunctionScan newTabFun = tabFun;
        if (!tabFun.getInputs().equals(newInputs)) {
            newTabFun = tabFun.copy(tabFun.getTraitSet(), newInputs, tabFun.getCall(), tabFun.getElementType(), tabFun.getRowType(), tabFun.getColumnMappings());
        }
        assert (newTabFun.getClass() == tabFun.getClass());
        Mappings.IdentityMapping mapping = Mappings.createIdentity((int)fieldCount);
        return this.result(newTabFun, (Mapping)mapping);
    }

    protected void register(List<Class<? extends RelNode>> nodeClasses) throws Throwable {
        this.trimFieldsDispatcher.register(nodeClasses);
    }

    public static void initializeFieldTrimmerClass(List<Class<? extends RelNode>> nodeClasses) {
        try {
            FIELD_TRIMMER_STATS.register(nodeClasses);
            FIELD_TRIMMER_NO_STATS.register(nodeClasses);
        }
        catch (Throwable t) {
            LOG.warn("Error initializing field trimmer instance", t);
        }
    }

    public RelFieldTrimmer.TrimResult trimFields(HiveSortExchange exchange, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = exchange.getRowType();
        int fieldCount = rowType.getFieldCount();
        RelCollation collation = exchange.getCollation();
        RelDistribution distribution = exchange.getDistribution();
        RelNode input = exchange.getInput();
        ImmutableBitSet.Builder inputFieldsUsed = fieldsUsed.rebuild();
        for (RelFieldCollation field : collation.getFieldCollations()) {
            inputFieldsUsed.set(field.getFieldIndex());
        }
        Iterator iterator = distribution.getKeys().iterator();
        while (iterator.hasNext()) {
            int keyIndex = (Integer)iterator.next();
            inputFieldsUsed.set(keyIndex);
        }
        Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
        RelFieldTrimmer.TrimResult trimResult = this.trimChild(exchange, input, inputFieldsUsed.build(), inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newInput == input && inputMapping.isIdentity() && fieldsUsed.cardinality() == fieldCount) {
            return this.result(exchange, (Mapping)Mappings.createIdentity((int)fieldCount));
        }
        RelBuilder relBuilder = (RelBuilder)REL_BUILDER.get();
        relBuilder.push(newInput);
        RelCollation newCollation = RexUtil.apply((Mappings.TargetMapping)inputMapping, (RelCollation)collation);
        RelDistribution newDistribution = distribution.apply((Mappings.TargetMapping)inputMapping);
        relBuilder.sortExchange(newDistribution, newCollation);
        return this.result(relBuilder.build(), inputMapping);
    }
}

