/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.correlation;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.sql.SqlKind;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;

public class HiveCorrelationInfo {
    public final RexSubQuery rexSubQuery;
    public final Set<CorrelationId> correlationIds;
    public final HiveAggregate aggregateRel;
    public final boolean notFlag;

    public HiveCorrelationInfo(Set<CorrelationId> correlationIds, RexSubQuery rexSubQuery, HiveAggregate aggregateRel, boolean notFlag) {
        this.correlationIds = ImmutableSet.copyOf(correlationIds);
        this.rexSubQuery = rexSubQuery;
        this.aggregateRel = aggregateRel;
        this.notFlag = notFlag;
    }

    public boolean isCorrScalarQuery() {
        if (this.aggregateRel == null) {
            return false;
        }
        if (this.hasExplicitGroupBy()) {
            return false;
        }
        switch (this.rexSubQuery.getKind()) {
            case SCALAR_QUERY: {
                return this.hasCorrelation();
            }
            case IN: {
                return this.notFlag ? this.hasCorrelation() : this.hasCorrelation() && this.hasCount();
            }
        }
        return false;
    }

    private boolean hasExplicitGroupBy() {
        return this.aggregateRel.getGroupCount() > 0;
    }

    private boolean hasCorrelation() {
        return !this.correlationIds.isEmpty();
    }

    private boolean hasCount() {
        for (AggregateCall aggCall : this.aggregateRel.getAggCallList()) {
            if (aggCall.getAggregation().getKind() != SqlKind.COUNT) continue;
            return true;
        }
        return false;
    }
}

