/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.ptf.BufferedVectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFOperator;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorSpillBlockContainer;
import org.apache.hadoop.hive.ql.exec.vector.rowbytescontainer.VectorRowBytesContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.udf.ptf.PTFRangeUtil;
import org.apache.hadoop.hive.ql.udf.ptf.Range;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorPTFGroupBatches
extends PTFPartition {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private VectorPTFEvaluatorBase[] evaluators;
    private int[] outputProjectionColumnMap;
    private int[] bufferedColumnMap;
    private int[] orderColumnMap;
    private int[] keyWithoutOrderColumnMap;
    private int spillLimitBufferedBatchCount;
    private String spillLocalDirs;
    @VisibleForTesting
    ArrayList<BufferedVectorizedRowBatch> bufferedBatches;
    private int allocatedBufferedBatchCount = 0;
    @VisibleForTesting
    int currentBufferedBatchCount = 0;
    private VectorizedRowBatch overflowBatch;
    private BufferedVectorizedRowBatch partialBatch;
    @VisibleForTesting
    VectorSpillBlockContainer blocks;
    private PartitionResults partitionResults;
    private PartitionMetrics partitionMetrics = new PartitionMetrics();
    private int cachedSize = -1;
    RowPositionInBatch[] positionCache;
    List<Integer> inMemoryStartRowIndex;

    public VectorPTFGroupBatches(Configuration hconf, int vectorizedPTFMaxMemoryBufferingBatchCount) {
        this.spillLocalDirs = HiveUtils.getLocalDirList(hconf);
        this.spillLimitBufferedBatchCount = Math.max(1, vectorizedPTFMaxMemoryBufferingBatchCount);
        this.initBoundaryCache(hconf);
        this.initValueCache(hconf);
    }

    public void init(VectorPTFEvaluatorBase[] evaluators, int[] outputProjectionColumnMap, int[] bufferedColumnMap, TypeInfo[] bufferedTypeInfos, int[] orderColumnMap, int[] keyWithoutOrderColumnMap, VectorizedRowBatch overflowBatch) {
        this.evaluators = evaluators;
        this.outputProjectionColumnMap = outputProjectionColumnMap;
        this.bufferedColumnMap = bufferedColumnMap;
        this.orderColumnMap = orderColumnMap;
        this.keyWithoutOrderColumnMap = keyWithoutOrderColumnMap;
        this.overflowBatch = overflowBatch;
        this.bufferedBatches = new ArrayList(0);
        if (this.valueCache != null) {
            this.valueCache.init(evaluators.length);
        }
        this.blocks = new VectorSpillBlockContainer(this.spillLimitBufferedBatchCount, this.spillLocalDirs, bufferedColumnMap, bufferedTypeInfos);
    }

    public Object[] getAt(int i) throws HiveException {
        RowPositionInBatch rp = this.getPosition(i);
        return this.getOrderingValuesFromRow(this.bufferedBatches.get(rp.batchIndex), rp.rowIndexInBatch);
    }

    public Object getValue(int row, int col) throws HiveException {
        RowPositionInBatch rp = this.getPosition(row);
        return this.getValueFromBatch(this.bufferedBatches.get(rp.batchIndex), col, rp.rowIndexInBatch);
    }

    public Object getValueAndEvaluateInputExpression(VectorPTFEvaluatorBase evaluator, int row, int col) throws HiveException {
        RowPositionInBatch rp = this.getPosition(row);
        BufferedVectorizedRowBatch batch = this.bufferedBatches.get(rp.batchIndex);
        if (!batch.isInputExpressionEvaluated) {
            evaluator.evaluateInputExpr(batch);
        }
        return this.getValueFromBatch(batch, col, rp.rowIndexInBatch);
    }

    public RowPositionInBatch getPosition(int i) throws HiveException {
        if (this.positionCache[i] != null) {
            RowPositionInBatch p = this.positionCache[i];
            if (this.canJump()) {
                this.jumpToBlock(p.block.blockIndex);
            }
            return this.positionCache[i];
        }
        if (this.blocks.isEmpty()) {
            return this.toPositionCache(i, this.getRowPositionFromBufferedBatches(i));
        }
        VectorSpillBlockContainer.VectorSpillBlock lastBlock = this.blocks.getLast();
        if (i > lastBlock.getLastRowIndex()) {
            return this.toPositionCache(i, new RowPositionInBatch(this, lastBlock, lastBlock.startRowIndex.length - 1, (int)((long)lastBlock.startRowIndex[0] + lastBlock.spillRowCount - 1L - (long)lastBlock.startRowIndex[lastBlock.spillBatchCount - 1])));
        }
        int blockIndex = 0;
        while ((long)i >= (long)this.blocks.get((int)blockIndex).startRowIndex[0] + this.blocks.get((int)blockIndex).spillRowCount) {
            ++blockIndex;
        }
        VectorSpillBlockContainer.VectorSpillBlock block = this.blocks.getCurrentBlock();
        if (blockIndex != block.blockIndex) {
            this.spillAndResetCurrentBufferedBatches();
            block = this.jumpToBlock(blockIndex);
        }
        int batchIndex = this.findInMemoryBatchIndex(i);
        return this.toPositionCache(i, new RowPositionInBatch(this, block, batchIndex, i - block.startRowIndex[batchIndex]));
    }

    @Override
    public int size() {
        if (this.cachedSize > -1) {
            return this.cachedSize;
        }
        int count = 0;
        count = this.blocks.isEmpty() ? this.countBufferedRows() : (count += this.blocks.getRowSize(this.countBufferedRows()));
        this.cachedSize = count;
        return count;
    }

    public void finishPartition() throws HiveException {
        long startTime = System.currentTimeMillis();
        this.preFinishPartition();
        int evaluatorIndex = 0;
        for (int rowNum = 0; rowNum < this.size(); ++rowNum) {
            evaluatorIndex = 0;
            for (VectorPTFEvaluatorBase evaluator : this.evaluators) {
                if (!evaluator.streamsResult()) {
                    Range range = PTFRangeUtil.getRange(evaluator.windowFrameDef, rowNum, this, evaluator.getNullsLast());
                    this.runEvaluatorForRow(evaluatorIndex, evaluator, rowNum, range);
                }
                ++evaluatorIndex;
            }
        }
        this.partitionMetrics.setDuration(System.currentTimeMillis() - startTime);
        this.LOG.info("Finished evaluation of partition, metrics: {}", (Object)this.partitionMetrics);
        if (this.valueCache != null && this.valueCache.getStatistics() != null) {
            this.LOG.info(this.valueCache.getStatistics());
        }
    }

    public void cleanupPartition() {
        this.blocks.clear();
        for (VectorizedRowBatch vectorizedRowBatch : this.bufferedBatches) {
            vectorizedRowBatch.reset();
        }
        this.currentBufferedBatchCount = 0;
        this.resetEvaluators();
        if (this.boundaryCache != null) {
            this.boundaryCache.clear();
        }
        if (this.valueCache != null) {
            this.valueCache.clear();
        }
        this.cachedSize = -1;
        this.partitionMetrics.clear();
    }

    public void bufferGroupBatch(VectorizedRowBatch batch, boolean isLastGroupBatch) throws HiveException {
        ++this.partitionMetrics.totalNumberOfBatches;
        if (this.currentBufferedBatchCount >= this.spillLimitBufferedBatchCount) {
            this.spillAndResetCurrentBufferedBatches();
            this.blocks.updateStartBatchIndexInMemory();
        }
        if (this.allocatedBufferedBatchCount <= this.currentBufferedBatchCount) {
            BufferedVectorizedRowBatch newBatch = this.newBufferedBatch(batch);
            this.bufferedBatches.add(newBatch);
            ++this.allocatedBufferedBatchCount;
        }
        BufferedVectorizedRowBatch bufferedBatch = this.bufferedBatches.get(this.currentBufferedBatchCount++);
        this.copyBufferedColumns(batch, bufferedBatch);
        bufferedBatch.isLastGroupBatch = isLastGroupBatch;
        this.cachedSize = -1;
    }

    public void resetEvaluators() {
        for (VectorPTFEvaluatorBase evaluator : this.evaluators) {
            evaluator.resetEvaluator();
            evaluator.onPartitionEnd();
        }
    }

    public void fillGroupResultsAndForward(VectorPTFOperator vecPTFOperator, Object[] partitionKey) throws HiveException {
        this.jumpToLastBlock();
        BufferedVectorizedRowBatch lastBatch = this.bufferedBatches.get(this.currentBufferedBatchCount - 1);
        this.forwardSpilledBatches(vecPTFOperator, partitionKey);
        if (this.currentBufferedBatchCount > 0) {
            for (int i = 0; i < this.currentBufferedBatchCount - 1; ++i) {
                this.forwardBufferedBatch(vecPTFOperator, this.bufferedBatches.get(i), partitionKey);
            }
            this.currentBufferedBatchCount = 0;
        }
        this.forwardLastBatch(vecPTFOperator, lastBatch, partitionKey);
    }

    int findInMemoryBatchIndex(int row) {
        int batchIndex = Collections.binarySearch(this.inMemoryStartRowIndex, row);
        batchIndex = batchIndex < 0 ? (batchIndex + 1) * -1 - 1 : batchIndex;
        return batchIndex;
    }

    private RowPositionInBatch toPositionCache(int row, RowPositionInBatch rowPositionInBatch) {
        this.positionCache[row] = rowPositionInBatch;
        return rowPositionInBatch;
    }

    private RowPositionInBatch getRowPositionFromBufferedBatches(int row) throws HiveException {
        int batchIndex = this.findInMemoryBatchIndex(row);
        return new RowPositionInBatch(this, null, batchIndex, row - this.inMemoryStartRowIndex.get(batchIndex));
    }

    private Object[] getOrderingValuesFromRow(VectorizedRowBatch vectorizedRowBatch, int rowIndexInBatch) {
        Object[] orderingValues = new Object[this.orderColumnMap.length];
        for (int i = 0; i < this.orderColumnMap.length; ++i) {
            orderingValues[i] = this.getValueFromBatch(vectorizedRowBatch, i, rowIndexInBatch);
        }
        return orderingValues;
    }

    private Object getValueFromBatch(VectorizedRowBatch vectorizedRowBatch, int column, int rowIndexInBatch) {
        ColumnVector columnVector = vectorizedRowBatch.cols[column];
        if (columnVector.isNull[rowIndexInBatch] || columnVector.isRepeating && columnVector.isNull[0]) {
            return null;
        }
        if (columnVector.isRepeating) {
            rowIndexInBatch = 0;
        }
        switch (columnVector.type) {
            case LONG: {
                return ((LongColumnVector)columnVector).vector[rowIndexInBatch];
            }
            case DOUBLE: {
                return ((DoubleColumnVector)columnVector).vector[rowIndexInBatch];
            }
            case BYTES: {
                BytesColumnVector inV = (BytesColumnVector)columnVector;
                return new String(inV.vector[rowIndexInBatch], inV.start[rowIndexInBatch], inV.length[rowIndexInBatch]);
            }
            case DECIMAL: {
                return ((DecimalColumnVector)columnVector).vector[rowIndexInBatch];
            }
            case TIMESTAMP: {
                return ((TimestampColumnVector)columnVector).getDouble(rowIndexInBatch);
            }
            case INTERVAL_DAY_TIME: {
                return ((IntervalDayTimeColumnVector)columnVector).getTotalSeconds(rowIndexInBatch);
            }
        }
        throw new RuntimeException("Unexpected column vector type while getting value from ordering col: " + String.valueOf(columnVector.type));
    }

    private int countBufferedRows() {
        int count = 0;
        for (int i = 0; i < this.currentBufferedBatchCount; ++i) {
            count += this.bufferedBatches.get((int)i).size;
        }
        return count;
    }

    public void evaluateStreamingGroupBatch(VectorizedRowBatch batch, boolean isLastGroupBatch) throws HiveException {
        for (VectorPTFEvaluatorBase evaluator : this.evaluators) {
            evaluator.evaluateGroupBatch(batch);
            if (!isLastGroupBatch) continue;
            evaluator.doLastBatchWork();
        }
    }

    private void fillGroupResults(VectorizedRowBatch batch, boolean isLastGroupBatch) throws HiveException {
        int evaluatorIndex = -1;
        int startRowIndex = this.partitionResults.currentRow;
        for (VectorPTFEvaluatorBase evaluator : this.evaluators) {
            ++evaluatorIndex;
            if (evaluator.streamsResult()) {
                evaluator.evaluateGroupBatch(batch);
                if (!isLastGroupBatch) continue;
                evaluator.doLastBatchWork();
                continue;
            }
            int outputColumnNum = evaluator.getOutputColumnNum();
            ColumnVector outputColVector = batch.cols[outputColumnNum];
            this.partitionResults.currentRow = startRowIndex;
            for (int i = 0; i < batch.size; ++i) {
                Object result = this.partitionResults.getResultForCurrentRow(evaluatorIndex);
                if (result == null) {
                    outputColVector.noNulls = false;
                    outputColVector.isNull[i] = true;
                } else {
                    try {
                        switch (evaluator.getResultColumnVectorType()) {
                            case LONG: {
                                ((LongColumnVector)outputColVector).vector[i] = (Long)result;
                                break;
                            }
                            case DOUBLE: {
                                ((DoubleColumnVector)outputColVector).vector[i] = (Double)result;
                                break;
                            }
                            case DECIMAL: {
                                ((DecimalColumnVector)outputColVector).set(i, (HiveDecimalWritable)result);
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unexpected column vector type " + String.valueOf(evaluator.getResultColumnVectorType()));
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(String.format("error while setting value from evaluator: %s", evaluator.getClass()), e);
                    }
                }
                this.partitionResults.nextRow();
            }
        }
    }

    private void forwardBufferedBatch(VectorPTFOperator vecPTFOperator, BufferedVectorizedRowBatch bufferedBatch, Object[] partitionKey) throws HiveException {
        this.prepareBufferedBatchForForwarding(bufferedBatch, partitionKey);
        vecPTFOperator.forwardBatch(this.overflowBatch);
    }

    private void prepareBufferedBatchForForwarding(BufferedVectorizedRowBatch bufferedBatch, Object[] partitionKey) throws HiveException {
        this.overflowBatch.reset();
        this.copyPartitionColumnToOverflow(partitionKey);
        int size = bufferedBatch.size;
        int bufferedColumnCount = this.bufferedColumnMap.length;
        for (int i = 0; i < bufferedColumnCount; ++i) {
            VectorizedBatchUtil.copyNonSelectedColumnVector(bufferedBatch, i, this.overflowBatch, this.bufferedColumnMap[i], size);
        }
        this.overflowBatch.size = size;
        this.fillGroupResults(this.overflowBatch, bufferedBatch.isLastGroupBatch);
    }

    private void forwardSpilledBatches(VectorPTFOperator vecPTFOperator, Object[] partitionKey) throws HiveException {
        this.overflowBatch.reset();
        this.copyPartitionColumnToOverflow(partitionKey);
        try {
            VectorSpillBlockContainer.VectorSpillBlock block;
            for (int b = 0; b < this.blocks.size() && !this.blocks.isBlockInMemory(block = this.blocks.get(b)); ++b) {
                block.setDoFinalRead(true);
                VectorRowBytesContainer rowBytesContainer = block.getSpillRowBytesContainer();
                rowBytesContainer.prepareForReading();
                int batchIndex = 0;
                long spillRowsRead = 0L;
                while (rowBytesContainer.readNext()) {
                    if (batchIndex < block.startRowIndex.length - 1 && this.overflowBatch.size == block.startRowIndex[batchIndex + 1] - block.startRowIndex[batchIndex]) {
                        this.fillGroupResults(this.overflowBatch, block.isLastGroupBatch[batchIndex]);
                        vecPTFOperator.forwardBatch(this.overflowBatch);
                        this.overflowBatch.reset();
                        this.copyPartitionColumnToOverflow(partitionKey);
                        ++batchIndex;
                    }
                    block.readSingleRowFromBytesContainer(this.overflowBatch);
                    ++this.overflowBatch.size;
                    ++spillRowsRead;
                }
                if (this.overflowBatch.size > 0) {
                    this.fillGroupResults(this.overflowBatch, block.isLastGroupBatch[batchIndex]);
                    vecPTFOperator.forwardBatch(this.overflowBatch);
                    this.overflowBatch.reset();
                    this.copyPartitionColumnToOverflow(partitionKey);
                }
                Preconditions.checkState((spillRowsRead == block.spillRowCount ? 1 : 0) != 0, (String)"error while checking forwardSpilledBatches state for spillRowsRead == block.spillRowCount, %s != %s (block %s/%s)", (Object)spillRowsRead, (Object)block.spillRowCount, (Object)b, (Object)(this.blocks.size() - 1));
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    private void copyPartitionColumnToOverflow(Object[] partitionKey) {
        int keyInputColumnCount = this.keyWithoutOrderColumnMap.length;
        for (int i = 0; i < keyInputColumnCount; ++i) {
            int keyColumnNum = this.keyWithoutOrderColumnMap[i];
            Preconditions.checkState((this.overflowBatch.cols[keyColumnNum] != null ? 1 : 0) != 0);
            this.setRepeatingColumn(partitionKey[i], this.overflowBatch, keyColumnNum);
        }
    }

    private void setRepeatingColumn(Object partitionKey, VectorizedRowBatch targetBatch, int targetColumnNum) {
        ColumnVector targetColVector = targetBatch.cols[targetColumnNum];
        targetColVector.isRepeating = true;
        if (partitionKey == null) {
            targetColVector.noNulls = false;
            targetColVector.isNull[0] = true;
            return;
        }
        switch (targetColVector.type) {
            case LONG: {
                ((LongColumnVector)targetColVector).vector[0] = (Long)partitionKey;
                break;
            }
            case DOUBLE: {
                ((DoubleColumnVector)targetColVector).vector[0] = (Double)partitionKey;
                break;
            }
            case BYTES: {
                ((BytesColumnVector)targetColVector).setRef(0, (byte[])partitionKey, 0, ((byte[])partitionKey).length);
                break;
            }
            case DECIMAL: {
                ((DecimalColumnVector)targetColVector).set(0, (HiveDecimalWritable)partitionKey);
                break;
            }
            case TIMESTAMP: {
                ((TimestampColumnVector)targetColVector).set(0, (Timestamp)partitionKey);
                break;
            }
            case INTERVAL_DAY_TIME: {
                ((IntervalDayTimeColumnVector)targetColVector).set(0, (HiveIntervalDayTime)partitionKey);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected column vector type " + String.valueOf(targetColVector.type));
            }
        }
    }

    @VisibleForTesting
    void preFinishPartition() throws HiveException {
        int rows = this.size();
        this.positionCache = new RowPositionInBatch[rows + 1];
        this.partitionResults = new PartitionResults(this, rows);
        this.jumpToFirstBlock();
    }

    private void refreshInMemoryStartRowIndex(VectorSpillBlockContainer.VectorSpillBlock block) {
        this.inMemoryStartRowIndex = new ArrayList<Integer>();
        if (block == null || !block.isFullySpilled()) {
            this.inMemoryStartRowIndex.add(block == null ? 0 : block.startRowIndex[0]);
            for (int i = 1; i < this.currentBufferedBatchCount + 1; ++i) {
                this.inMemoryStartRowIndex.add(this.inMemoryStartRowIndex.get(i - 1) + this.bufferedBatches.get((int)(i - 1)).size);
            }
        } else {
            for (int i = 0; i < block.startRowIndex.length; ++i) {
                this.inMemoryStartRowIndex.add(block.startRowIndex[i]);
            }
            this.inMemoryStartRowIndex = Arrays.stream(block.startRowIndex).boxed().collect(Collectors.toList());
            this.inMemoryStartRowIndex.add((int)((long)block.startRowIndex[0] + block.spillRowCount));
        }
    }

    private void runEvaluatorForRow(int evaluatorIndex, VectorPTFEvaluatorBase evaluator, int rowNum, Range range) throws HiveException {
        Object cacheValue;
        if (this.valueCache != null && evaluator.isCacheableForRange() && (cacheValue = this.valueCache.get(evaluatorIndex, range)) != null) {
            this.partitionResults.addResult(evaluatorIndex, rowNum, cacheValue);
            return;
        }
        Object result = null;
        if (evaluator.canRunOptimizedCalculation(rowNum, range)) {
            result = this.copyResultIfNeeded(evaluator, evaluator.runOnRange(rowNum, range, this));
            ++this.partitionMetrics.evaluationOptimized;
        } else {
            result = this.runEvaluatorOnRange(evaluator, range, false);
            ++this.partitionMetrics.evaluationSimple;
        }
        evaluator.onResultCalculated(result, range);
        evaluator.resetEvaluator();
        this.partitionResults.addResult(evaluatorIndex, rowNum, result);
        if (this.valueCache != null && evaluator.isCacheableForRange()) {
            this.valueCache.put(evaluatorIndex, range, result);
        }
    }

    public Object runEvaluatorOnRange(VectorPTFEvaluatorBase evaluator, Range range) throws HiveException {
        return this.runEvaluatorOnRange(evaluator, range, true);
    }

    public Object runEvaluatorOnRange(VectorPTFEvaluatorBase evaluator, Range range, boolean resetAfterCalculation) throws HiveException {
        BlockIterator iterator = new BlockIterator(range);
        Object result = iterator.run(evaluator);
        result = this.copyResultIfNeeded(evaluator, result);
        if (resetAfterCalculation) {
            evaluator.resetEvaluator();
        }
        return result;
    }

    private Object copyResultIfNeeded(VectorPTFEvaluatorBase evaluator, Object result) {
        if (evaluator.getResultColumnVectorType() == ColumnVector.Type.DECIMAL) {
            result = new HiveDecimalWritable((HiveDecimalWritable)result);
        }
        return result;
    }

    private void runEvaluator(VectorPTFEvaluatorBase evaluator, Range range) throws HiveException {
        int batchStartIndex = this.findInMemoryBatchIndex(range.getStart());
        int batchEndIndex = this.findInMemoryBatchIndex(range.getEnd());
        for (int i = Math.max(0, batchStartIndex); i < Math.min(batchEndIndex + 1, this.bufferedBatches.size()); ++i) {
            BufferedVectorizedRowBatch bufferedBatch = this.bufferedBatches.get(i);
            int currentBatchStartRow = this.inMemoryStartRowIndex.get(i);
            int currentBatchEndRow = this.inMemoryStartRowIndex.get(i) + bufferedBatch.size - 1;
            if (range.getEnd() - 1 < currentBatchStartRow) break;
            if (range.getStart() > currentBatchEndRow) continue;
            if (range.getStart() > currentBatchStartRow || range.getEnd() - 1 < currentBatchEndRow) {
                evaluator.evaluateGroupBatch(this.createTruncatedBufferedBatch(bufferedBatch, Math.max(range.getStart(), currentBatchStartRow) - currentBatchStartRow, Math.min(range.getEnd() - 1, currentBatchEndRow) - currentBatchStartRow));
                continue;
            }
            evaluator.evaluateGroupBatch(bufferedBatch);
        }
    }

    private VectorizedRowBatch createTruncatedBufferedBatch(BufferedVectorizedRowBatch bufferedBatch, int startIndexWithinBatch, int endIndexWithinBatch) {
        this.partialBatch.reset();
        int size = endIndexWithinBatch - startIndexWithinBatch + 1;
        for (int i = 0; i < this.bufferedColumnMap.length; ++i) {
            VectorizedBatchUtil.copyNonSelectedColumnVector(bufferedBatch, i, this.partialBatch, i, size, startIndexWithinBatch);
        }
        this.partialBatch.size = size;
        this.partialBatch.isLastGroupBatch = bufferedBatch.isLastGroupBatch;
        this.partialBatch.isInputExpressionEvaluated = bufferedBatch.isInputExpressionEvaluated;
        return this.partialBatch;
    }

    private void forwardLastBatch(VectorPTFOperator vecPTFOperator, BufferedVectorizedRowBatch lastBatch, Object[] partitionKey) throws HiveException {
        this.prepareBufferedBatchForForwarding(lastBatch, partitionKey);
        this.overflowBatch.projectionSize = this.outputProjectionColumnMap.length;
        this.overflowBatch.projectedColumns = this.outputProjectionColumnMap;
        vecPTFOperator.forwardBatch(this.overflowBatch);
    }

    private BufferedVectorizedRowBatch newBufferedBatch(VectorizedRowBatch batch) throws HiveException {
        int i;
        int bufferedColumnCount = this.bufferedColumnMap.length;
        BufferedVectorizedRowBatch newBatch = new BufferedVectorizedRowBatch(bufferedColumnCount);
        for (i = 0; i < bufferedColumnCount; ++i) {
            newBatch.cols[i] = VectorizedBatchUtil.makeLikeColumnVector(batch.cols[this.bufferedColumnMap[i]]);
            newBatch.cols[i].init();
        }
        if (this.partialBatch == null) {
            this.partialBatch = new BufferedVectorizedRowBatch(this.bufferedColumnMap.length);
            for (i = 0; i < bufferedColumnCount; ++i) {
                this.partialBatch.cols[i] = VectorizedBatchUtil.makeLikeColumnVector(batch.cols[this.bufferedColumnMap[i]]);
                this.partialBatch.cols[i].init();
            }
        }
        return newBatch;
    }

    @VisibleForTesting
    boolean previousBlock() throws HiveException {
        if (this.blocks.isStandingOnFirst()) {
            return false;
        }
        this.spillAndResetCurrentBufferedBatches();
        this.blocks.setStartBatchIndexInMemory(this.blocks.getStartBatchIndexInMemory() - this.spillLimitBufferedBatchCount);
        VectorSpillBlockContainer.VectorSpillBlock block = this.blocks.getCurrentBlock();
        this.readBlock(block);
        return true;
    }

    @VisibleForTesting
    boolean nextBlock() throws HiveException {
        VectorSpillBlockContainer.VectorSpillBlock block = this.blocks.getCurrentBlock();
        int nextBlockIndex = block.blockIndex + 1;
        if (nextBlockIndex > this.blocks.size() - 1) {
            this.LOG.info("Cannot move to next block with index {}", (Object)nextBlockIndex);
            return false;
        }
        if (!block.didSpillToDisk) {
            throw new HiveException("Current block (index: " + block.blockIndex + ", " + String.valueOf(block) + ") is not spilled while trying to move forward. Number of current blocks: " + this.blocks.size());
        }
        VectorSpillBlockContainer.VectorSpillBlock nextBlock = this.blocks.get(nextBlockIndex);
        this.blocks.setStartBatchIndexInMemory(nextBlock);
        this.readBlock(nextBlock);
        return true;
    }

    @VisibleForTesting
    void jumpToFirstBlock() throws HiveException {
        if (!this.canJump()) {
            this.refreshInMemoryStartRowIndex(null);
            return;
        }
        this.spillAndResetCurrentBufferedBatches();
        this.jumpToBlock(0);
    }

    public void jumpToLastBlock() throws HiveException {
        if (!this.canJump() || this.blocks.isStandingOnLast()) {
            return;
        }
        this.spillAndResetCurrentBufferedBatches();
        this.jumpToBlock(this.blocks.size() - 1);
    }

    private boolean canJump() {
        return !this.blocks.isEmpty() && (this.blocks.size() != 1 || this.blocks.get((int)0).didSpillToDisk);
    }

    private VectorSpillBlockContainer.VectorSpillBlock jumpToBlock(int toBlock) throws HiveException {
        VectorSpillBlockContainer.VectorSpillBlock block = this.blocks.get(toBlock);
        if (this.blocks.isStandingOnBlock(block)) {
            return block;
        }
        this.blocks.setStartBatchIndexInMemory(block);
        this.readBlock(block);
        return block;
    }

    private void readBlock(VectorSpillBlockContainer.VectorSpillBlock block) throws HiveException {
        block.setDoFinalRead(false);
        this.readBlockFromSpillToMemory(block);
        this.refreshInMemoryStartRowIndex(block);
    }

    private void readBlockFromSpillToMemory(VectorSpillBlockContainer.VectorSpillBlock block) throws HiveException {
        VectorRowBytesContainer rowBytesContainer = block.getSpillRowBytesContainer();
        try {
            rowBytesContainer.prepareForReading();
            int batchIndex = 0;
            this.bufferedBatches.get(batchIndex).reset();
            while (rowBytesContainer.readNext()) {
                if (batchIndex < block.startRowIndex.length - 1 && this.bufferedBatches.get((int)batchIndex).size == block.startRowIndex[batchIndex + 1] - block.startRowIndex[batchIndex]) {
                    this.bufferedBatches.get(++batchIndex).reset();
                }
                BufferedVectorizedRowBatch bufferedBatch = this.bufferedBatches.get(batchIndex);
                block.readSingleRowFromBytesContainer(bufferedBatch);
                ++bufferedBatch.size;
                bufferedBatch.isLastGroupBatch = block.isLastGroupBatch[batchIndex];
                bufferedBatch.isInputExpressionEvaluated = block.isInputExpressionEvaluated[batchIndex];
            }
            this.currentBufferedBatchCount = block.spillBatchCount;
            this.partitionMetrics.batchesReadFromSpill += this.currentBufferedBatchCount;
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
    }

    private void spillAndResetCurrentBufferedBatches() throws HiveException {
        VectorSpillBlockContainer.VectorSpillBlock block = this.blocks.getCurrentBlock();
        if (block.isFullySpilled()) {
            return;
        }
        block.didSpillToDisk = true;
        this.LOG.debug("Spilling batches from {} to {} in block: {}", new Object[]{block.spillBatchCount, this.currentBufferedBatchCount, block});
        BufferedVectorizedRowBatch previousBatch = block.spillBatchCount > 0 ? this.bufferedBatches.get(block.spillBatchCount - 1) : null;
        for (int i = block.spillBatchCount; i < this.currentBufferedBatchCount; ++i) {
            BufferedVectorizedRowBatch bufferedBatch = this.bufferedBatches.get(i);
            block.spillBatch(bufferedBatch);
            block.isLastGroupBatch[i] = bufferedBatch.isLastGroupBatch;
            block.isInputExpressionEvaluated[i] = bufferedBatch.isInputExpressionEvaluated;
            block.spillRowCount += (long)bufferedBatch.size;
            ++block.spillBatchCount;
            if (previousBatch != null) {
                block.startRowIndex[i] = block.startRowIndex[i - 1] + previousBatch.size;
                previousBatch.reset();
            }
            previousBatch = bufferedBatch;
        }
        this.bufferedBatches.get(this.currentBufferedBatchCount - 1).reset();
        this.partitionMetrics.batchesWrittenToSpill += this.currentBufferedBatchCount - block.spillBatchCount;
        this.currentBufferedBatchCount = 0;
    }

    private void copyBufferedColumns(VectorizedRowBatch batch, VectorizedRowBatch bufferedBatch) {
        int size = batch.size;
        for (int i = 0; i < this.bufferedColumnMap.length; ++i) {
            VectorizedBatchUtil.copyNonSelectedColumnVector(batch, this.bufferedColumnMap[i], bufferedBatch, i, size);
        }
        bufferedBatch.size = size;
    }

    class PartitionMetrics {
        public int totalNumberOfBatches;
        public int evaluationSimple;
        public int evaluationOptimized;
        public int batchesReadFromSpill;
        public int batchesWrittenToSpill;
        private long durationMs;

        PartitionMetrics() {
        }

        public void clear() {
            this.totalNumberOfBatches = 0;
            this.evaluationSimple = 0;
            this.evaluationOptimized = 0;
            this.batchesReadFromSpill = 0;
            this.batchesWrittenToSpill = 0;
            this.durationMs = 0L;
        }

        public String toString() {
            return String.format("PartitionMetrics: time spent(ms): %d, number of rows: %d, number of evaluators: %d, number of blocks: %d, batches per block: %d, average number of rows per batch: %d, totalNumberOfBatches: %d, evaluationSimple: %d, evaluationOptimized: %d, batchesReadFromSpill: %d, batchesWrittenToSpill: %d", this.durationMs, VectorPTFGroupBatches.this.size(), VectorPTFGroupBatches.this.evaluators.length, VectorPTFGroupBatches.this.blocks.size(), VectorPTFGroupBatches.this.spillLimitBufferedBatchCount, VectorPTFGroupBatches.this.size() / this.totalNumberOfBatches, this.totalNumberOfBatches, this.evaluationSimple, this.evaluationOptimized, this.batchesReadFromSpill, this.batchesWrittenToSpill);
        }

        public void setDuration(long durationMs) {
            this.durationMs = durationMs;
        }
    }

    class RowPositionInBatch {
        private VectorSpillBlockContainer.VectorSpillBlock block;
        private int batchIndex;
        private int rowIndexInBatch;

        public RowPositionInBatch(VectorPTFGroupBatches this$0, VectorSpillBlockContainer.VectorSpillBlock block, int batchIndex, int rowIndexInBatch) {
            this.block = block;
            this.batchIndex = batchIndex;
            this.rowIndexInBatch = rowIndexInBatch;
        }

        public String toString() {
            return String.format("RowPositionInBatch: batchIndex: %d, rowIndexInBatch: %d, blockIndex: %d, block: %s", this.batchIndex, this.rowIndexInBatch, this.block == null ? 0 : this.block.blockIndex, this.block);
        }
    }

    class PartitionResults {
        private final Object[][] results;
        int rows = 0;
        int currentRow = 0;

        public PartitionResults(VectorPTFGroupBatches this$0, int rows) {
            this.rows = rows;
            this.results = new Object[this$0.evaluators.length][];
            for (int e = 0; e < this$0.evaluators.length; ++e) {
                this.results[e] = new Object[rows];
            }
        }

        public void addResult(int evaluatorIndex, int rowNum, Object evaluatorResult) {
            this.results[evaluatorIndex][rowNum] = evaluatorResult;
        }

        public boolean nextRow() {
            if (this.currentRow + 1 > this.rows) {
                return false;
            }
            ++this.currentRow;
            return true;
        }

        public String toString() {
            return String.format("PartitionResults (evaluators: %d, rows: %d): %s", this.results.length, this.results[0].length, Arrays.deepToString((Object[])this.results));
        }

        public Object get(int evaluatorIndex, int row) {
            return this.results[evaluatorIndex][row];
        }

        public Object getResultForCurrentRow(int evaluatorIndex) {
            return this.results[evaluatorIndex][this.currentRow];
        }
    }

    class BlockIterator {
        private Range range;
        private RowPositionInBatch startRow;
        private RowPositionInBatch endRow;

        public BlockIterator(Range range) throws HiveException {
            this.range = range;
            this.endRow = VectorPTFGroupBatches.this.getPosition(range.getEnd());
            this.startRow = VectorPTFGroupBatches.this.getPosition(range.getStart());
            if (this.startRow.block != null) {
                VectorPTFGroupBatches.this.jumpToBlock(this.startRow.block.blockIndex);
            }
        }

        boolean hasNext() {
            return this.endRow.block != null && VectorPTFGroupBatches.this.blocks.getStartBatchIndexInMemory() < this.endRow.block.startBatchIndex;
        }

        Object run(VectorPTFEvaluatorBase evaluator) throws HiveException {
            VectorPTFGroupBatches.this.runEvaluator(evaluator, this.range);
            while (this.hasNext()) {
                VectorPTFGroupBatches.this.nextBlock();
                VectorPTFGroupBatches.this.runEvaluator(evaluator, this.range);
            }
            return this.getEvaluatorResult(evaluator);
        }

        Object getEvaluatorResult(VectorPTFEvaluatorBase evaluator) {
            return evaluator.isGroupResultNull() ? null : evaluator.getGroupResult();
        }
    }
}

