/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import org.apache.hadoop.hive.common.MemoryEstimate;
import org.apache.hadoop.hive.serde2.WriteBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorMapJoinFastKeyStore
implements MemoryEstimate {
    private static final Logger LOG = LoggerFactory.getLogger((String)VectorMapJoinFastKeyStore.class.getName());
    private WriteBuffers writeBuffers;
    private WriteBuffers.Position unsafeReadPos;

    public long add(byte[] keyBytes, int keyStart, int keyLength) {
        boolean isKeyLengthBig = keyLength >= 1048575;
        long absoluteKeyOffset = this.writeBuffers.getWritePoint();
        if (isKeyLengthBig) {
            this.writeBuffers.writeVInt(keyLength);
        }
        this.writeBuffers.write(keyBytes, keyStart, keyLength);
        long keyRefWord = 0x1000000000000000L;
        keyRefWord = isKeyLengthBig ? (keyRefWord |= 0xFFFFF0000000000L) : (keyRefWord |= (long)keyLength << 40);
        return keyRefWord |= absoluteKeyOffset;
    }

    public boolean unsafeEqualKey(long keyRefWord, byte[] keyBytes, int keyStart, int keyLength) {
        return this.equalKey(keyRefWord, keyBytes, keyStart, keyLength, this.unsafeReadPos);
    }

    public boolean equalKey(long keyRefWord, byte[] keyBytes, int keyStart, int keyLength, WriteBuffers.Position readPos) {
        boolean isKeyLengthSmall;
        int storedKeyLength = (int)((keyRefWord & 0xFFFFF0000000000L) >> 40);
        boolean bl = isKeyLengthSmall = storedKeyLength != 1048575;
        if (isKeyLengthSmall && storedKeyLength != keyLength) {
            return false;
        }
        long absoluteKeyOffset = keyRefWord & 0xFFFFFFFFFFL;
        this.writeBuffers.setReadPoint(absoluteKeyOffset, readPos);
        if (!isKeyLengthSmall && (storedKeyLength = this.writeBuffers.readVInt(readPos)) != keyLength) {
            return false;
        }
        return this.writeBuffers.isEqual(keyBytes, keyStart, readPos, keyLength);
    }

    public VectorMapJoinFastKeyStore(int writeBuffersSize) {
        this.writeBuffers = new WriteBuffers(writeBuffersSize, 0x4000000000L);
        this.unsafeReadPos = new WriteBuffers.Position();
    }

    public VectorMapJoinFastKeyStore(WriteBuffers writeBuffers) {
        this.writeBuffers = writeBuffers;
        this.unsafeReadPos = new WriteBuffers.Position();
    }

    public void getKey(long keyRefWord, WriteBuffers.ByteSegmentRef keyByteSegmentRef, WriteBuffers.Position readPos) {
        int storedKeyLength = (int)((keyRefWord & 0xFFFFF0000000000L) >> 40);
        boolean isKeyLengthSmall = storedKeyLength != 1048575;
        long absoluteKeyOffset = keyRefWord & 0xFFFFFFFFFFL;
        this.writeBuffers.setReadPoint(absoluteKeyOffset, readPos);
        if (!isKeyLengthSmall) {
            storedKeyLength = this.writeBuffers.readVInt(readPos);
        }
        this.writeBuffers.getByteSegmentRefToCurrent(keyByteSegmentRef, storedKeyLength, readPos);
    }

    public long getEstimatedMemorySize() {
        long size = 0L;
        size += this.writeBuffers == null ? 0L : this.writeBuffers.getEstimatedMemorySize();
        return size += this.unsafeReadPos == null ? 0L : this.unsafeReadPos.getEstimatedMemorySize();
    }

    private final class SmallKeyLength {
        private static final int bitLength = 20;
        private static final int allBitsOn = 1048575;
        private static final int threshold = 1048575;
        private static final int bitShift = 40;
        private static final long bitMask = 0xFFFFF0000000000L;
        private static final long allBitsOnBitShifted = 0xFFFFF0000000000L;

        private SmallKeyLength(VectorMapJoinFastKeyStore vectorMapJoinFastKeyStore) {
        }
    }

    private final class IsNonZeroFlag {
        private static final int bitShift = 60;
        private static final long flagOnMask = 0x1000000000000000L;

        private IsNonZeroFlag(VectorMapJoinFastKeyStore vectorMapJoinFastKeyStore) {
        }
    }

    private final class AbsoluteKeyOffset {
        private static final int bitLength = 40;
        private static final long allBitsOn = 0xFFFFFFFFFFL;
        private static final long bitMask = 0xFFFFFFFFFFL;
        private static final long maxSize = 0x4000000000L;

        private AbsoluteKeyOffset(VectorMapJoinFastKeyStore vectorMapJoinFastKeyStore) {
        }
    }
}

