/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.DateTimeMath;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;

public class DateScalarSubtractTimestampColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final Timestamp value;
    private final transient DateTimeMath dtm = new DateTimeMath();

    public DateScalarSubtractTimestampColumn(long value, int colNum, int outputColumnNum) {
        super(colNum, outputColumnNum);
        this.value = new Timestamp(0L);
        this.value.setTime(DateWritableV2.daysToMillis((int)((int)value)));
    }

    public DateScalarSubtractTimestampColumn() {
        this.value = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        TimestampColumnVector inputColVector2 = (TimestampColumnVector)batch.cols[this.inputColumnNum[0]];
        IntervalDayTimeColumnVector outputColVector = (IntervalDayTimeColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector2.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        if (inputColVector2.isRepeating) {
            if (inputColVector2.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                this.dtm.subtract(this.value, inputColVector2.asScratchTimestamp(0), outputColVector.getScratchIntervalDayTime());
                outputColVector.setFromScratchIntervalDayTime(0);
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            NullUtil.setNullOutputEntriesColScalar((ColumnVector)outputColVector, batch.selectedInUse, sel, n);
            return;
        }
        if (inputColVector2.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        this.dtm.subtract(this.value, inputColVector2.asScratchTimestamp(i), outputColVector.getScratchIntervalDayTime());
                        outputColVector.setFromScratchIntervalDayTime(i);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.dtm.subtract(this.value, inputColVector2.asScratchTimestamp(i), outputColVector.getScratchIntervalDayTime());
                        outputColVector.setFromScratchIntervalDayTime(i);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    this.dtm.subtract(this.value, inputColVector2.asScratchTimestamp(i), outputColVector.getScratchIntervalDayTime());
                    outputColVector.setFromScratchIntervalDayTime(i);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!inputIsNull[i]) {
                    outputIsNull[i] = false;
                    this.dtm.subtract(this.value, inputColVector2.asScratchTimestamp(i), outputColVector.getScratchIntervalDayTime());
                    outputColVector.setFromScratchIntervalDayTime(i);
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!inputIsNull[i]) {
                    outputIsNull[i] = false;
                    this.dtm.subtract(this.value, inputColVector2.asScratchTimestamp(i), outputColVector.getScratchIntervalDayTime());
                    outputColVector.setFromScratchIntervalDayTime(i);
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        }
        NullUtil.setNullOutputEntriesColScalar((ColumnVector)outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public String vectorExpressionParameters() {
        return "val " + String.valueOf(Date.ofEpochMilli((long)this.value.getTime())) + ", " + this.getColumnParamString(1, this.inputColumnNum[0]);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("date"), VectorExpressionDescriptor.ArgumentType.getType("timestamp")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

