/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.ObjectCache;
import org.apache.hadoop.hive.ql.exec.ObjectCacheFactory;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapper;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.tez.RecordProcessor;
import org.apache.hadoop.hive.ql.exec.tez.TezContext;
import org.apache.hadoop.hive.ql.exec.tez.TezProcessor;
import org.apache.hadoop.hive.ql.io.merge.MergeFileWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.tez.mapreduce.input.MRInputLegacy;
import org.apache.tez.mapreduce.processor.MRTaskReporter;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeFileRecordProcessor
extends RecordProcessor {
    public static final Logger LOG = LoggerFactory.getLogger(MergeFileRecordProcessor.class);
    protected Operator<? extends OperatorDesc> mergeOp;
    private ExecMapperContext execContext = null;
    protected static final String MAP_PLAN_KEY = "__MAP_PLAN__";
    private String cacheKey;
    private MergeFileWork mfWork;
    MRInputLegacy mrInput = null;
    private final Object[] row = new Object[2];
    ObjectCache cache;

    public MergeFileRecordProcessor(JobConf jconf, ProcessorContext context) {
        super(jconf, context);
    }

    @Override
    void init(MRTaskReporter mrReporter, Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
        this.perfLogger.perfLogBegin(this.CLASS_NAME, "TezInitializeOperators");
        super.init(mrReporter, inputs, outputs);
        this.execContext = new ExecMapperContext(this.jconf);
        this.mrInput = this.getMRInput(inputs);
        Configuration updatedConf = this.mrInput.getConfigUpdates();
        if (updatedConf != null) {
            for (Map.Entry<String, LogicalOutput> entry : updatedConf) {
                this.jconf.set(entry.getKey(), (String)entry.getValue());
            }
        }
        this.createOutputMap();
        for (Map.Entry<String, LogicalOutput> outputEntry : outputs.entrySet()) {
            outputEntry.getValue().start();
            ((TezProcessor.TezKVOutputCollector)this.outMap.get(outputEntry.getKey())).initialize();
        }
        String queryId = HiveConf.getVar((Configuration)this.jconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_ID);
        this.cache = ObjectCacheFactory.getCache((Configuration)this.jconf, queryId, true);
        try {
            this.execContext.setJc(this.jconf);
            this.cacheKey = MAP_PLAN_KEY;
            MapWork mapWork = (MapWork)this.cache.retrieve(this.cacheKey, new Callable<Object>(){

                @Override
                public Object call() {
                    return Utilities.getMapWork((Configuration)MergeFileRecordProcessor.this.jconf);
                }
            });
            Utilities.setMapWork((Configuration)this.jconf, mapWork);
            if (!(mapWork instanceof MergeFileWork)) {
                throw new RuntimeException("MapWork should be an instance of MergeFileWork.");
            }
            this.mfWork = (MergeFileWork)mapWork;
            String alias = this.mfWork.getAliasToWork().keySet().iterator().next();
            this.mergeOp = this.mfWork.getAliasToWork().get(alias);
            LOG.info(this.mergeOp.dump(0));
            MapredContext.init(true, new JobConf((Configuration)this.jconf));
            ((TezContext)MapredContext.get()).setInputs(inputs);
            this.mergeOp.passExecContext(this.execContext);
            this.mergeOp.initializeLocalWork((Configuration)this.jconf);
            this.mergeOp.initialize((Configuration)this.jconf, null);
            OperatorUtils.setChildrenCollector(this.mergeOp.getChildOperators(), this.outMap);
            this.mergeOp.setReporter((Reporter)this.reporter);
            MapredContext.get().setReporter((Reporter)this.reporter);
        }
        catch (Throwable e) {
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            if (e instanceof InterruptedException) {
                LOG.info("Hit an interrupt while initializing MergeFileRecordProcessor. Message={}", (Object)e.getMessage());
                throw (InterruptedException)e;
            }
            throw new RuntimeException("Map operator initialization failed", e);
        }
        this.perfLogger.perfLogEnd(this.CLASS_NAME, "TezInitializeOperators");
    }

    @Override
    void run() throws Exception {
        boolean needMore;
        KeyValueReader reader = this.mrInput.getReader();
        while (reader.next() && (needMore = this.processRow(reader.getCurrentKey(), reader.getCurrentValue())) && !this.isAborted()) {
        }
    }

    @Override
    void close() {
        if (this.cache != null && this.cacheKey != null) {
            this.cache.release(this.cacheKey);
        }
        if (!this.isAborted()) {
            this.setAborted(this.execContext.getIoCxt().getIOExceptions());
        }
        try {
            if (this.mergeOp == null || this.mfWork == null) {
                return;
            }
            boolean abort = this.isAborted();
            this.mergeOp.close(abort);
            ExecMapper.ReportStats rps = new ExecMapper.ReportStats((Reporter)this.reporter, (Configuration)this.jconf);
            this.mergeOp.preorderMap(rps);
        }
        catch (Exception e) {
            if (!this.isAborted()) {
                LOG.error("Hit error while closing operators - failing tree");
                throw new RuntimeException("Hive Runtime Error while closing operators", e);
            }
        }
        finally {
            Utilities.clearWorkMap((Configuration)this.jconf);
            MapredContext.close();
        }
    }

    private boolean processRow(Object key, Object value) {
        this.execContext.resetRow();
        try {
            if (this.mergeOp.getDone()) {
                return false;
            }
            this.row[0] = key;
            this.row[1] = value;
            this.mergeOp.process(this.row, 0);
        }
        catch (Throwable e) {
            this.setAborted(true);
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            LOG.error("Failed to process row", e);
            throw new RuntimeException(e);
        }
        return true;
    }

    private MRInputLegacy getMRInput(Map<String, LogicalInput> inputs) throws Exception {
        LOG.info("The inputs are: " + String.valueOf(inputs));
        ArrayList li = Lists.newArrayList();
        int numMRInputs = 0;
        for (LogicalInput inp : inputs.values()) {
            if (inp instanceof MRInputLegacy) {
                if (++numMRInputs > 1) {
                    throw new IllegalArgumentException("Only one MRInput is expected");
                }
                inp.start();
                li.add(inp);
                continue;
            }
            throw new IllegalArgumentException("Expecting only one input of type MRInputLegacy. Found type: " + inp.getClass().getCanonicalName());
        }
        this.processorContext.waitForAnyInputReady((Collection)li);
        if (li.size() != 1) {
            throw new IllegalArgumentException("MRInputs count is expected to be 1");
        }
        MRInputLegacy theMRInput = (MRInputLegacy)li.get(0);
        theMRInput.init();
        return theMRInput;
    }
}

