/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.mr;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TemporaryHashSinkOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.mr.MapredLocalTask;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerSerDe;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashTableLoader
implements org.apache.hadoop.hive.ql.exec.HashTableLoader {
    private static final Logger LOG = LoggerFactory.getLogger(MapJoinOperator.class);
    private ExecMapperContext context;
    private Configuration hconf;
    private MapJoinOperator joinOp;
    private MapJoinDesc desc;

    @Override
    public void init(ExecMapperContext context, MapredContext mrContext, Configuration hconf, MapJoinOperator joinOp) {
        this.context = context;
        this.hconf = hconf;
        this.joinOp = joinOp;
        this.desc = (MapJoinDesc)joinOp.getConf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(MapJoinTableContainer[] mapJoinTables, MapJoinTableContainerSerDe[] mapJoinTableSerdes) throws HiveException {
        String currentInputPath = this.context.getCurrentInputPath().toString();
        LOG.info("Load from HashTable for input file: {}", (Object)currentInputPath);
        MapredLocalWork localWork = this.context.getLocalWork();
        try {
            Path baseDir;
            if (localWork.getDirectFetchOp() != null) {
                this.loadDirectly(mapJoinTables, currentInputPath);
            }
            if ((baseDir = this.getBaseDir(localWork)) == null) {
                return;
            }
            String fileName = localWork.getBucketFileName(currentInputPath);
            for (int pos = 0; pos < mapJoinTables.length; ++pos) {
                if (pos == this.desc.getPosBigTable() || mapJoinTables[pos] != null) continue;
                Path path = Utilities.generatePath(baseDir, this.desc.getDumpFilePrefix(), (byte)pos, fileName);
                LOG.info("Load back 1 hashtable file from tmp file uri: {}", (Object)path);
                try (ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(path.toUri().getPath())));){
                    mapJoinTables[pos] = mapJoinTableSerdes[pos].load(in);
                    continue;
                }
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    private Path getBaseDir(MapredLocalWork localWork) throws Exception {
        if (ShimLoader.getHadoopShims().isLocalMode(this.hconf)) {
            return localWork.getTmpPath();
        }
        Path[] localArchives = DistributedCache.getLocalCacheArchives((Configuration)this.hconf);
        if (localArchives != null) {
            String stageID = localWork.getStageID();
            String suffix = Utilities.generateTarFileName(stageID);
            LocalFileSystem localFs = FileSystem.getLocal((Configuration)this.hconf);
            for (Path archive : localArchives) {
                if (!archive.getName().endsWith(suffix)) continue;
                return archive.makeQualified((FileSystem)localFs);
            }
        }
        return null;
    }

    private void loadDirectly(MapJoinTableContainer[] mapJoinTables, String inputFileName) throws Exception {
        MapredLocalWork localWork = this.context.getLocalWork();
        List<Operator<? extends OperatorDesc>> directWorks = localWork.getDirectFetchOp().get(this.joinOp);
        if (CollectionUtils.isEmpty(directWorks)) {
            return;
        }
        JobConf job = new JobConf(this.hconf);
        MapredLocalTask localTask = new MapredLocalTask(localWork, job, false);
        TemporaryHashSinkOperator sink = new TemporaryHashSinkOperator(new CompilationOpContext(), this.desc);
        sink.setParentOperators(new ArrayList<Operator<? extends OperatorDesc>>(directWorks));
        for (Operator<? extends OperatorDesc> operator : directWorks) {
            if (operator == null) continue;
            operator.setChildOperators(Arrays.asList(sink));
        }
        localTask.setExecContext(this.context);
        localTask.startForward(inputFileName);
        Object[] tables = sink.getMapJoinTables();
        for (int i = 0; i < sink.getNumParent(); ++i) {
            if (sink.getParentOperators().get(i) == null) continue;
            mapJoinTables[i] = tables[i];
        }
        Arrays.fill(tables, null);
    }
}

