/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.mr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapper;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecReducer
extends MapReduceBase
implements Reducer {
    private static final Logger LOG = LoggerFactory.getLogger((String)"ExecReducer");
    private static final String PLAN_KEY = "__REDUCE_PLAN__";
    private final Deserializer[] inputValueDeserializer = new Deserializer[127];
    private final Object[] valueObject = new Object[127];
    private final List<Object> row = new ArrayList<Object>(Utilities.reduceFieldNameList.size());
    private AbstractSerDe inputKeySerDe;
    private JobConf jc;
    private OutputCollector<?, ?> oc;
    private Operator<?> reducer;
    private Reporter rp;
    private boolean abort = false;
    private boolean isTagged = false;
    private TableDesc keyTableDesc;
    private TableDesc[] valueTableDesc;
    private ObjectInspector[] rowObjectInspector;
    private transient Object keyObject;
    private transient BytesWritable groupKey;

    public void configure(JobConf job) {
        this.rowObjectInspector = new ObjectInspector[127];
        ObjectInspector[] valueObjectInspector = new ObjectInspector[127];
        Utilities.tryLoggingClassPaths(job, LOG);
        this.jc = job;
        ReduceWork gWork = Utilities.getReduceWork((Configuration)job);
        this.reducer = gWork.getReducer();
        this.reducer.setParentOperators(null);
        this.isTagged = gWork.getNeedsTagging();
        try {
            this.keyTableDesc = gWork.getKeyDesc();
            this.inputKeySerDe = (AbstractSerDe)ReflectionUtils.newInstance(this.keyTableDesc.getSerDeClass(), null);
            this.inputKeySerDe.initialize(null, this.keyTableDesc.getProperties(), null);
            ObjectInspector keyObjectInspector = this.inputKeySerDe.getObjectInspector();
            this.valueTableDesc = new TableDesc[gWork.getTagToValueDesc().size()];
            for (int tag = 0; tag < gWork.getTagToValueDesc().size(); ++tag) {
                this.valueTableDesc[tag] = gWork.getTagToValueDesc().get(tag);
                AbstractSerDe valueObjectSerDe = (AbstractSerDe)ReflectionUtils.newInstance(this.valueTableDesc[tag].getSerDeClass(), null);
                valueObjectSerDe.initialize(null, this.valueTableDesc[tag].getProperties(), null);
                this.inputValueDeserializer[tag] = valueObjectSerDe;
                valueObjectInspector[tag] = this.inputValueDeserializer[tag].getObjectInspector();
                ArrayList<ObjectInspector> ois = new ArrayList<ObjectInspector>();
                ois.add(keyObjectInspector);
                ois.add(valueObjectInspector[tag]);
                this.rowObjectInspector[tag] = ObjectInspectorFactory.getStandardStructObjectInspector(Utilities.reduceFieldNameList, ois);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MapredContext.init(false, new JobConf((Configuration)this.jc));
        try {
            LOG.info(this.reducer.dump(0));
            this.reducer.initialize((Configuration)this.jc, this.rowObjectInspector);
        }
        catch (Throwable e) {
            this.abort = true;
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            throw new RuntimeException("Reduce operator initialization failed", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reduce(Object key, Iterator values, OutputCollector output, Reporter reporter) throws IOException {
        if (this.reducer.getDone()) {
            return;
        }
        if (this.oc == null) {
            this.oc = output;
            this.rp = reporter;
            this.reducer.setReporter(this.rp);
            MapredContext.get().setReporter(reporter);
        }
        try {
            BytesWritable keyWritable = (BytesWritable)key;
            byte tag = 0;
            if (this.isTagged) {
                int size = keyWritable.getSize() - 1;
                tag = keyWritable.get()[size];
                keyWritable.setSize(size);
            }
            if (!keyWritable.equals((Object)this.groupKey)) {
                if (this.groupKey == null) {
                    this.groupKey = new BytesWritable();
                } else {
                    LOG.trace("End Group");
                    this.reducer.endGroup();
                }
                try {
                    this.keyObject = this.inputKeySerDe.deserialize((Writable)keyWritable);
                }
                catch (Exception e) {
                    throw new HiveException("Hive Runtime Error: Unable to deserialize reduce input key from " + Utilities.formatBinaryString(keyWritable.get(), 0, keyWritable.getSize()) + " with properties " + String.valueOf(this.keyTableDesc.getProperties()), (Throwable)e);
                }
                this.groupKey.set(keyWritable.get(), 0, keyWritable.getSize());
                LOG.trace("Start Group");
                this.reducer.startGroup();
                this.reducer.setGroupKeyObject(this.keyObject);
            }
            while (values.hasNext()) {
                BytesWritable valueWritable = (BytesWritable)values.next();
                try {
                    this.valueObject[tag] = this.inputValueDeserializer[tag].deserialize((Writable)valueWritable);
                }
                catch (SerDeException e) {
                    throw new HiveException("Hive Runtime Error: Unable to deserialize reduce input value (tag=" + tag + ") from " + Utilities.formatBinaryString(valueWritable.get(), 0, valueWritable.getSize()) + " with properties " + String.valueOf(this.valueTableDesc[tag].getProperties()), (Throwable)e);
                }
                this.row.clear();
                this.row.add(this.keyObject);
                this.row.add(this.valueObject[tag]);
                try {
                    this.reducer.process(this.row, tag);
                }
                catch (Exception e) {
                    Object rowString = null;
                    try {
                        rowString = SerDeUtils.getJSONString(this.row, (ObjectInspector)this.rowObjectInspector[tag]);
                    }
                    catch (Exception e2) {
                        rowString = "[Error getting row data with exception " + StringUtils.stringifyException((Throwable)e2) + " ]";
                    }
                    LOG.trace("Hive Runtime Error while processing row (tag=" + tag + ") " + (String)rowString);
                    throw new HiveException("Hive Runtime Error while processing row", (Throwable)e);
                    return;
                }
            }
        }
        catch (Throwable e) {
            this.abort = true;
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            LOG.error("Reduce failed", e);
            throw new RuntimeException(e);
        }
    }

    public void close() {
        if (this.oc == null) {
            LOG.trace("Close called without any rows processed");
        }
        try {
            if (this.groupKey != null) {
                LOG.trace("End Group");
                this.reducer.endGroup();
            }
            this.reducer.close(this.abort);
            ExecMapper.ReportStats rps = new ExecMapper.ReportStats(this.rp, (Configuration)this.jc);
            this.reducer.preorderMap(rps);
        }
        catch (Exception e) {
            if (!this.abort) {
                LOG.error("Hit error while closing operators - failing tree");
                throw new RuntimeException("Hive Runtime Error while closing operators: " + e.getMessage(), e);
            }
        }
        finally {
            MapredContext.close();
            Utilities.clearWorkMap((Configuration)this.jc);
        }
    }
}

