/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.NodeUtils;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.TerminalOperator;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SemiJoinBranchInfo;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.mapred.OutputCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OperatorUtils.class);

    public static <T> T ancestor(Operator<?> op, Class<T> clazz, int ... path) {
        Operator<Object> target = op;
        for (int i = 0; i < path.length; ++i) {
            if (target.getParentOperators() == null || path[i] > target.getParentOperators().size()) {
                return null;
            }
            target = target.getParentOperators().get(path[i]);
        }
        return clazz.isInstance(target) ? (T)clazz.cast(target) : null;
    }

    public static <T> Set<T> findOperators(Operator<?> start, Class<T> clazz) {
        return OperatorUtils.findOperators(start, clazz, new HashSet());
    }

    public static <T> T findSingleOperator(Operator<?> start, Class<T> clazz) {
        Set<T> found = OperatorUtils.findOperators(start, clazz, new HashSet());
        return found.size() == 1 ? (T)found.iterator().next() : null;
    }

    public static <T> Set<T> findOperators(Collection<Operator<?>> starts, Class<T> clazz) {
        HashSet found = new HashSet();
        for (Operator<?> start : starts) {
            if (start == null) continue;
            OperatorUtils.findOperators(start, clazz, found);
        }
        return found;
    }

    private static <T> Set<T> findOperators(Operator<?> start, Class<T> clazz, Set<T> found) {
        if (clazz.isInstance(start)) {
            found.add(start);
        }
        if (start.getChildOperators() != null) {
            for (Operator<OperatorDesc> child : start.getChildOperators()) {
                OperatorUtils.findOperators(child, clazz, found);
            }
        }
        return found;
    }

    public static <T> Set<T> findOperatorsUpstream(Operator<?> start, Class<T> clazz) {
        return OperatorUtils.findOperatorsUpstream(start, clazz, new HashSet());
    }

    public static <T> T findSingleOperatorUpstream(Operator<?> start, Class<T> clazz) {
        Set<T> found = OperatorUtils.findOperatorsUpstream(start, clazz, new HashSet());
        return found.size() == 1 ? (T)found.iterator().next() : null;
    }

    public static <T> T findSingleOperatorUpstreamJoinAccounted(Operator<?> start, Class<T> clazz) {
        Set<T> found = OperatorUtils.findOperatorsUpstreamJoinAccounted(start, clazz, new HashSet());
        return found.size() >= 1 ? (T)found.iterator().next() : null;
    }

    public static <T> Set<T> findOperatorsUpstream(Collection<Operator<?>> starts, Class<T> clazz) {
        HashSet found = new HashSet();
        for (Operator<?> start : starts) {
            OperatorUtils.findOperatorsUpstream(start, clazz, found);
        }
        return found;
    }

    private static <T> Set<T> findOperatorsUpstream(Operator<?> start, Class<T> clazz, Set<T> found) {
        if (clazz.isInstance(start)) {
            found.add(start);
        }
        if (start.getParentOperators() != null) {
            for (Operator<OperatorDesc> parent : start.getParentOperators()) {
                OperatorUtils.findOperatorsUpstream(parent, clazz, found);
            }
        }
        return found;
    }

    public static <T> Set<T> findOperatorsUpstreamJoinAccounted(Operator<?> start, Class<T> clazz, Set<T> found) {
        if (clazz.isInstance(start)) {
            found.add(start);
        }
        int onlyIncludeIndex = -1;
        if (start instanceof AbstractMapJoinOperator) {
            AbstractMapJoinOperator mapJoinOp = (AbstractMapJoinOperator)start;
            MapJoinDesc desc = (MapJoinDesc)mapJoinOp.getConf();
            onlyIncludeIndex = desc.getPosBigTable();
        }
        if (start.getParentOperators() != null) {
            int i = 0;
            for (Operator<OperatorDesc> parent : start.getParentOperators()) {
                if (onlyIncludeIndex >= 0) {
                    if (onlyIncludeIndex == i) {
                        OperatorUtils.findOperatorsUpstreamJoinAccounted(parent, clazz, found);
                    }
                } else {
                    OperatorUtils.findOperatorsUpstreamJoinAccounted(parent, clazz, found);
                }
                ++i;
            }
        }
        return found;
    }

    public static boolean hasMoreOperatorsThan(Operator<?> start, Class<?> opClazz, int limit) {
        return OperatorUtils.hasMoreOperatorsThan(start, opClazz, limit, new HashSet());
    }

    private static boolean hasMoreOperatorsThan(Operator<?> start, Class<?> opClazz, int limit, Set<Operator<?>> visited) {
        if (!visited.add(start)) {
            return limit < 0;
        }
        if (limit < 0) {
            return false;
        }
        if (start instanceof ReduceSinkOperator) {
            return false;
        }
        if (opClazz.isInstance(start)) {
            --limit;
        }
        if (start.getParentOperators() != null) {
            for (Operator<OperatorDesc> parent : start.getParentOperators()) {
                if (!OperatorUtils.hasMoreOperatorsThan(parent, opClazz, limit, visited)) continue;
                return true;
            }
        }
        return limit < 0;
    }

    public static void setChildrenCollector(List<Operator<? extends OperatorDesc>> childOperators, OutputCollector out) {
        if (childOperators == null) {
            return;
        }
        for (Operator<? extends OperatorDesc> op : childOperators) {
            if (op.getName().equals(ReduceSinkOperator.getOperatorName())) {
                op.setOutputCollector(out);
                continue;
            }
            OperatorUtils.setChildrenCollector(op.getChildOperators(), out);
        }
    }

    public static void setChildrenCollector(List<Operator<? extends OperatorDesc>> childOperators, Map<String, OutputCollector> outMap) {
        if (childOperators == null) {
            return;
        }
        for (Operator<? extends OperatorDesc> op : childOperators) {
            if (op.getIsReduceSink()) {
                String outputName = op.getReduceOutputName();
                if (!outMap.containsKey(outputName)) continue;
                LOG.info("Setting output collector: " + String.valueOf(op) + " --> " + outputName);
                op.setOutputCollector(outMap.get(outputName));
                continue;
            }
            OperatorUtils.setChildrenCollector(op.getChildOperators(), outMap);
        }
    }

    public static <T> T findLastOperator(Operator<?> op, Class<T> clazz) {
        Operator<Object> currentOp = op;
        Operator<?> lastOp = null;
        while (currentOp != null) {
            if (clazz.isInstance(currentOp)) {
                lastOp = currentOp;
            }
            if (currentOp.getChildOperators().size() == 1) {
                currentOp = currentOp.getChildOperators().get(0);
                continue;
            }
            currentOp = null;
        }
        return (T)lastOp;
    }

    public static void iterateParents(Operator<?> operator, NodeUtils.Function<Operator<?>> function) {
        OperatorUtils.iterateParents(operator, function, new HashSet());
    }

    private static void iterateParents(Operator<?> operator, NodeUtils.Function<Operator<?>> function, Set<Operator<?>> visited) {
        if (!visited.add(operator)) {
            return;
        }
        function.apply(operator);
        if (operator.getNumParent() > 0) {
            for (Operator<OperatorDesc> parent : operator.getParentOperators()) {
                OperatorUtils.iterateParents(parent, function, visited);
            }
        }
    }

    public static Multimap<Class<? extends Operator<?>>, Operator<?>> classifyOperators(Operator<?> start, Set<Class<? extends Operator<?>>> classes) {
        ImmutableMultimap.Builder resultMap = new ImmutableMultimap.Builder();
        ArrayList ops = new ArrayList();
        ops.add(start);
        while (!ops.isEmpty()) {
            ArrayList<Operator<OperatorDesc>> allChildren = new ArrayList<Operator<OperatorDesc>>();
            for (Operator operator : ops) {
                for (Class<Operator<?>> clazz : classes) {
                    if (!clazz.isInstance(operator)) continue;
                    resultMap.put(clazz, (Object)operator);
                }
                allChildren.addAll(operator.getChildOperators());
            }
            ops = allChildren;
        }
        return resultMap.build();
    }

    public static Multimap<Class<? extends Operator<?>>, Operator<?>> classifyOperatorsUpstream(Operator<?> start, Set<Class<? extends Operator<?>>> classes) {
        ImmutableMultimap.Builder resultMap = new ImmutableMultimap.Builder();
        ArrayList ops = new ArrayList();
        ops.add(start);
        while (!ops.isEmpty()) {
            ArrayList<Operator<OperatorDesc>> allParent = new ArrayList<Operator<OperatorDesc>>();
            for (Operator operator : ops) {
                for (Class<Operator<?>> clazz : classes) {
                    if (!clazz.isInstance(operator)) continue;
                    resultMap.put(clazz, (Object)operator);
                }
                if (operator.getParentOperators() == null) continue;
                allParent.addAll(operator.getParentOperators());
            }
            ops = allParent;
        }
        return resultMap.build();
    }

    public static int countOperatorsUpstream(Operator<?> start, Set<Class<? extends Operator<?>>> classes) {
        Multimap<Class<? extends Operator<?>>, Operator<?>> ops = OperatorUtils.classifyOperatorsUpstream(start, classes);
        int numberOperators = 0;
        HashSet<Operator> uniqueOperators = new HashSet<Operator>();
        for (Operator op : ops.values()) {
            if (!uniqueOperators.add(op)) continue;
            ++numberOperators;
        }
        return numberOperators;
    }

    public static void setMemoryAvailable(List<Operator<? extends OperatorDesc>> operators, long memoryAvailableToTask) {
        if (operators == null) {
            return;
        }
        for (Operator<? extends OperatorDesc> op : operators) {
            if (op.getConf() != null) {
                op.getConf().setMaxMemoryAvailable(memoryAvailableToTask);
            }
            if (op.getChildOperators() == null || op.getChildOperators().isEmpty()) continue;
            OperatorUtils.setMemoryAvailable(op.getChildOperators(), memoryAvailableToTask);
        }
    }

    public static void removeOperator(Operator<?> op) {
        if (op.getNumParent() != 0) {
            ArrayList allParent = Lists.newArrayList(op.getParentOperators());
            for (Operator parentOp : allParent) {
                parentOp.removeChild(op);
            }
        }
        if (op.getNumChild() != 0) {
            ArrayList allChildren = Lists.newArrayList(op.getChildOperators());
            for (Operator childOp : allChildren) {
                childOp.removeParent(op);
            }
        }
    }

    public static String getOpNamePretty(Operator<?> op) {
        if (op instanceof TableScanOperator) {
            return op.toString() + " (" + ((TableScanDesc)((TableScanOperator)op).getConf()).getAlias() + ")";
        }
        return op.toString();
    }

    public static Set<Operator<?>> getOp(BaseWork work, Class<?> clazz) {
        HashSet ops = new HashSet();
        if (work instanceof MapWork) {
            Collection<Operator<? extends OperatorDesc>> opSet = ((MapWork)work).getAliasToWork().values();
            Stack<Operator<? extends OperatorDesc>> opStack = new Stack<Operator<? extends OperatorDesc>>();
            opStack.addAll(opSet);
            while (!opStack.empty()) {
                Operator operator = (Operator)opStack.pop();
                ops.add(operator);
                if (operator.getChildOperators() == null) continue;
                opStack.addAll(operator.getChildOperators());
            }
        } else {
            ops.addAll(work.getAllOperators());
        }
        HashSet matchingOps = new HashSet();
        for (Operator operator : ops) {
            if (!clazz.isInstance(operator)) continue;
            matchingOps.add(operator);
        }
        return matchingOps;
    }

    public static Operator<?> findOperatorByMarker(Operator<?> start, String marker) {
        ArrayDeque queue = new ArrayDeque();
        queue.add(start);
        while (!queue.isEmpty()) {
            Operator op = (Operator)queue.remove();
            if (marker.equals(op.getMarker())) {
                return op;
            }
            if (op.getChildOperators() == null) continue;
            queue.addAll(op.getChildOperators());
        }
        return null;
    }

    public static Set<Operator<?>> findWorkOperatorsAndSemiJoinEdges(Operator<?> start, Map<ReduceSinkOperator, SemiJoinBranchInfo> rsToSemiJoinBranchInfo, Set<ReduceSinkOperator> semiJoinOps, Set<TerminalOperator<?>> terminalOps) {
        HashSet found = new HashSet();
        OperatorUtils.findWorkOperatorsAndSemiJoinEdges(start, found, rsToSemiJoinBranchInfo, semiJoinOps, terminalOps);
        return found;
    }

    private static void findWorkOperatorsAndSemiJoinEdges(Operator<?> start, Set<Operator<?>> found, Map<ReduceSinkOperator, SemiJoinBranchInfo> rsToSemiJoinBranchInfo, Set<ReduceSinkOperator> semiJoinOps, Set<TerminalOperator<?>> terminalOps) {
        found.add(start);
        if (start.getParentOperators() != null) {
            for (Operator<OperatorDesc> parent : start.getParentOperators()) {
                if (parent instanceof ReduceSinkOperator || found.contains(parent)) continue;
                OperatorUtils.findWorkOperatorsAndSemiJoinEdges(parent, found, rsToSemiJoinBranchInfo, semiJoinOps, terminalOps);
            }
        }
        if (start instanceof TerminalOperator) {
            Operator<OperatorDesc> rs2;
            Operator<OperatorDesc> gb2;
            boolean semiJoin = false;
            if (start.getChildOperators().size() == 1 && (gb2 = start.getChildOperators().get(0)) instanceof GroupByOperator && gb2.getChildOperators().size() == 1 && (rs2 = gb2.getChildOperators().get(0)) instanceof ReduceSinkOperator && rsToSemiJoinBranchInfo.get(rs2) != null) {
                found.add(start);
                found.add(gb2);
                found.add(rs2);
                semiJoinOps.add((ReduceSinkOperator)rs2);
                semiJoin = true;
            }
            if (!semiJoin) {
                terminalOps.add((TerminalOperator)start);
            }
            return;
        }
        if (start.getChildOperators() != null) {
            for (Operator<OperatorDesc> child : start.getChildOperators()) {
                if (found.contains(child)) continue;
                OperatorUtils.findWorkOperatorsAndSemiJoinEdges(child, found, rsToSemiJoinBranchInfo, semiJoinOps, terminalOps);
            }
        }
    }

    private static List<ExprNodeDesc> backtrackAll(List<ExprNodeDesc> exprs, Operator<? extends OperatorDesc> start, Operator<? extends OperatorDesc> terminal) {
        ArrayList<ExprNodeDesc> backtrackedExprs = new ArrayList<ExprNodeDesc>();
        try {
            for (ExprNodeDesc expr : exprs) {
                ExprNodeDesc backtrackedExpr = ExprNodeDescUtils.backtrack(expr, start, terminal);
                if (backtrackedExpr == null) {
                    return null;
                }
                backtrackedExprs.add(backtrackedExpr);
            }
        }
        catch (SemanticException e) {
            return null;
        }
        return backtrackedExprs;
    }

    private static boolean areBacktrackedExprsCompatible(List<ExprNodeDesc> orgexprs, List<ExprNodeDesc> backtrackedExprs) {
        if (backtrackedExprs == null || backtrackedExprs.size() != orgexprs.size()) {
            return false;
        }
        for (int i = 0; i < orgexprs.size(); ++i) {
            if (!(orgexprs.get(i) instanceof ExprNodeColumnDesc) || !(backtrackedExprs.get(i) instanceof ExprNodeColumnDesc)) continue;
            ExprNodeColumnDesc orgColExpr = (ExprNodeColumnDesc)orgexprs.get(i);
            ExprNodeColumnDesc backExpr = (ExprNodeColumnDesc)backtrackedExprs.get(i);
            String orgTabAlias = orgColExpr.getTabAlias();
            String backTabAlias = backExpr.getTabAlias();
            if (orgTabAlias == null || backTabAlias == null || orgTabAlias.equals(backTabAlias)) continue;
            return false;
        }
        return true;
    }

    public static Operator<? extends OperatorDesc> findSourceRS(Operator<?> start, List<ExprNodeDesc> exprs) {
        Operator<? extends OperatorDesc> nextRS;
        Operator<Object> currRS = null;
        if (start instanceof ReduceSinkOperator) {
            currRS = start;
        }
        if (start instanceof UnionOperator) {
            return currRS;
        }
        List<Operator<OperatorDesc>> parents = start.getParentOperators();
        if (parents == null | parents.isEmpty()) {
            return null;
        }
        Operator<OperatorDesc> nextOp = null;
        List<ExprNodeDesc> backtrackedExprs = null;
        for (int i = 0; i < parents.size(); ++i) {
            backtrackedExprs = OperatorUtils.backtrackAll(exprs, start, parents.get(i));
            if (!OperatorUtils.areBacktrackedExprsCompatible(exprs, backtrackedExprs)) continue;
            nextOp = parents.get(i);
            break;
        }
        if (nextOp != null && (nextRS = OperatorUtils.findSourceRS(nextOp, backtrackedExprs)) != null) {
            currRS = nextRS;
        }
        return currRS;
    }

    public static GroupByOperator findMapSideGb(GroupByOperator reduceSideGbOp) {
        Operator parentOp = reduceSideGbOp;
        while (parentOp.getParentOperators() != null && parentOp.getParentOperators().size() > 0) {
            if (parentOp.getParentOperators().size() > 1) {
                return null;
            }
            if (!((parentOp = parentOp.getParentOperators().get(0)) instanceof GroupByOperator)) continue;
            return parentOp;
        }
        return null;
    }

    public static boolean treesWithIndependentInputs(Operator<?> tree1, Operator<?> tree2) {
        Set<String> tables1 = OperatorUtils.signaturesOf(OperatorUtils.findOperatorsUpstream(tree1, TableScanOperator.class));
        Set<String> tables2 = OperatorUtils.signaturesOf(OperatorUtils.findOperatorsUpstream(tree2, TableScanOperator.class));
        tables1.retainAll(tables2);
        return tables1.isEmpty();
    }

    private static Set<String> signaturesOf(Set<TableScanOperator> ops) {
        HashSet<String> ret = new HashSet<String>();
        for (TableScanOperator o : ops) {
            ret.add(((TableScanDesc)o.getConf()).getQualifiedTable());
        }
        return ret;
    }

    public static ExprNodeColumnDesc findTableOriginColExpr(ExprNodeColumnDesc colName, Operator<?> start, Operator<?> end) throws SemanticException {
        ExprNodeDesc res = ExprNodeDescUtils.backtrack(colName, start, end, false, true);
        return res != null ? ExprNodeDescUtils.getColumnExpr(res) : null;
    }

    public static Set<Operator<?>> getAllOperatorsForSimpleFetch(Set<Operator<?>> opSet) {
        LinkedHashSet returnSet = new LinkedHashSet();
        Stack opStack = new Stack();
        opStack.addAll(opSet);
        while (!opStack.empty()) {
            Operator op = (Operator)opStack.pop();
            returnSet.add(op);
            if (op.getChildOperators() == null) continue;
            opStack.addAll(op.getChildOperators());
        }
        return returnSet;
    }

    public static Set<Operator<?>> getAllFetchOperators(FetchTask task) {
        if (((FetchWork)task.getWork()).getSource() == null) {
            return Collections.EMPTY_SET;
        }
        HashSet operatorList = new HashSet();
        operatorList.add(((FetchWork)task.getWork()).getSource());
        return OperatorUtils.getAllOperatorsForSimpleFetch(operatorList);
    }

    public static Operator<?> findSourceOperatorInSameBranch(Operator<?> op) {
        while (!(op == null || op instanceof TableScanOperator || op instanceof ReduceSinkOperator || op instanceof CommonJoinOperator)) {
            List<Operator<OperatorDesc>> parents = op.getParentOperators();
            Preconditions.checkState((parents.size() <= 1 ? 1 : 0) != 0);
            op = parents.size() == 1 ? parents.get(0) : null;
        }
        return op;
    }
}

