/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfUtil;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.IConfigureJobConf;
import org.apache.hadoop.hive.ql.exec.Stat;
import org.apache.hadoop.hive.ql.exec.TerminalOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.BucketCodec;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.HivePartitioner;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.ql.io.StatsProvidingRecordWriter;
import org.apache.hadoop.hive.ql.io.StreamingOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcRecordUpdater;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveFatalException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.SkewedColumnPositionPair;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.security.authorization.HiveCustomStorageHandlerUtils;
import org.apache.hadoop.hive.ql.stats.StatsCollectionContext;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SubStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.common.util.HiveStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSinkOperator
extends TerminalOperator<FileSinkDesc>
implements Serializable,
IConfigureJobConf {
    public static final Logger LOG = LoggerFactory.getLogger(FileSinkOperator.class);
    protected transient HashMap<String, FSPaths> valToPaths;
    protected transient int numDynParts;
    protected transient List<String> dpColNames;
    protected transient DynamicPartitionCtx dpCtx;
    protected transient boolean isCompressed;
    protected transient boolean isTemporary;
    protected transient Path parent;
    protected transient HiveOutputFormat<?, ?> hiveOutputFormat;
    protected transient Path specPath;
    protected transient String unionPath;
    protected transient boolean isUnionDp;
    protected transient int dpStartCol;
    protected transient List<String> dpVals;
    protected transient List<Object> dpWritables;
    protected transient RecordWriter[] rowOutWriters;
    protected transient int maxPartitions;
    protected transient ListBucketingCtx lbCtx;
    protected transient boolean isSkewedStoredAsSubDirectories;
    protected transient boolean[] statsFromRecordWriter;
    protected transient boolean isCollectRWStats;
    private transient FSPaths prevFsp;
    private transient FSPaths fpaths;
    private StructField recIdField;
    private StructField bucketField;
    private StructObjectInspector recIdInspector;
    private IntObjectInspector bucketInspector;
    protected transient long numRows = 0L;
    protected transient long cntr = 1L;
    protected transient long logEveryNRows = 0L;
    protected transient int rowIndex = 0;
    private transient Path destTablePath;
    private transient boolean isInsertOverwrite;
    private transient String counterGroup;
    private transient BiFunction<Object[], ObjectInspector[], Integer> hashFunc;
    public static final String TOTAL_TABLE_ROWS_WRITTEN = "TOTAL_TABLE_ROWS_WRITTEN";
    private transient Set<String> dynamicPartitionSpecs = new HashSet<String>();
    private static final long serialVersionUID = 1L;
    protected transient FileSystem fs;
    protected transient Serializer serializer;
    protected final transient LongWritable row_count = new LongWritable();
    private transient ExprNodeEvaluator[] partitionEval;
    protected transient int totalFiles;
    private transient int numFiles;
    protected transient boolean multiFileSpray;
    protected final transient Map<Integer, Integer> bucketMap = new HashMap<Integer, Integer>();
    private transient boolean isBucketed = false;
    private transient int bucketId;
    private transient ObjectInspector[] partitionObjectInspectors;
    protected transient HivePartitioner<HiveKey, Object> prtner;
    protected final transient HiveKey key = new HiveKey();
    private transient Configuration hconf;
    protected transient FSPaths fsp;
    protected transient boolean bDynParts;
    private transient SubStructObjectInspector subSetOI;
    private transient int timeOut;
    private transient long lastProgressReport = System.currentTimeMillis();
    protected transient boolean autoDelete = false;
    protected transient JobConf jc;
    Class<? extends Writable> outputClass;
    String taskId;
    String originalTaskId;
    protected boolean filesCreated = false;
    protected BitSet filesCreatedPerBucket = new BitSet();
    protected boolean isCompactionTable = false;
    protected Writable recordValue;

    private void initializeSpecPath() {
        boolean isLinked = ((FileSinkDesc)this.conf).isLinkedFileSink();
        if (!isLinked) {
            this.specPath = ((FileSinkDesc)this.conf).getDirName();
            this.unionPath = null;
        } else {
            boolean bl = this.isUnionDp = this.dpCtx != null;
            if (((FileSinkDesc)this.conf).isDirectInsert()) {
                this.specPath = ((FileSinkDesc)this.conf).getParentDir();
                this.unionPath = null;
            } else if (((FileSinkDesc)this.conf).isMmTable() || this.isUnionDp) {
                this.specPath = ((FileSinkDesc)this.conf).isMmTable() ? ((FileSinkDesc)this.conf).getParentDir() : ((FileSinkDesc)this.conf).getDirName();
                this.unionPath = ((FileSinkDesc)this.conf).getDirName().getName();
            } else {
                this.specPath = ((FileSinkDesc)this.conf).getDirName();
                this.unionPath = null;
            }
        }
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("Setting up FSOP " + System.identityHashCode(this) + " (" + ((FileSinkDesc)this.conf).isLinkedFileSink() + ") with " + this.taskId + " and " + String.valueOf(this.specPath) + " + " + this.unionPath);
        }
    }

    protected FileSinkOperator() {
    }

    public FileSinkOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        try {
            this.hconf = hconf;
            this.filesCreated = false;
            this.isTemporary = ((FileSinkDesc)this.conf).isTemporary();
            this.multiFileSpray = ((FileSinkDesc)this.conf).isMultiFileSpray();
            this.isBucketed = hconf.getInt("bucket_count", 0) > 0;
            this.isCompactionTable = ((FileSinkDesc)this.conf).isCompactionTable();
            this.totalFiles = ((FileSinkDesc)this.conf).getTotalFiles();
            this.numFiles = ((FileSinkDesc)this.conf).getNumFiles();
            this.dpCtx = ((FileSinkDesc)this.conf).getDynPartCtx();
            this.lbCtx = ((FileSinkDesc)this.conf).getLbCtx();
            this.prevFsp = null;
            this.fsp = null;
            this.valToPaths = new HashMap();
            this.taskId = this.originalTaskId = Utilities.getTaskId(hconf);
            this.initializeSpecPath();
            this.fs = this.specPath.getFileSystem(hconf);
            this.jc = new JobConf(hconf);
            HiveCustomStorageHandlerUtils.setWriteOperation((Configuration)this.jc, ((FileSinkDesc)this.getConf()).getTableInfo().getTableName(), ((FileSinkDesc)this.getConf()).getWriteOperation());
            HiveCustomStorageHandlerUtils.setWriteOperationIsSorted((Configuration)this.jc, ((FileSinkDesc)this.getConf()).getTableInfo().getTableName(), this.dpCtx != null && this.dpCtx.hasCustomSortExpression());
            HiveCustomStorageHandlerUtils.setMergeTaskEnabled((Configuration)this.jc, ((FileSinkDesc)this.getConf()).getTableInfo().getTableName(), Boolean.parseBoolean((String)((FileSinkDesc)this.getConf()).getTableInfo().getProperties().get("file.sink.merge.task.enabled." + ((FileSinkDesc)this.getConf()).getTableInfo().getTableName())));
            try {
                this.createHiveOutputFormat(this.jc);
            }
            catch (HiveException ex) {
                this.logOutputFormatError((Configuration)this.jc, ex);
                throw ex;
            }
            this.isCompressed = ((FileSinkDesc)this.conf).getCompressed();
            this.parent = ((FileSinkDesc)this.conf).isLinkedFileSink() && ((FileSinkDesc)this.conf).isDirectInsert() ? Utilities.toTempPath(((FileSinkDesc)this.conf).getFinalDirName()) : Utilities.toTempPath(((FileSinkDesc)this.conf).getDirName());
            this.statsFromRecordWriter = new boolean[this.numFiles];
            AbstractSerDe serde = ((FileSinkDesc)this.conf).getTableInfo().getSerDeClass().newInstance();
            serde.initialize(this.unsetNestedColumnPaths((Configuration)this.jc), ((FileSinkDesc)this.conf).getTableInfo().getProperties(), null);
            this.serializer = serde;
            this.outputClass = this.serializer.getSerializedClass();
            this.destTablePath = ((FileSinkDesc)this.conf).getDestPath();
            this.isInsertOverwrite = ((FileSinkDesc)this.conf).getInsertOverwrite();
            this.counterGroup = HiveConf.getVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COUNTER_GROUP);
            LOG.info("Using serializer : " + String.valueOf(this.serializer) + " and formatter : " + String.valueOf(this.hiveOutputFormat) + (this.isCompressed ? " with compression" : ""));
            this.timeOut = hconf.getInt("mapred.healthChecker.script.timeout", 600000) / 2;
            if (this.multiFileSpray) {
                this.partitionEval = new ExprNodeEvaluator[((FileSinkDesc)this.conf).getPartitionCols().size()];
                int i = 0;
                for (ExprNodeDesc e : ((FileSinkDesc)this.conf).getPartitionCols()) {
                    this.partitionEval[i++] = ExprNodeEvaluatorFactory.get(e);
                }
                this.partitionObjectInspectors = FileSinkOperator.initEvaluators(this.partitionEval, this.outputObjInspector);
                this.prtner = (HivePartitioner)ReflectionUtils.newInstance((Class)this.jc.getPartitionerClass(), null);
            }
            if (this.dpCtx != null && !this.inspectPartitionValues()) {
                this.dpSetup();
            }
            if (this.lbCtx != null) {
                this.lbSetup();
            }
            if (!this.bDynParts) {
                this.fsp = new FSPaths(this.specPath, ((FileSinkDesc)this.conf).isMmTable(), ((FileSinkDesc)this.conf).isDirectInsert(), ((FileSinkDesc)this.conf).getInsertOverwrite(), ((FileSinkDesc)this.conf).getAcidOperation());
                this.fsp.subdirAfterTxn = FileSinkOperator.combinePathFragments(this.generateListBucketingDirName(null), this.unionPath);
                if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                    Utilities.FILE_OP_LOGGER.trace("creating new paths " + System.identityHashCode(this.fsp) + " from ctor; childSpec " + this.unionPath + ": tmpPath " + String.valueOf(this.fsp.buildTmpPath()) + ", task path " + String.valueOf(this.fsp.buildTaskOutputTempPath()));
                }
                if (!this.isSkewedStoredAsSubDirectories) {
                    this.valToPaths.put("", this.fsp);
                }
            }
            HadoopShims.StoragePolicyValue tmpStorage = HadoopShims.StoragePolicyValue.lookup((String)HiveConf.getVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEMPORARY_TABLE_STORAGE));
            if (this.isTemporary && this.fsp != null && tmpStorage != HadoopShims.StoragePolicyValue.DEFAULT) {
                assert (!((FileSinkDesc)this.conf).isMmTable());
                Path outputPath = this.fsp.buildTaskOutputTempPath();
                HadoopShims.StoragePolicyShim shim = ShimLoader.getHadoopShims().getStoragePolicyShim(this.fs);
                if (shim != null) {
                    this.fs.mkdirs(outputPath);
                    shim.setStoragePolicy(outputPath, tmpStorage);
                }
            }
            if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.UPDATE || ((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.DELETE) {
                this.recIdField = (StructField)((StructObjectInspector)this.outputObjInspector).getAllStructFieldRefs().get(0);
                this.recIdInspector = (StructObjectInspector)this.recIdField.getFieldObjectInspector();
                this.bucketField = (StructField)this.recIdInspector.getAllStructFieldRefs().get(1);
                this.bucketInspector = (IntObjectInspector)this.bucketField.getFieldObjectInspector();
            }
            this.numRows = 0L;
            this.cntr = 1L;
            this.logEveryNRows = HiveConf.getLongVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_LOG_N_RECORDS);
            this.statsMap.put(this.getCounterName(Counter.RECORDS_OUT), this.row_count);
            BiFunction<Object[], ObjectInspector[], Integer> biFunction = this.hashFunc = ((FileSinkDesc)this.conf).getTableInfo().getBucketingVersion() == 2 ? ObjectInspectorUtils::getBucketHashCode : ObjectInspectorUtils::getBucketHashCodeOld;
            if (((FileSinkDesc)this.conf).getTableInfo() != null && ((FileSinkDesc)this.conf).getTableInfo().getTableName() != null) {
                this.statsMap.put(TOTAL_TABLE_ROWS_WRITTEN, this.row_count);
            }
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    private boolean inspectPartitionValues() {
        return Optional.ofNullable((FileSinkDesc)this.conf).map(FileSinkDesc::getTableInfo).map(TableDesc::getProperties).map(props -> props.getProperty("storage_handler")).map(handler -> {
            try {
                return HiveUtils.getStorageHandler(this.hconf, handler);
            }
            catch (HiveException e) {
                return null;
            }
        }).map(HiveStorageHandler::supportsPartitioning).orElse(Boolean.FALSE);
    }

    public String getCounterName(Counter counter) {
        Object suffix = Integer.toString(((FileSinkDesc)this.conf).getDestTableId());
        String fullName = ((FileSinkDesc)this.conf).getTableInfo().getTableName();
        if (fullName != null) {
            suffix = (String)suffix + "_" + fullName.toLowerCase();
        }
        return String.valueOf((Object)counter) + "_" + (String)suffix;
    }

    private void logOutputFormatError(Configuration hconf, HiveException ex) {
        StringBuilder errorWriter = new StringBuilder();
        errorWriter.append("Failed to create output format; configuration: ");
        HiveConfUtil.dumpConfig((Configuration)hconf, (StringBuilder)errorWriter);
        Properties tdp = null;
        if (((FileSinkDesc)this.conf).getTableInfo() != null && (tdp = ((FileSinkDesc)this.conf).getTableInfo().getProperties()) != null) {
            errorWriter.append(";\n table properties: { ");
            for (Map.Entry<Object, Object> e : tdp.entrySet()) {
                errorWriter.append(String.valueOf(e.getKey()) + ": " + String.valueOf(e.getValue()) + ", ");
            }
            errorWriter.append('}');
        }
        LOG.error(errorWriter.toString(), (Throwable)ex);
    }

    private void lbSetup() {
        this.isSkewedStoredAsSubDirectories = this.lbCtx == null ? false : this.lbCtx.isSkewedStoredAsDir();
    }

    private void dpSetup() {
        this.bDynParts = false;
        this.numDynParts = this.dpCtx.getNumDPCols();
        this.dpColNames = this.dpCtx.getDPColNames();
        this.maxPartitions = this.dpCtx.getMaxPartitionsPerNode();
        assert (this.numDynParts == this.dpColNames.size()) : "number of dynamic partitions should be the same as the size of DP mapping";
        if (this.dpColNames != null && this.dpColNames.size() > 0) {
            this.bDynParts = true;
            assert (this.inputObjInspectors.length == 1) : "FileSinkOperator should have 1 parent, but it has " + this.inputObjInspectors.length;
            StructObjectInspector soi = (StructObjectInspector)this.inputObjInspectors[0];
            this.dpStartCol = Utilities.getDPColOffset((FileSinkDesc)this.conf);
            this.subSetOI = new SubStructObjectInspector(soi, 0, this.dpStartCol);
            this.dpVals = new ArrayList<String>(this.numDynParts);
            this.dpWritables = new ArrayList<Object>(this.numDynParts);
        }
    }

    protected void createBucketFilesForCompaction(FSPaths fsp) throws HiveException {
        try {
            if (fsp.outPaths.length < this.bucketId + 1) {
                fsp.updaters = Arrays.copyOf(fsp.updaters, this.bucketId + 1);
                fsp.outPaths = Arrays.copyOf(fsp.outPaths, this.bucketId + 1);
                fsp.finalPaths = Arrays.copyOf(fsp.finalPaths, this.bucketId + 1);
                fsp.outWriters = Arrays.copyOf(fsp.outWriters, this.bucketId + 1);
                this.statsFromRecordWriter = Arrays.copyOf(this.statsFromRecordWriter, this.bucketId + 1);
            }
            this.createBucketForFileIdx(fsp, this.bucketId);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        this.filesCreatedPerBucket.set(this.bucketId);
    }

    protected void createBucketFiles(FSPaths fsp) throws HiveException {
        try {
            int filesIdx = 0;
            HashSet<Integer> seenBuckets = new HashSet<Integer>();
            for (int idx = 0; idx < this.totalFiles; ++idx) {
                if (this.getExecContext() != null && this.getExecContext().getFileId() != null) {
                    LOG.info("replace taskId from execContext");
                    this.taskId = Utilities.replaceTaskIdFromFilename(this.taskId, this.getExecContext().getFileId());
                    LOG.info("new taskId: FS " + this.taskId);
                    assert (!this.multiFileSpray);
                    assert (this.totalFiles == 1);
                }
                int bucketNum = 0;
                if (this.multiFileSpray) {
                    int reducerIdx;
                    int currReducer;
                    this.key.setHashCode(idx);
                    int numReducers = this.totalFiles / this.numFiles;
                    if (numReducers > 1 && (currReducer = Integer.parseInt(Utilities.getTaskIdFromFilename(Utilities.getTaskId(this.hconf)))) != (reducerIdx = this.prtner.getPartition((Object)this.key, null, numReducers)) || seenBuckets.contains(bucketNum = this.prtner.getBucket(this.key, null, this.totalFiles))) continue;
                    seenBuckets.add(bucketNum);
                    this.bucketMap.put(bucketNum, filesIdx);
                    this.taskId = Utilities.replaceTaskIdFromFilename(Utilities.getTaskId(this.hconf), bucketNum);
                }
                this.createBucketForFileIdx(fsp, filesIdx);
                ++filesIdx;
            }
            assert (filesIdx == this.numFiles);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        this.filesCreated = true;
    }

    protected void createBucketForFileIdx(FSPaths fsp, int filesIdx) throws HiveException {
        try {
            if (this.isCompactionTable) {
                fsp.initializeBucketPaths(filesIdx, "bucket_" + String.format("%05d", this.bucketId), this.isNativeTable(), this.isSkewedStoredAsSubDirectories);
            } else {
                fsp.initializeBucketPaths(filesIdx, this.taskId, this.isNativeTable(), this.isSkewedStoredAsSubDirectories);
            }
            if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                Utilities.FILE_OP_LOGGER.trace("createBucketForFileIdx " + filesIdx + ": final path " + String.valueOf(fsp.finalPaths[filesIdx]) + "; out path " + String.valueOf(fsp.outPaths[filesIdx]) + " (spec path " + String.valueOf(this.specPath) + ", tmp path " + String.valueOf(fsp.buildTmpPath()) + ", task " + this.taskId + ")");
            }
            LOG.info("New Final Path: FS " + String.valueOf(fsp.finalPaths[filesIdx]));
            if (this.isNativeTable() && !((FileSinkDesc)this.conf).isMmTable() && !((FileSinkDesc)this.conf).isDirectInsert()) {
                this.autoDelete = this.fs.deleteOnExit(fsp.outPaths[filesIdx]);
            }
            this.updateDPCounters(fsp, filesIdx);
            Utilities.copyTableJobPropertiesToConf(((FileSinkDesc)this.conf).getTableInfo(), this.jc);
            if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.NOT_ACID || ((FileSinkDesc)this.conf).isMmTable() || this.isCompactionTable) {
                Path outPath = fsp.outPaths[filesIdx];
                if (((FileSinkDesc)this.conf).isMmTable() && !FileUtils.mkdir((FileSystem)this.fs, (Path)outPath.getParent(), (Configuration)this.hconf)) {
                    LOG.warn("Unable to create directory with inheritPerms: " + String.valueOf(outPath));
                }
                fsp.outWriters[filesIdx] = HiveFileFormatUtils.getHiveRecordWriter(this.jc, ((FileSinkDesc)this.conf).getTableInfo(), this.outputClass, (FileSinkDesc)this.conf, outPath, this.reporter);
                this.statsFromRecordWriter[filesIdx] = fsp.outWriters[filesIdx] instanceof StatsProvidingRecordWriter;
            } else if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.INSERT) {
                Path outPath = fsp.outPaths[filesIdx];
                if (((FileSinkDesc)this.conf).isDirectInsert() && !FileUtils.mkdir((FileSystem)this.fs, (Path)outPath.getParent(), (Configuration)this.hconf)) {
                    LOG.warn("Unable to create directory: " + String.valueOf(outPath));
                }
                SubStructObjectInspector inspector = this.bDynParts ? this.subSetOI : this.outputObjInspector;
                int acidBucketNum = Integer.parseInt(Utilities.getTaskIdFromFilename(this.taskId));
                Integer attemptId = this.getAttemptIdFromTaskId(this.taskId);
                fsp.updaters[filesIdx] = HiveFileFormatUtils.getAcidRecordUpdater(this.jc, ((FileSinkDesc)this.conf).getTableInfo(), acidBucketNum, (FileSinkDesc)this.conf, fsp.outPaths[filesIdx], (ObjectInspector)inspector, this.reporter, -1, attemptId);
            }
            if (this.reporter != null) {
                this.reporter.incrCounter(this.counterGroup, "CREATED_FILES", 1L);
            }
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
    }

    private void updateDPCounters(FSPaths fsp, int filesIdx) {
        if (this.bDynParts && this.destTablePath != null && fsp.dpDirForCounters != null) {
            Path destPartPath = new Path(this.destTablePath, fsp.dpDirForCounters);
            try {
                if (((FileSinkDesc)this.conf).isMmTable() || ((FileSinkDesc)this.conf).isDirectInsert()) {
                    this.createDpDir(destPartPath);
                } else {
                    Path dpStagingDir = fsp.outPaths[filesIdx].getParent();
                    if (this.isUnionDp) {
                        dpStagingDir = dpStagingDir.getParent();
                    }
                    if (this.isInsertOverwrite) {
                        this.createDpDir(dpStagingDir);
                    } else {
                        this.createDpDirCheckSrc(dpStagingDir, destPartPath);
                    }
                }
            }
            catch (IOException e) {
                LOG.warn("Skipping to increment CREATED_DYNAMIC_PARTITIONS counter.Exception: {}", (Object)e.getMessage());
            }
        }
    }

    private void createDpDirCheckSrc(Path dpStagingPath, Path dpFinalPath) throws IOException {
        FileSystem dpFs;
        if (!this.fs.exists(dpStagingPath) && !(dpFs = dpFinalPath.getFileSystem(this.hconf)).exists(dpFinalPath)) {
            this.fs.mkdirs(dpStagingPath);
            if (this.reporter != null) {
                this.reporter.incrCounter(this.counterGroup, "CREATED_DYNAMIC_PARTITIONS", 1L);
            }
        }
    }

    private void createDpDir(Path dpPath) throws IOException {
        if (!this.fs.exists(dpPath)) {
            this.fs.mkdirs(dpPath);
            if (this.reporter != null) {
                this.reporter.incrCounter(this.counterGroup, "CREATED_DYNAMIC_PARTITIONS", 1L);
            }
        }
    }

    protected boolean updateProgress() {
        if (this.reporter != null && System.currentTimeMillis() - this.lastProgressReport > (long)this.timeOut) {
            this.reporter.progress();
            this.lastProgressReport = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        block39: {
            ++this.runTimeNumRows;
            String lbDirName = null;
            String string = lbDirName = this.lbCtx == null ? null : this.generateListBucketingDirName(row);
            if (!(this.bDynParts || this.filesCreated && !this.isCompactionTable)) {
                if (lbDirName != null) {
                    if (this.valToPaths.get(lbDirName) == null) {
                        this.createNewPaths(null, lbDirName);
                    }
                } else if (this.isCompactionTable) {
                    if (((FileSinkDesc)this.conf).isRebalanceRequested()) {
                        this.bucketId = this.getBucketProperty(row);
                        this.setBucketProperty(this.hconf, row, this.bucketId);
                    } else {
                        int bucketProperty = this.getBucketProperty(row);
                        this.bucketId = BucketCodec.determineVersion(bucketProperty).decodeWriterId(bucketProperty);
                    }
                    if (!this.filesCreatedPerBucket.get(this.bucketId)) {
                        this.createBucketFilesForCompaction(this.fsp);
                    }
                } else {
                    this.createBucketFiles(this.fsp);
                }
            }
            try {
                this.updateProgress();
                assert (this.inputObjInspectors[0].getCategory() == ObjectInspector.Category.STRUCT) : "input object inspector is not struct";
                if (this.bDynParts) {
                    if (((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.PARTITION_BUCKET_SORTED)) {
                        ++this.numDynParts;
                    }
                    this.dpVals.clear();
                    this.dpWritables.clear();
                    ObjectInspectorUtils.partialCopyToStandardObject(this.dpWritables, (Object)row, (int)this.dpStartCol, (int)this.numDynParts, (StructObjectInspector)((StructObjectInspector)this.inputObjInspectors[0]), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                    for (Object o : this.dpWritables) {
                        if (o == null || o.toString().length() == 0) {
                            this.dpVals.add(this.dpCtx.getDefaultPartitionName());
                            continue;
                        }
                        this.dpVals.add(o.toString());
                    }
                    String invalidPartitionVal = HiveStringUtils.getPartitionValWithInvalidCharacter(this.dpVals, (Pattern)this.dpCtx.getWhiteListPattern());
                    if (invalidPartitionVal != null) {
                        String errorMsg = "Partition value '%s' contains a character not matched by whitelist pattern '%s'. Configure with %s".formatted(invalidPartitionVal, this.dpCtx.getWhiteListPattern().toString(), MetastoreConf.ConfVars.PARTITION_NAME_WHITELIST_PATTERN.getVarname());
                        throw new HiveFatalException(errorMsg);
                    }
                    this.fpaths = this.getDynOutPaths(this.dpVals, lbDirName);
                    this.dynamicPartitionSpecs.add(this.fpaths.dpDirForCounters);
                    this.recordValue = this.serializer.serialize(row, (ObjectInspector)this.subSetOI);
                } else {
                    if (lbDirName != null) {
                        this.fpaths = this.valToPaths.get(lbDirName);
                        if (this.fpaths == null) {
                            this.fpaths = this.createNewPaths(null, lbDirName);
                        }
                    } else {
                        this.fpaths = this.fsp;
                    }
                    this.recordValue = this.serializer.serialize(row, this.inputObjInspectors[0]);
                    if (this.recordValue == null) {
                        return;
                    }
                }
                this.rowOutWriters = this.fpaths.outWriters;
                this.isCollectRWStats = this.areAllTrue(this.statsFromRecordWriter);
                if (((FileSinkDesc)this.conf).isGatherStats() && !this.isCollectRWStats) {
                    SerDeStats stats = this.serializer.getSerDeStats();
                    if (stats != null) {
                        this.fpaths.addToStat("rawDataSize", stats.getRawDataSize());
                    }
                    this.fpaths.addToStat("numRows", 1L);
                }
                if (++this.numRows == this.cntr && LOG.isInfoEnabled()) {
                    long l = this.cntr = this.logEveryNRows == 0L ? this.cntr * 10L : this.numRows + this.logEveryNRows;
                    if (this.cntr < 0L || this.numRows < 0L) {
                        this.cntr = 0L;
                        this.numRows = 1L;
                    }
                    LOG.info("{}: {} written - {}", new Object[]{this, ((FileSinkDesc)this.conf).isDeleteOfSplitUpdate() ? "delete delta records" : "records", this.numRows});
                }
                if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.NOT_ACID || ((FileSinkDesc)this.conf).isMmTable() || this.isCompactionTable) {
                    int writerOffset = this.bucketId;
                    if (!this.isCompactionTable) {
                        writerOffset = this.findWriterOffset(row);
                    }
                    this.rowOutWriters[writerOffset].write(this.recordValue);
                    break block39;
                }
                if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.INSERT) {
                    this.fpaths.updaters[this.findWriterOffset(row)].insert(((FileSinkDesc)this.conf).getTableWriteId(), row);
                    break block39;
                }
                SubStructObjectInspector rowInspector = this.bDynParts ? this.subSetOI : this.outputObjInspector;
                Object recId = ((StructObjectInspector)rowInspector).getStructFieldData(row, this.recIdField);
                int bucketProperty = this.bucketInspector.get(this.recIdInspector.getStructFieldData(recId, this.bucketField));
                int bucketNum = BucketCodec.determineVersion(bucketProperty).decodeWriterId(bucketProperty);
                int writerOffset = 0;
                if (this.multiFileSpray) {
                    if (!this.bucketMap.containsKey(bucketNum)) {
                        String extraMsg = "  (no path info/)" + String.valueOf(recId);
                        if (this.fpaths != null && this.fpaths.finalPaths != null && this.fpaths.finalPaths.length > 0) {
                            extraMsg = "  (finalPaths[0]=" + String.valueOf(this.fpaths.finalPaths[0]) + ")/" + String.valueOf(recId);
                        }
                        throw new IllegalStateException("Found bucketNum=" + bucketNum + " from data but no mapping in 'bucketMap'." + extraMsg);
                    }
                    writerOffset = this.bucketMap.get(bucketNum);
                } else if (!this.isBucketed) {
                    writerOffset = this.fpaths.createDynamicBucket(bucketNum);
                }
                if (this.fpaths.updaters[writerOffset] == null) {
                    Integer attemptId = this.getAttemptIdFromTaskId(this.taskId);
                    this.fpaths.updaters[writerOffset] = HiveFileFormatUtils.getAcidRecordUpdater(this.jc, ((FileSinkDesc)this.conf).getTableInfo(), bucketNum, (FileSinkDesc)this.conf, this.fpaths.outPaths[writerOffset], (ObjectInspector)rowInspector, this.reporter, 0, attemptId);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Created updater for bucket number " + bucketNum + " using file " + String.valueOf(this.fpaths.outPaths[writerOffset]));
                    }
                }
                if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.UPDATE) {
                    this.fpaths.updaters[writerOffset].update(((FileSinkDesc)this.conf).getTableWriteId(), row);
                    break block39;
                }
                if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.DELETE) {
                    this.fpaths.updaters[writerOffset].delete(((FileSinkDesc)this.conf).getTableWriteId(), row);
                    break block39;
                }
                throw new HiveException("Unknown write type " + ((FileSinkDesc)this.conf).getWriteType().toString());
            }
            catch (IOException e) {
                LOG.error("Trying to close the writers as an IOException occurred: " + e.getMessage());
                this.closeWriters(true);
                throw new HiveException((Throwable)e);
            }
            catch (SerDeException e) {
                this.closeWriters(true);
                throw new HiveException((Throwable)e);
            }
        }
    }

    private void closeWriters(boolean abort) throws HiveException {
        this.fpaths.closeWriters(true, null);
        this.closeRecordwriters(true);
    }

    private void closeRecordwriters(boolean abort) {
        if (this.rowOutWriters != null) {
            for (RecordWriter writer : this.rowOutWriters) {
                try {
                    if (writer == null) continue;
                    LOG.info("Closing {} on exception", (Object)writer);
                    writer.close(abort);
                }
                catch (IOException e) {
                    LOG.error("Error closing rowOutWriter" + String.valueOf(writer), (Throwable)e);
                }
            }
        }
    }

    protected boolean areAllTrue(boolean[] statsFromRW) {
        if (((FileSinkDesc)this.conf).getWriteType() != AcidUtils.Operation.NOT_ACID && !((FileSinkDesc)this.conf).isMmTable() && !this.isCompactionTable) {
            return true;
        }
        for (boolean b : statsFromRW) {
            if (b) continue;
            return false;
        }
        return true;
    }

    private int findWriterOffset(Object row) throws HiveException {
        if (!this.multiFileSpray) {
            return 0;
        }
        assert (((FileSinkDesc)this.getConf()).getWriteType() != AcidUtils.Operation.DELETE && ((FileSinkDesc)this.getConf()).getWriteType() != AcidUtils.Operation.UPDATE) : "Unexpected operation type: " + String.valueOf(((FileSinkDesc)this.getConf()).getWriteType());
        Object[] bucketFieldValues = new Object[this.partitionEval.length];
        for (int i = 0; i < this.partitionEval.length; ++i) {
            bucketFieldValues[i] = this.partitionEval[i].evaluate(row);
        }
        int keyHashCode = this.hashFunc.apply(bucketFieldValues, this.partitionObjectInspectors);
        this.key.setHashCode(keyHashCode);
        int bucketNum = this.prtner.getBucket(this.key, null, this.totalFiles);
        return this.bucketMap.get(bucketNum);
    }

    private FSPaths createNewPaths(String dpDir, String lbDir) throws HiveException {
        FSPaths fsp2 = new FSPaths(this.specPath, ((FileSinkDesc)this.conf).isMmTable(), ((FileSinkDesc)this.conf).isDirectInsert(), ((FileSinkDesc)this.conf).getInsertOverwrite(), ((FileSinkDesc)this.conf).getAcidOperation());
        fsp2.subdirAfterTxn = FileSinkOperator.combinePathFragments(lbDir, this.unionPath);
        fsp2.subdirBeforeTxn = dpDir;
        String pathKey = FileSinkOperator.combinePathFragments(dpDir, lbDir);
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("creating new paths {} for {}, childSpec {}: tmpPath {}, task path {}", new Object[]{System.identityHashCode(fsp2), pathKey, this.unionPath, fsp2.buildTmpPath(), fsp2.buildTaskOutputTempPath()});
        }
        if (this.bDynParts) {
            fsp2.dpDirForCounters = pathKey;
        }
        if (!((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.PARTITION_BUCKET_SORTED)) {
            this.createBucketFiles(fsp2);
            this.valToPaths.put(pathKey, fsp2);
        }
        return fsp2;
    }

    private static String combinePathFragments(String first, String second) {
        return first == null ? second : (second == null ? first : first + "/" + second);
    }

    protected String generateListBucketingDirName(Object row) {
        if (!this.isSkewedStoredAsSubDirectories) {
            return null;
        }
        String lbDirName = null;
        List<String> skewedCols = this.lbCtx.getSkewedColNames();
        List<List<String>> allSkewedVals = this.lbCtx.getSkewedColValues();
        Map<List<String>, String> locationMap = this.lbCtx.getLbLocationMap();
        if (row != null) {
            ArrayList standObjs = new ArrayList();
            ArrayList<String> skewedValsCandidate = null;
            ObjectInspectorUtils.copyToStandardObject(standObjs, (Object)row, (StructObjectInspector)((StructObjectInspector)this.inputObjInspectors[0]), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            assert (standObjs.size() >= skewedCols.size()) : "The row has less number of columns than no. of skewed column.";
            skewedValsCandidate = new ArrayList<String>(skewedCols.size());
            for (SkewedColumnPositionPair posPair : this.lbCtx.getRowSkewedIndex()) {
                skewedValsCandidate.add(posPair.getSkewColPosition(), standObjs.get(posPair.getTblColPosition()).toString());
            }
            if (allSkewedVals.contains(skewedValsCandidate)) {
                lbDirName = FileUtils.makeListBucketingDirName(skewedCols, skewedValsCandidate);
                locationMap.put(skewedValsCandidate, lbDirName);
            } else {
                lbDirName = this.createDefaultLbDir(skewedCols, locationMap);
            }
        } else {
            lbDirName = this.createDefaultLbDir(skewedCols, locationMap);
        }
        return lbDirName;
    }

    private String createDefaultLbDir(List<String> skewedCols, Map<List<String>, String> locationMap) {
        String lbDirName = FileUtils.makeDefaultListBucketingDirName(skewedCols, (String)this.lbCtx.getDefaultDirName());
        ArrayList defaultKey = Lists.newArrayList((Object[])new String[]{this.lbCtx.getDefaultKey()});
        if (!locationMap.containsKey(defaultKey)) {
            locationMap.put(defaultKey, lbDirName);
        }
        return lbDirName;
    }

    protected FSPaths getDynOutPaths(List<String> row, String lbDir) throws HiveException {
        FSPaths fp;
        String dpDir = this.getDynPartDirectory(row, this.dpColNames);
        Object pathKey = null;
        if (dpDir != null) {
            FSPaths fsp2;
            String dpAndLbDir = FileSinkOperator.combinePathFragments(dpDir, lbDir);
            pathKey = dpAndLbDir;
            if (((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.PARTITION_BUCKET_SORTED)) {
                String buckNum = row.get(row.size() - 1);
                this.taskId = Utilities.replaceTaskIdFromFilename(this.taskId, buckNum);
                pathKey = dpAndLbDir + "/" + this.taskId;
            }
            if ((fsp2 = this.valToPaths.get(pathKey)) == null) {
                if (this.valToPaths.size() > this.maxPartitions) {
                    throw new HiveFatalException(ErrorMsg.DYNAMIC_PARTITIONS_TOO_MANY_PER_NODE_ERROR.getErrorCodedMsg() + "Maximum was set to " + this.maxPartitions + " partitions per node, number of dynamic partitions on this node: " + this.valToPaths.size());
                }
                if (!((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.NONE) && this.prevFsp != null) {
                    this.prevFsp.closeWriters(false, null);
                    if (((FileSinkDesc)this.conf).isGatherStats() && this.isCollectRWStats) {
                        SerDeStats stats = null;
                        if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.NOT_ACID || ((FileSinkDesc)this.conf).isMmTable()) {
                            RecordWriter outWriter = this.prevFsp.outWriters[0];
                            if (outWriter != null) {
                                stats = ((StatsProvidingRecordWriter)outWriter).getStats();
                            }
                        } else if (this.prevFsp.updaters[0] != null) {
                            stats = this.prevFsp.updaters[0].getStats();
                        }
                        if (stats != null && !((FileSinkDesc)this.conf).isFullAcidTable()) {
                            this.prevFsp.addToStat("rawDataSize", stats.getRawDataSize());
                            this.prevFsp.addToStat("numRows", stats.getRowCount());
                        }
                    }
                    this.prevFsp.outWriters[0] = null;
                    this.prevFsp = null;
                }
                fsp2 = this.createNewPaths(dpDir, lbDir);
                if (this.prevFsp == null) {
                    this.prevFsp = fsp2;
                }
                if (((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.PARTITION_BUCKET_SORTED)) {
                    this.createBucketForFileIdx(fsp2, 0);
                    this.valToPaths.put((String)pathKey, fsp2);
                }
            }
            fp = fsp2;
        } else {
            fp = this.fsp;
        }
        return fp;
    }

    private String getDynPartDirectory(List<String> row, List<String> dpColNames) {
        return FileUtils.makePartName(dpColNames, row);
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        this.row_count.set(((FileSinkDesc)this.conf).isDeleteOfSplitUpdate() ? 0L : this.numRows);
        LOG.info("{}: {} written - {}", new Object[]{this, ((FileSinkDesc)this.conf).isDeleteOfSplitUpdate() ? "delete delta records" : "records", this.numRows});
        if (!this.bDynParts && !this.filesCreated) {
            boolean isTez = "tez".equalsIgnoreCase(HiveConf.getVar((Configuration)this.hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE));
            Class<? extends OutputFormat> clazz = ((FileSinkDesc)this.conf).getTableInfo().getOutputFileFormatClass();
            boolean isStreaming = StreamingOutputFormat.class.isAssignableFrom(clazz);
            if (!isTez || isStreaming || this.isInsertOverwrite && (((FileSinkDesc)this.conf).isMmTable() || ((FileSinkDesc)this.conf).isFullAcidTable())) {
                this.createBucketFiles(this.fsp);
            }
        }
        this.lastProgressReport = System.currentTimeMillis();
        if (!abort) {
            if (((FileSinkDesc)this.conf).isUsingBatchingSerDe()) {
                try {
                    this.recordValue = this.serializer.serialize(null, this.inputObjInspectors[0]);
                    if (null != this.fpaths) {
                        this.rowOutWriters = this.fpaths.outWriters;
                        this.rowOutWriters[0].write(this.recordValue);
                    }
                }
                catch (IOException | SerDeException e) {
                    throw new HiveException(e);
                }
            }
            ArrayList<Path> commitPaths = new ArrayList<Path>();
            for (FSPaths fsp : this.valToPaths.values()) {
                ArrayList<Path> deleteDeltas = new ArrayList<Path>();
                fsp.closeWriters(abort, deleteDeltas);
                if (((FileSinkDesc)this.conf).isGatherStats() && this.isCollectRWStats) {
                    if (((FileSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.NOT_ACID || ((FileSinkDesc)this.conf).isMmTable() || this.isCompactionTable) {
                        for (int idx = 0; idx < fsp.outWriters.length; ++idx) {
                            SerDeStats stats;
                            RecordWriter outWriter = fsp.outWriters[idx];
                            if (outWriter == null || (stats = ((StatsProvidingRecordWriter)outWriter).getStats()) == null) continue;
                            fsp.addToStat("rawDataSize", stats.getRawDataSize());
                            fsp.addToStat("numRows", stats.getRowCount());
                        }
                    } else {
                        for (int i = 0; i < fsp.updaters.length; ++i) {
                            SerDeStats stats;
                            if (fsp.updaters[i] == null || (stats = fsp.updaters[i].getStats()) == null) continue;
                            fsp.addToStat("rawDataSize", stats.getRawDataSize());
                            fsp.addToStat("numRows", stats.getRowCount());
                            fsp.addToStat("insertCount", stats.getInsertCount());
                            fsp.addToStat("updateCount", stats.getUpdateCount());
                            fsp.addToStat("deleteCount", stats.getDeleteCount());
                        }
                    }
                }
                if (!this.isNativeTable()) continue;
                fsp.commit(this.fs, commitPaths, deleteDeltas);
            }
            if (((FileSinkDesc)this.conf).isMmTable() || ((FileSinkDesc)this.conf).isDirectInsert()) {
                boolean isDelete = AcidUtils.Operation.DELETE.equals(((FileSinkDesc)this.conf).getAcidOperation());
                Utilities.writeCommitManifest(commitPaths, this.specPath, this.fs, this.originalTaskId, ((FileSinkDesc)this.conf).getTableWriteId(), ((FileSinkDesc)this.conf).getStatementId(), this.unionPath, ((FileSinkDesc)this.conf).getInsertOverwrite(), this.bDynParts, this.dynamicPartitionSpecs, ((FileSinkDesc)this.conf).getStaticSpec(), isDelete);
            }
            if (((FileSinkDesc)this.conf).isGatherStats()) {
                this.publishStats();
            }
        } else {
            for (FSPaths fsp : this.valToPaths.values()) {
                fsp.abortWritersAndUpdaters(this.fs, abort, !this.autoDelete && this.isNativeTable() && !((FileSinkDesc)this.conf).isMmTable() && !((FileSinkDesc)this.conf).isDirectInsert());
            }
        }
        this.prevFsp = null;
        this.fsp = null;
        super.closeOp(abort);
    }

    @Override
    public String getName() {
        return FileSinkOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "FS";
    }

    @Override
    public void jobCloseOp(Configuration hconf, boolean success) throws HiveException {
        try {
            if (this.conf != null && this.isNativeTable()) {
                Path specPath = ((FileSinkDesc)this.conf).getDirName();
                String unionSuffix = null;
                DynamicPartitionCtx dpCtx = ((FileSinkDesc)this.conf).getDynPartCtx();
                ListBucketingCtx lbCtx = ((FileSinkDesc)this.conf).getLbCtx();
                if (((FileSinkDesc)this.conf).isLinkedFileSink() && (dpCtx != null || ((FileSinkDesc)this.conf).isMmTable())) {
                    specPath = ((FileSinkDesc)this.conf).isMmTable() ? ((FileSinkDesc)this.conf).getParentDir() : ((FileSinkDesc)this.conf).getDirName();
                    unionSuffix = ((FileSinkDesc)this.conf).getDirName().getName();
                }
                if (((FileSinkDesc)this.conf).isLinkedFileSink() && ((FileSinkDesc)this.conf).isDirectInsert()) {
                    specPath = ((FileSinkDesc)this.conf).getParentDir();
                    unionSuffix = null;
                }
                if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                    Utilities.FILE_OP_LOGGER.trace("jobCloseOp using specPath " + String.valueOf(specPath));
                }
                if (!((FileSinkDesc)this.conf).isMmTable() && !((FileSinkDesc)this.conf).isDirectInsert()) {
                    Utilities.mvFileToFinalPath(specPath, unionSuffix, hconf, success, LOG, dpCtx, (FileSinkDesc)this.conf, this.reporter);
                } else {
                    int lbLevels;
                    int dpLevels = dpCtx == null ? 0 : dpCtx.getNumDPCols();
                    int n = lbLevels = lbCtx == null ? 0 : lbCtx.calculateListBucketingLevel();
                    int numBuckets = ((FileSinkDesc)this.conf).getTable() != null ? ((FileSinkDesc)this.conf).getTable().getNumBuckets() : (dpCtx != null ? dpCtx.getNumBuckets() : 0);
                    Utilities.MissingBucketsContext mbc = new Utilities.MissingBucketsContext(((FileSinkDesc)this.conf).getTableInfo(), numBuckets, ((FileSinkDesc)this.conf).getCompressed());
                    Utilities.handleDirectInsertTableFinalPath(specPath, unionSuffix, hconf, success, dpLevels, lbLevels, mbc, ((FileSinkDesc)this.conf).getTableWriteId(), ((FileSinkDesc)this.conf).getStatementId(), this.reporter, ((FileSinkDesc)this.conf).isMmTable(), ((FileSinkDesc)this.conf).isMmCtas(), ((FileSinkDesc)this.conf).getInsertOverwrite(), ((FileSinkDesc)this.conf).isDirectInsert(), ((FileSinkDesc)this.conf).getStaticSpec(), ((FileSinkDesc)this.conf).getAcidOperation(), (FileSinkDesc)this.conf);
                }
            }
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
        super.jobCloseOp(hconf, success);
    }

    @Override
    public OperatorType getType() {
        return OperatorType.FILESINK;
    }

    @Override
    public void augmentPlan() {
        PlanUtils.configureOutputJobPropertiesForStorageHandler(((FileSinkDesc)this.getConf()).getTableInfo());
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        if (this.hiveOutputFormat == null) {
            try {
                this.createHiveOutputFormat(job);
            }
            catch (HiveException ex) {
                this.logOutputFormatError((Configuration)job, ex);
                throw new IOException(ex);
            }
        }
        if (((FileSinkDesc)this.conf).getTableInfo().isNonNative()) {
            try {
                this.hiveOutputFormat.checkOutputSpecs(ignored, job);
            }
            catch (NoSuchMethodError e) {
                LOG.warn("HiveOutputFormat should implement checkOutputSpecs() method`");
            }
        }
    }

    private void createHiveOutputFormat(JobConf job) throws HiveException {
        if (this.hiveOutputFormat == null) {
            Utilities.copyTableJobPropertiesToConf(((FileSinkDesc)this.conf).getTableInfo(), job);
        }
        try {
            this.hiveOutputFormat = HiveFileFormatUtils.getHiveOutputFormat((Configuration)job, ((FileSinkDesc)this.getConf()).getTableInfo());
        }
        catch (Throwable t) {
            throw t instanceof HiveException ? (HiveException)t : new HiveException(t);
        }
    }

    private void publishStats() throws HiveException {
        boolean isStatsReliable = ((FileSinkDesc)this.conf).isStatsReliable();
        StatsPublisher statsPublisher = Utilities.getStatsPublisher(this.jc);
        if (statsPublisher == null) {
            LOG.error("StatsPublishing error: StatsPublisher is not initialized.");
            if (isStatsReliable) {
                throw new HiveException(ErrorMsg.STATSPUBLISHER_NOT_OBTAINED.getErrorCodedMsg());
            }
            return;
        }
        StatsCollectionContext sContext = new StatsCollectionContext(this.hconf);
        sContext.setStatsTmpDir(((FileSinkDesc)this.conf).getTmpStatsDir());
        if (!statsPublisher.connect(sContext)) {
            LOG.error("StatsPublishing error: cannot connect to database");
            if (isStatsReliable) {
                throw new HiveException(ErrorMsg.STATSPUBLISHER_CONNECTION_ERROR.getErrorCodedMsg());
            }
            return;
        }
        String spSpec = ((FileSinkDesc)this.conf).getStaticSpec();
        for (Map.Entry<String, FSPaths> entry : this.valToPaths.entrySet()) {
            String fspKey = entry.getKey();
            FSPaths fspValue = entry.getValue();
            if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                Utilities.FILE_OP_LOGGER.trace("Observing entry for stats " + fspKey + " => FSP with tmpPath " + String.valueOf(fspValue.buildTmpPath()));
            }
            if (((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.PARTITION_BUCKET_SORTED)) {
                String taskID = Utilities.getTaskIdFromFilename(fspKey);
                fspKey = fspKey.split(taskID)[0];
            }
            String[] split = this.splitKey(fspKey);
            String dpSpec = split[0];
            Object prefix = ((FileSinkDesc)this.conf).getTableInfo().getTableName().toLowerCase();
            Object object = prefix = ((String)(prefix = Utilities.join(new String[]{prefix, spSpec, dpSpec}))).endsWith("/") ? prefix : (String)prefix + "/";
            if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                Utilities.FILE_OP_LOGGER.trace("Prefix for stats " + (String)prefix + " (from " + spSpec + ", " + dpSpec + ")");
            }
            HashMap<String, String> statsToPublish = new HashMap<String, String>();
            for (String statType : fspValue.getStoredStats()) {
                statsToPublish.put(statType, Long.toString(fspValue.stat.getStat(statType)));
            }
            if (statsPublisher.publishStat((String)prefix, statsToPublish)) continue;
            LOG.error("Failed to publish stats");
            if (!isStatsReliable) continue;
            throw new HiveException(ErrorMsg.STATSPUBLISHER_PUBLISHING_ERROR.getErrorCodedMsg());
        }
        sContext.setContextSuffix(this.getOperatorId());
        if (!statsPublisher.closeConnection(sContext)) {
            LOG.error("Failed to close stats");
            if (isStatsReliable) {
                throw new HiveException(ErrorMsg.STATSPUBLISHER_CLOSING_ERROR.getErrorCodedMsg());
            }
        }
    }

    private String[] splitKey(String fspKey) {
        if (!fspKey.isEmpty() && this.isSkewedStoredAsSubDirectories) {
            for (String dir : this.lbCtx.getSkewedValuesDirNames()) {
                int index = fspKey.indexOf(dir);
                if (index < 0) continue;
                return new String[]{fspKey.substring(0, index), fspKey.substring(index + 1)};
            }
        }
        return new String[]{fspKey, null};
    }

    private Configuration unsetNestedColumnPaths(Configuration conf) {
        if (conf.get("hive.io.file.readNestedColumn.paths") != null) {
            Configuration confCopy = new Configuration(conf);
            confCopy.unset("hive.io.file.readNestedColumn.paths");
            return confCopy;
        }
        return conf;
    }

    private boolean isNativeTable() {
        return !((FileSinkDesc)this.conf).getTableInfo().isNonNative();
    }

    @Override
    public void configureJobConf(JobConf job) {
        if (((FileSinkDesc)this.conf).getInsertOverwrite()) {
            job.setBoolean("ENSURE_OPERATORS_EXECUTED", true);
        }
    }

    private int getBucketProperty(Object row) {
        Object bucketProperty = ((Object[])row)[2];
        if (bucketProperty instanceof Writable) {
            return ((IntWritable)bucketProperty).get();
        }
        return (Integer)bucketProperty;
    }

    private void setBucketProperty(Configuration hiveConf, Object row, int bucketId) {
        int encodedBucketValue = BucketCodec.V1.encode(new AcidOutputFormat.Options(hiveConf).bucket(bucketId));
        Object bucketProperty = ((Object[])row)[2];
        if (bucketProperty instanceof Writable) {
            ((IntWritable)bucketProperty).set(encodedBucketValue);
        } else {
            ((Object[])row)[2] = encodedBucketValue;
        }
    }

    private Integer getAttemptIdFromTaskId(String taskId) {
        if (!((FileSinkDesc)this.conf).isDirectInsert() || taskId == null || taskId.split("_").length < 2) {
            return null;
        }
        Integer attemptId = Integer.parseInt(taskId.split("_")[1]);
        LOG.debug("Parsed the attemptId " + attemptId.toString() + " from the task ID " + taskId);
        return attemptId;
    }

    public class FSPaths
    implements Cloneable {
        private Path tmpPathRoot;
        private String subdirBeforeTxn;
        private String subdirAfterTxn;
        private final String subdirForTxn;
        private Path taskOutputTempPathRoot;
        Path[] outPaths;
        Path[] outPathsCommitted;
        Path[] finalPaths;
        RecordWriter[] outWriters;
        RecordUpdater[] updaters;
        Stat stat;
        int acidLastBucket = -1;
        int acidFileOffset = -1;
        private boolean isMmTable;
        private boolean isDirectInsert;
        private AcidUtils.Operation acidOperation;
        private boolean isInsertOverwrite;
        String dpDirForCounters;

        public FSPaths(Path specPath, boolean isMmTable, boolean isDirectInsert, boolean isInsertOverwrite, AcidUtils.Operation acidOperation) {
            this.isMmTable = isMmTable;
            this.isDirectInsert = isDirectInsert;
            this.acidOperation = acidOperation;
            this.isInsertOverwrite = isInsertOverwrite;
            if (!isMmTable && !isDirectInsert) {
                this.tmpPathRoot = Utilities.toTempPath(specPath);
                this.taskOutputTempPathRoot = Utilities.toTaskTempPath(specPath);
                this.subdirForTxn = null;
            } else {
                this.tmpPathRoot = specPath;
                this.taskOutputTempPathRoot = null;
                this.subdirForTxn = isMmTable ? AcidUtils.baseOrDeltaSubdir(((FileSinkDesc)FileSinkOperator.this.conf).getInsertOverwrite(), ((FileSinkDesc)FileSinkOperator.this.conf).getTableWriteId(), ((FileSinkDesc)FileSinkOperator.this.conf).getTableWriteId(), ((FileSinkDesc)FileSinkOperator.this.conf).getStatementId()) : null;
            }
            if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                Utilities.FILE_OP_LOGGER.trace("new FSPaths for " + FileSinkOperator.this.numFiles + " files, dynParts = " + FileSinkOperator.this.bDynParts + " (spec path " + String.valueOf(specPath) + ")");
            }
            this.outPaths = new Path[FileSinkOperator.this.numFiles];
            this.outPathsCommitted = new Path[FileSinkOperator.this.numFiles];
            this.finalPaths = new Path[FileSinkOperator.this.numFiles];
            this.outWriters = new RecordWriter[FileSinkOperator.this.numFiles];
            this.updaters = new RecordUpdater[FileSinkOperator.this.numFiles];
            LOG.debug("Created slots for {}", (Object)FileSinkOperator.this.numFiles);
            this.stat = new Stat();
        }

        public void closeWriters(boolean abort, List<Path> deleteDeltas) throws HiveException {
            IOException exception = null;
            for (int idx = 0; idx < this.outWriters.length; ++idx) {
                if (this.outWriters[idx] == null) continue;
                try {
                    this.outWriters[idx].close(abort);
                    FileSinkOperator.this.updateProgress();
                    continue;
                }
                catch (IOException e) {
                    exception = e;
                    LOG.error("Error closing " + this.outWriters[idx].toString(), (Throwable)e);
                }
            }
            for (int i = 0; i < this.updaters.length; ++i) {
                if (this.updaters[i] == null) continue;
                SerDeStats stats = this.updaters[i].getStats();
                if (this.isDirectInsert && (stats.getRowCount() > 0L || this.isInsertOverwrite || AcidUtils.Operation.DELETE.equals(this.acidOperation) || AcidUtils.Operation.UPDATE.equals(this.acidOperation))) {
                    OrcRecordUpdater recordUpdater = (OrcRecordUpdater)this.updaters[i];
                    switch (this.acidOperation) {
                        case INSERT: {
                            this.outPathsCommitted[i] = recordUpdater.getUpdatedFilePath();
                            break;
                        }
                        case UPDATE: {
                            this.outPathsCommitted[i] = recordUpdater.getUpdatedFilePath();
                            if (deleteDeltas == null) break;
                            deleteDeltas.add(recordUpdater.getDeleteFilePath());
                            LOG.debug("The following path has been added to the deleteDeltas list: " + recordUpdater.getDeleteFilePath().toString());
                            break;
                        }
                        case DELETE: {
                            this.outPathsCommitted[i] = recordUpdater.getDeleteFilePath();
                            break;
                        }
                    }
                    LOG.debug("The following path has been added to the outPathsCommitted array: " + this.outPathsCommitted[i].toString());
                }
                try {
                    this.updaters[i].close(abort);
                    continue;
                }
                catch (IOException e) {
                    exception = e;
                    LOG.error("Error closing " + this.updaters[i].toString(), (Throwable)e);
                }
            }
            if (exception != null) {
                throw new HiveException((Throwable)exception);
            }
        }

        private void commit(FileSystem fs, List<Path> commitPaths, List<Path> deleteDeltas) throws HiveException {
            for (int idx = 0; idx < this.outPaths.length; ++idx) {
                try {
                    if (this.outPaths[idx] == null) continue;
                    this.commitOneOutPath(idx, fs, commitPaths);
                    continue;
                }
                catch (IOException e) {
                    throw new HiveException("Unable to commit output from: " + String.valueOf(this.outPaths[idx]) + " to: " + String.valueOf(this.finalPaths[idx]), (Throwable)e);
                }
            }
            if (this.isDirectInsert && AcidUtils.Operation.UPDATE.equals(((FileSinkDesc)FileSinkOperator.this.conf).getAcidOperation())) {
                commitPaths.addAll(deleteDeltas);
            }
        }

        private void commitOneOutPath(int idx, FileSystem fs, List<Path> commitPaths) throws IOException, HiveException {
            if ((FileSinkOperator.this.bDynParts || FileSinkOperator.this.isSkewedStoredAsSubDirectories) && !fs.exists(this.finalPaths[idx].getParent())) {
                if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                    Utilities.FILE_OP_LOGGER.trace("commit making path for dyn/skew: " + String.valueOf(this.finalPaths[idx].getParent()));
                }
                FileUtils.mkdir((FileSystem)fs, (Path)this.finalPaths[idx].getParent(), (Configuration)FileSinkOperator.this.hconf);
            }
            if (this.outPaths[idx] != null && fs.exists(this.outPaths[idx])) {
                if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                    Utilities.FILE_OP_LOGGER.trace("committing " + String.valueOf(this.outPaths[idx]) + " to " + String.valueOf(this.finalPaths[idx]) + " (mm table =" + this.isMmTable + ", direct insert = " + this.isDirectInsert + ")");
                }
                if (this.isMmTable) {
                    assert (this.outPaths[idx].equals((Object)this.finalPaths[idx]));
                    commitPaths.add(this.outPaths[idx]);
                } else if (this.isDirectInsert && this.outPathsCommitted[idx] != null) {
                    if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                        Utilities.FILE_OP_LOGGER.trace("committing " + String.valueOf(this.outPathsCommitted[idx]) + " (direct insert = " + this.isDirectInsert + ")");
                    }
                    commitPaths.add(this.outPathsCommitted[idx]);
                } else if (!this.isDirectInsert && !fs.rename(this.outPaths[idx], this.finalPaths[idx])) {
                    FileStatus fileStatus = FileUtils.getFileStatusOrNull((FileSystem)fs, (Path)this.finalPaths[idx]);
                    if (fileStatus != null) {
                        LOG.warn("Target path " + String.valueOf(this.finalPaths[idx]) + " with a size " + fileStatus.getLen() + " exists. Trying to delete it.");
                        if (!fs.delete(this.finalPaths[idx], true)) {
                            throw new HiveException("Unable to delete existing target output: " + String.valueOf(this.finalPaths[idx]));
                        }
                    }
                    if (!fs.rename(this.outPaths[idx], this.finalPaths[idx])) {
                        throw new HiveException("Unable to rename output from: " + String.valueOf(this.outPaths[idx]) + " to: " + String.valueOf(this.finalPaths[idx]));
                    }
                }
            }
            FileSinkOperator.this.updateProgress();
        }

        public void abortWritersAndUpdaters(FileSystem fs, boolean abort, boolean delete) throws HiveException {
            int idx;
            for (idx = 0; idx < this.outWriters.length; ++idx) {
                if (this.outWriters[idx] == null) continue;
                try {
                    LOG.debug("Aborted: closing: " + this.outWriters[idx].toString());
                    this.outWriters[idx].close(abort);
                    if (delete) {
                        fs.delete(this.outPaths[idx], true);
                    }
                    FileSinkOperator.this.updateProgress();
                    continue;
                }
                catch (IOException e) {
                    throw new HiveException((Throwable)e);
                }
            }
            for (idx = 0; idx < this.updaters.length; ++idx) {
                if (this.updaters[idx] == null) continue;
                try {
                    LOG.debug("Aborted: closing: " + this.updaters[idx].toString());
                    this.updaters[idx].close(abort);
                    if (delete) {
                        fs.delete(this.outPaths[idx], true);
                    }
                    FileSinkOperator.this.updateProgress();
                    continue;
                }
                catch (IOException e) {
                    throw new HiveException((Throwable)e);
                }
            }
        }

        public void initializeBucketPaths(int filesIdx, String taskId, boolean isNativeTable, boolean isSkewedStoredAsSubDirectories) {
            if (isNativeTable) {
                String taskWithExt;
                String extension = Utilities.getFileExtension(FileSinkOperator.this.jc, FileSinkOperator.this.isCompressed, FileSinkOperator.this.hiveOutputFormat);
                String string = taskWithExt = extension == null ? taskId : taskId + extension;
                if (!this.isMmTable && !this.isDirectInsert) {
                    this.finalPaths[filesIdx] = !FileSinkOperator.this.bDynParts && !isSkewedStoredAsSubDirectories ? new Path(FileSinkOperator.this.parent, taskWithExt) : new Path(this.buildTmpPath(), taskWithExt);
                    this.outPaths[filesIdx] = new Path(this.buildTaskOutputTempPath(), Utilities.toTempPath(taskId));
                } else {
                    Object taskIdPath = taskId;
                    if (((FileSinkDesc)FileSinkOperator.this.conf).isMerge()) {
                        taskIdPath = (String)taskIdPath + ".merged";
                    }
                    if (extension != null) {
                        taskIdPath = (String)taskIdPath + extension;
                    }
                    Path finalPath = this.isDirectInsert ? this.buildTmpPath() : new Path(this.buildTmpPath(), (String)taskIdPath);
                    try {
                        FileSystem fpfs = finalPath.getFileSystem(FileSinkOperator.this.hconf);
                        if (!this.isDirectInsert && fpfs.exists(finalPath)) {
                            throw new RuntimeException(String.valueOf(finalPath) + " already exists");
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    this.finalPaths[filesIdx] = finalPath;
                    this.outPaths[filesIdx] = finalPath;
                }
                LOG.info("Final Path: FS " + String.valueOf(this.finalPaths[filesIdx]));
                if (!this.isMmTable && !this.isDirectInsert) {
                    LOG.info("Writing to temp file: FS " + String.valueOf(this.outPaths[filesIdx]));
                }
            } else {
                this.finalPaths[filesIdx] = this.outPaths[filesIdx] = FileSinkOperator.this.specPath;
            }
        }

        public Path buildTmpPath() {
            Object pathStr = this.tmpPathRoot.toString();
            if (this.subdirBeforeTxn != null) {
                pathStr = (String)pathStr + "/" + this.subdirBeforeTxn;
            }
            if (this.subdirForTxn != null) {
                pathStr = (String)pathStr + "/" + this.subdirForTxn;
            }
            if (this.subdirAfterTxn != null) {
                pathStr = (String)pathStr + "/" + this.subdirAfterTxn;
            }
            return new Path((String)pathStr);
        }

        public Path buildTaskOutputTempPath() {
            if (this.taskOutputTempPathRoot == null) {
                return null;
            }
            assert (this.subdirForTxn == null);
            Object pathStr = this.taskOutputTempPathRoot.toString();
            if (this.subdirBeforeTxn != null) {
                pathStr = (String)pathStr + "/" + this.subdirBeforeTxn;
            }
            if (this.subdirAfterTxn != null) {
                pathStr = (String)pathStr + "/" + this.subdirAfterTxn;
            }
            return new Path((String)pathStr);
        }

        public void addToStat(String statType, long amount) {
            this.stat.addToStat(statType, amount);
        }

        public Collection<String> getStoredStats() {
            return this.stat.getStoredStats();
        }

        public int createDynamicBucket(int bucketNum) {
            int writerOffset = bucketNum;
            if (this.updaters.length <= writerOffset) {
                this.updaters = Arrays.copyOf(this.updaters, writerOffset + 1);
                this.outPaths = Arrays.copyOf(this.outPaths, writerOffset + 1);
                this.finalPaths = Arrays.copyOf(this.finalPaths, writerOffset + 1);
            }
            if (this.finalPaths[writerOffset] == null) {
                if (((FileSinkDesc)FileSinkOperator.this.conf).isDirectInsert()) {
                    if (this.outPathsCommitted.length <= writerOffset) {
                        this.outPathsCommitted = Arrays.copyOf(this.outPathsCommitted, writerOffset + 1);
                    }
                    this.finalPaths[writerOffset] = this.buildTmpPath();
                    this.outPaths[writerOffset] = this.buildTmpPath();
                } else {
                    String bucketName = Utilities.replaceTaskIdFromFilename(Utilities.getTaskId(FileSinkOperator.this.hconf), bucketNum);
                    this.finalPaths[writerOffset] = new Path(FileSinkOperator.this.bDynParts ? this.buildTmpPath() : FileSinkOperator.this.parent, bucketName);
                    this.outPaths[writerOffset] = new Path(this.buildTaskOutputTempPath(), bucketName);
                }
            }
            return writerOffset;
        }
    }

    public static enum Counter {
        RECORDS_OUT;

    }

    public static interface RecordWriter {
        public void write(Writable var1) throws IOException;

        public void close(boolean var1) throws IOException;
    }
}

