/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.trigger;

import org.apache.hadoop.hive.metastore.api.WMTrigger;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.WMUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.wm.ExecutionTrigger;

public final class TriggerUtils {
    private TriggerUtils() {
        throw new UnsupportedOperationException("TriggerUtils should not be instantiated");
    }

    public static String buildTriggerExpression(ASTNode node) throws SemanticException {
        if (node.getType() != 1294 || node.getChildCount() == 0) {
            throw new SemanticException("Invalid trigger expression.");
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < node.getChildCount(); ++i) {
            builder.append(node.getChild(i).getText());
            builder.append(' ');
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public static String buildTriggerActionExpression(ASTNode node) throws SemanticException {
        switch (node.getType()) {
            case 196: {
                return "KILL";
            }
            case 229: {
                if (node.getChildCount() != 1) {
                    throw new SemanticException("Invalid move to clause in trigger action.");
                }
                String poolPath = WMUtils.poolPath(node.getChild(0));
                return "MOVE TO " + poolPath;
            }
        }
        throw new SemanticException("Unknown token in action clause: " + node.getType());
    }

    public static void validateTrigger(WMTrigger trigger) throws HiveException {
        try {
            ExecutionTrigger.fromWMTrigger(trigger);
        }
        catch (IllegalArgumentException e) {
            throw new HiveException((Throwable)e);
        }
    }
}

