/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.create;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.view.create.AbstractCreateViewAnalyzer;
import org.apache.hadoop.hive.ql.ddl.view.create.CreateViewDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={962})
public class CreateViewAnalyzer
extends AbstractCreateViewAnalyzer {
    public CreateViewAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        List<String> partitionColumnNames;
        TableName viewName = CreateViewAnalyzer.getQualifiedTableName((ASTNode)root.getChild(0));
        String fqViewName = viewName.getNotEmptyDbTable();
        this.LOG.info("Creating view " + fqViewName + " position=" + root.getCharPositionInLine());
        HashMap<Integer, ASTNode> children = new HashMap<Integer, ASTNode>();
        for (int i = 1; i < root.getChildCount(); ++i) {
            ASTNode child = (ASTNode)root.getChild(i);
            children.put(child.getToken().getType(), child);
        }
        List<FieldSchema> imposedSchema = children.containsKey(1253) ? this.getColumns((ASTNode)children.remove(1253)) : null;
        boolean ifNotExists = children.remove(1055) != null;
        boolean orReplace = children.remove(1131) != null;
        String comment = children.containsKey(1258) ? CreateViewAnalyzer.unescapeSQLString(((ASTNode)children.remove(1258)).getChild(0).getText()) : null;
        ASTNode select = (ASTNode)children.remove(1161);
        Map<String, String> properties = children.containsKey(1264) ? CreateViewAnalyzer.getProps((ASTNode)((ASTNode)children.remove(1264)).getChild(0)) : null;
        List<String> list = partitionColumnNames = children.containsKey(1321) ? CreateViewAnalyzer.getColumnNames((ASTNode)((ASTNode)children.remove(1321)).getChild(0)) : null;
        assert (children.isEmpty());
        if (ifNotExists && orReplace) {
            throw new SemanticException("Can't combine IF NOT EXISTS and OR REPLACE.");
        }
        String originalText = this.ctx.getTokenRewriteStream().toString(select.getTokenStartIndex(), select.getTokenStopIndex());
        SemanticAnalyzer analyzer = this.analyzeQuery(select, fqViewName);
        this.schema = new ArrayList<FieldSchema>(analyzer.getResultSchema());
        ParseUtils.validateColumnNameUniqueness(analyzer.getOriginalResultSchema() == null ? this.schema : analyzer.getOriginalResultSchema());
        String expandedText = this.getExpandedText(imposedSchema, select, viewName);
        List<FieldSchema> partitionColumns = this.getPartitionColumns(partitionColumnNames);
        this.setColumnAccessInfo(analyzer.getColumnAccessInfo());
        CreateViewDesc desc = new CreateViewDesc(fqViewName, this.schema, comment, properties, partitionColumnNames, ifNotExists, orReplace, originalText, expandedText, partitionColumns);
        this.validateCreateView(desc, analyzer);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        DDLUtils.addDbAndTableToOutputs(this.getDatabase(viewName.getDb()), viewName, TableType.VIRTUAL_VIEW, false, properties, this.outputs);
    }

    private String getExpandedText(List<FieldSchema> imposedSchema, ASTNode select, TableName viewName) throws SemanticException {
        if (imposedSchema != null && imposedSchema.size() != this.schema.size()) {
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(select, ErrorMsg.VIEW_COL_MISMATCH.getMsg()));
        }
        String expandedText = this.ctx.getTokenRewriteStream().toString(select.getTokenStartIndex(), select.getTokenStopIndex());
        String trimmedExpandedText = expandedText.trim();
        while (trimmedExpandedText.startsWith("(") && trimmedExpandedText.endsWith(")")) {
            expandedText = trimmedExpandedText = trimmedExpandedText.substring(1, trimmedExpandedText.length() - 1);
            trimmedExpandedText = trimmedExpandedText.trim();
        }
        if (imposedSchema != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ");
            for (int i = 0; i < this.schema.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                FieldSchema fieldSchema = new FieldSchema((FieldSchema)this.schema.get(i));
                this.schema.set(i, fieldSchema);
                sb.append(HiveUtils.unparseIdentifier(fieldSchema.getName(), (Configuration)this.conf));
                sb.append(" AS ");
                String imposedName = imposedSchema.get(i).getName();
                sb.append(HiveUtils.unparseIdentifier(imposedName, (Configuration)this.conf));
                fieldSchema.setName(imposedName);
                fieldSchema.setComment(imposedSchema.get(i).getComment());
            }
            sb.append(" FROM (");
            sb.append(expandedText);
            sb.append(") ");
            sb.append(HiveUtils.unparseIdentifier(viewName.getTable(), (Configuration)this.conf));
            expandedText = sb.toString();
        }
        return expandedText;
    }

    private List<FieldSchema> getPartitionColumns(List<String> partitionColumnNames) throws SemanticException {
        if (partitionColumnNames == null) {
            return null;
        }
        if (partitionColumnNames.size() > this.schema.size()) {
            throw new SemanticException(ErrorMsg.VIEW_PARTITION_MISMATCH.getMsg());
        }
        List partitionColumns = this.schema.subList(this.schema.size() - partitionColumnNames.size(), this.schema.size());
        Iterator<String> columnNameIterator = partitionColumnNames.iterator();
        Iterator schemaIterator = partitionColumns.iterator();
        while (columnNameIterator.hasNext()) {
            String columnName = columnNameIterator.next();
            FieldSchema fieldSchema = (FieldSchema)schemaIterator.next();
            if (fieldSchema.getName().equals(columnName)) continue;
            throw new SemanticException(ErrorMsg.VIEW_PARTITION_MISMATCH.getMsg());
        }
        if (partitionColumnNames.size() == this.schema.size()) {
            throw new SemanticException(ErrorMsg.VIEW_PARTITION_TOTAL.getMsg());
        }
        ArrayList<FieldSchema> partitionColumnsCopy = new ArrayList<FieldSchema>(partitionColumns);
        partitionColumns.clear();
        return partitionColumnsCopy;
    }

    private void validateCreateView(CreateViewDesc desc, SemanticAnalyzer analyzer) throws SemanticException {
        try {
            CreateViewAnalyzer.validateTablesUsed(analyzer);
            Table oldView = this.getTable(desc.getViewName(), false);
            if (desc.isReplace() && oldView != null) {
                if (oldView.getTableType().equals((Object)TableType.MATERIALIZED_VIEW)) {
                    throw new SemanticException(ErrorMsg.REPLACE_MATERIALIZED_WITH_VIEW, new String[]{oldView.getTableName()});
                }
                if (!oldView.getTableType().equals((Object)TableType.VIRTUAL_VIEW) && !oldView.getTableType().equals((Object)TableType.MATERIALIZED_VIEW)) {
                    String tableNotViewErrorMsg = "The following is an existing table, not a view: " + desc.getViewName();
                    throw new SemanticException(ErrorMsg.EXISTING_TABLE_IS_NOT_VIEW.getMsg(tableNotViewErrorMsg));
                }
                this.validateReplaceWithPartitions(desc.getViewName(), oldView, desc.getPartitionColumns());
            }
        }
        catch (HiveException e) {
            throw new SemanticException(e.getMessage(), (Throwable)e);
        }
    }
}

