/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.snapshotref;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.snapshotref.AlterTableSnapshotRefDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AlterTableSnapshotRefSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.jetbrains.annotations.NotNull;

@DDLSemanticAnalyzerFactory.DDLType(types={894})
public class AlterTableReplaceSnapshotRefAnalyzer
extends AbstractAlterTableAnalyzer {
    protected AlterTableType alterTableType = AlterTableType.REPLACE_SNAPSHOTREF;

    public AlterTableReplaceSnapshotRefAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        AlterTableSnapshotRefSpec.ReplaceSnapshotrefSpec replaceSnapshotrefSpec;
        Table table = this.getTable(tableName);
        DDLUtils.validateTableIsIceberg(table);
        this.inputs.add(new ReadEntity(table));
        this.validateAlterTableType(table, this.alterTableType, false);
        boolean isReplaceBranch = command.getChild(0).getType() == 53;
        String sourceRef = command.getChild(1).getText();
        if (isReplaceBranch) {
            replaceSnapshotrefSpec = this.getReplaceBranchSpec(command, sourceRef);
            replaceSnapshotrefSpec.setIsReplaceBranch();
        } else {
            replaceSnapshotrefSpec = this.getReplaceTagSpec(command, sourceRef);
        }
        AlterTableSnapshotRefSpec<AlterTableSnapshotRefSpec.ReplaceSnapshotrefSpec> alterTableSnapshotRefSpec = new AlterTableSnapshotRefSpec<AlterTableSnapshotRefSpec.ReplaceSnapshotrefSpec>(this.alterTableType, replaceSnapshotrefSpec);
        AlterTableSnapshotRefDesc alterTableDesc = new AlterTableSnapshotRefDesc(this.alterTableType, tableName, alterTableSnapshotRefSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTableDesc)));
    }

    @NotNull
    private AlterTableSnapshotRefSpec.ReplaceSnapshotrefSpec getReplaceTagSpec(ASTNode command, String sourceBranch) throws SemanticException {
        long targetSnapshot = Long.parseLong(command.getChild(2).getText());
        AlterTableSnapshotRefSpec.ReplaceSnapshotrefSpec replaceSnapshotrefSpec = new AlterTableSnapshotRefSpec.ReplaceSnapshotrefSpec(sourceBranch, targetSnapshot);
        for (int childNodeNum = 3; childNodeNum < command.getChildCount(); ++childNodeNum) {
            AlterTableReplaceSnapshotRefAnalyzer.extractOptionalArguments(command, replaceSnapshotrefSpec, childNodeNum, this.alterTableType);
        }
        return replaceSnapshotrefSpec;
    }

    @NotNull
    private AlterTableSnapshotRefSpec.ReplaceSnapshotrefSpec getReplaceBranchSpec(ASTNode command, String sourceBranch) throws SemanticException {
        int childNodeNum;
        AlterTableSnapshotRefSpec.ReplaceSnapshotrefSpec replaceSnapshotrefSpec;
        if (command.getChild(2).getType() == 349) {
            long targetSnapshot = Long.parseLong(command.getChild(3).getText());
            replaceSnapshotrefSpec = new AlterTableSnapshotRefSpec.ReplaceSnapshotrefSpec(sourceBranch, targetSnapshot);
            childNodeNum = 4;
        } else {
            String targetBranch = command.getChild(2).getText();
            replaceSnapshotrefSpec = new AlterTableSnapshotRefSpec.ReplaceSnapshotrefSpec(sourceBranch, targetBranch);
            childNodeNum = 3;
        }
        while (childNodeNum < command.getChildCount()) {
            AlterTableReplaceSnapshotRefAnalyzer.extractOptionalArguments(command, replaceSnapshotrefSpec, childNodeNum, this.alterTableType);
            ++childNodeNum;
        }
        return replaceSnapshotrefSpec;
    }

    public static void extractOptionalArguments(ASTNode command, AlterTableSnapshotRefSpec.ReplaceSnapshotrefSpec replaceSnapshotrefSpec, int childNodeNum, AlterTableType alterTableType) throws SemanticException {
        ASTNode childNode = (ASTNode)command.getChild(childNodeNum);
        switch (childNode.getToken().getType()) {
            case 1184: {
                String maxRefAge = childNode.getChild(0).getText();
                String timeUnitOfBranchRetain = childNode.getChild(1).getText();
                long maxRefAgeMs = TimeUnit.valueOf(timeUnitOfBranchRetain.toUpperCase(Locale.ENGLISH)).toMillis(Long.parseLong(maxRefAge));
                replaceSnapshotrefSpec.setMaxRefAgeMs(maxRefAgeMs);
                break;
            }
            case 1329: {
                int minSnapshotsToKeep = Integer.parseInt(childNode.getChild(0).getText());
                replaceSnapshotrefSpec.setMinSnapshotsToKeep(minSnapshotsToKeep);
                if (childNode.getChildren().size() <= 1) break;
                String maxSnapshotAge = childNode.getChild(1).getText();
                String timeUnitOfSnapshotsRetention = childNode.getChild(2).getText();
                long maxSnapshotAgeMs = TimeUnit.valueOf(timeUnitOfSnapshotsRetention.toUpperCase(Locale.ENGLISH)).toMillis(Long.parseLong(maxSnapshotAge));
                replaceSnapshotrefSpec.setMaxSnapshotAgeMs(maxSnapshotAgeMs);
                break;
            }
            default: {
                throw new SemanticException("Unrecognized token in ALTER " + alterTableType.getName() + " statement");
            }
        }
    }
}

