/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.info.desc;

import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import java.io.DataOutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.StatObjectConverter;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.table.info.desc.DescTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.info.desc.formatter.DescTableFormatter;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.PartitionIterable;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.TableConstraintsInfo;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.Partish;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class DescTableOperation
extends DDLOperation<DescTableDesc> {
    public DescTableOperation(DDLOperationContext context, DescTableDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws Exception {
        Table table = this.getTable();
        Partition part = this.getPartition(table);
        String dbTableName = ((DescTableDesc)this.desc).getDbTableName();
        try (DataOutputStream outStream = ShowUtils.getOutputStream(new Path(((DescTableDesc)this.desc).getResFile()), this.context);){
            LOG.debug("DDLTask: got data for {}", (Object)dbTableName);
            ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
            ArrayList<ColumnStatisticsObj> colStats = new ArrayList<ColumnStatisticsObj>();
            Deserializer deserializer = this.getDeserializer(table);
            if (((DescTableDesc)this.desc).getColumnPath() == null) {
                this.getColumnsNoColumnPath(table, part, cols);
            } else if (((DescTableDesc)this.desc).isFormatted()) {
                this.getColumnDataColPathSpecified(table, part, cols, colStats, deserializer);
            } else {
                cols.addAll(Hive.getFieldsFromDeserializer(((DescTableDesc)this.desc).getColumnPath(), deserializer, (Configuration)this.context.getConf()));
            }
            DescTableOperation.fixDecimalColumnTypeName(cols);
            this.setConstraintsAndStorageHandlerInfo(table);
            this.handleMaterializedView(table);
            boolean isOutputPadded = !SessionState.get().isHiveServerQuery();
            DescTableFormatter formatter = DescTableFormatter.getFormatter(this.context.getConf());
            formatter.describeTable(this.context.getConf(), outStream, ((DescTableDesc)this.desc).getColumnPath(), dbTableName, table, part, cols, ((DescTableDesc)this.desc).isFormatted(), ((DescTableDesc)this.desc).isExtended(), isOutputPadded, colStats);
            LOG.debug("DDLTask: written data for {}", (Object)dbTableName);
        }
        catch (SQLException e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, new String[]{dbTableName});
        }
        return 0;
    }

    private Table getTable() throws HiveException {
        Table table = this.context.getDb().getTable(((DescTableDesc)this.desc).getTableName().getDb(), ((DescTableDesc)this.desc).getTableName().getTable(), ((DescTableDesc)this.desc).getTableName().getTableMetaRef(), false, false, false);
        if (table == null) {
            throw new HiveException(ErrorMsg.INVALID_TABLE, new String[]{((DescTableDesc)this.desc).getDbTableName()});
        }
        return table;
    }

    private Partition getPartition(Table table) throws HiveException {
        Partition part = null;
        if (((DescTableDesc)this.desc).getPartitionSpec() != null && (part = this.context.getDb().getPartition(table, ((DescTableDesc)this.desc).getPartitionSpec(), false)) == null) {
            throw new HiveException(ErrorMsg.INVALID_PARTITION, new String[]{StringUtils.join(((DescTableDesc)this.desc).getPartitionSpec().keySet(), (char)','), ((DescTableDesc)this.desc).getDbTableName()});
        }
        return part;
    }

    private Deserializer getDeserializer(Table table) throws SQLException {
        return table.getDeserializer(true);
    }

    private void getColumnsNoColumnPath(Table table, Partition partition, List<FieldSchema> cols) throws HiveException {
        cols.addAll(partition == null || table.getTableType() == TableType.VIRTUAL_VIEW ? table.getCols() : partition.getCols());
        if (!((DescTableDesc)this.desc).isFormatted()) {
            cols.addAll(table.getPartCols());
        }
        if (((DescTableDesc)this.desc).isExtended() || ((DescTableDesc)this.desc).isFormatted()) {
            boolean disablePartitionStats;
            boolean bl = disablePartitionStats = !StatsUtils.checkCanProvidePartitionStats(table) || HiveConf.getBoolVar((Configuration)this.context.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DESCRIBE_PARTITIONED_TABLE_IGNORE_STATS);
            if (table.isPartitioned() && partition == null && !disablePartitionStats) {
                Map<Object, Object> tblProps = table.getParameters() == null ? new HashMap() : table.getParameters();
                HashMap<String, Long> valueMap = new HashMap<String, Long>();
                HashMap<String, Boolean> stateMap = new HashMap<String, Boolean>();
                for (String stat : StatsSetupConst.SUPPORTED_STATS) {
                    valueMap.put(stat, 0L);
                    stateMap.put(stat, true);
                }
                int numParts = 0;
                if (table.isNonNative()) {
                    HiveStorageHandler sh = table.getStorageHandler();
                    sh.getBasicStatistics(Partish.buildFor(table)).forEach((k, v) -> valueMap.put((String)k, Longs.tryParse((String)v)));
                    numParts = sh.getPartitionNames(table).size();
                } else {
                    PartitionIterable partitions = new PartitionIterable(this.context.getDb(), table, null, MetastoreConf.getIntVar((Configuration)this.context.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX));
                    for (Partition p : partitions) {
                        Map<String, String> partitionProps = p.getParameters();
                        Boolean state = StatsSetupConst.areBasicStatsUptoDate(partitionProps);
                        Iterator iterator = StatsSetupConst.SUPPORTED_STATS.iterator();
                        while (iterator.hasNext()) {
                            String stat;
                            stateMap.put(stat, (Boolean)stateMap.get(stat = (String)iterator.next()) != false && state != false);
                            if (partitionProps == null || partitionProps.get(stat) == null) continue;
                            valueMap.put(stat, (Long)valueMap.get(stat) + Long.parseLong(partitionProps.get(stat)));
                        }
                        ++numParts;
                    }
                }
                tblProps.put("numPartitions", Integer.toString(numParts));
                for (String stat : StatsSetupConst.SUPPORTED_STATS) {
                    StatsSetupConst.setBasicStatsState(tblProps, (String)Boolean.toString((Boolean)stateMap.get(stat)));
                    tblProps.put(stat, ((Long)valueMap.get(stat)).toString());
                }
                table.setParameters(tblProps);
            }
        }
    }

    private void getColumnDataColPathSpecified(Table table, Partition part, List<FieldSchema> cols, List<ColumnStatisticsObj> colStats, Deserializer deserializer) throws HiveException, MetaException {
        String colName = ((DescTableDesc)this.desc).getColumnPath().split("\\.")[2];
        ArrayList colNames = Lists.newArrayList((Object[])new String[]{colName.toLowerCase()});
        if (part == null) {
            if (table.isPartitioned() && StatsUtils.checkCanProvidePartitionStats(table)) {
                HashMap<String, String> tableProps;
                Map<Object, Object> map = tableProps = table.getParameters() == null ? new HashMap() : table.getParameters();
                if (table.isPartitionKey((String)colNames.get(0))) {
                    this.getColumnDataForPartitionKeyColumn(table, cols, colStats, colNames, tableProps);
                } else {
                    this.getColumnsForNotPartitionKeyColumn(table, cols, colStats, deserializer, colNames, tableProps);
                }
                table.setParameters(tableProps);
            } else {
                cols.addAll(Hive.getFieldsFromDeserializer(((DescTableDesc)this.desc).getColumnPath(), deserializer, (Configuration)this.context.getConf()));
                colStats.addAll(this.context.getDb().getTableColumnStatistics(table, colNames, false));
            }
        } else {
            ArrayList<String> partitions = new ArrayList<String>();
            String partName = part.getName();
            partitions.add(partName);
            cols.addAll(Hive.getFieldsFromDeserializer(((DescTableDesc)this.desc).getColumnPath(), deserializer, (Configuration)this.context.getConf()));
            Map<String, List<ColumnStatisticsObj>> partitionColumnStatistics = this.context.getDb().getPartitionColumnStatistics(table.getDbName(), table.getTableName(), partitions, colNames, false);
            List<ColumnStatisticsObj> partitionColStat = partitionColumnStatistics.get(partName);
            if (partitionColStat != null) {
                colStats.addAll(partitionColStat);
            }
        }
    }

    private void getColumnDataForPartitionKeyColumn(Table table, List<FieldSchema> cols, List<ColumnStatisticsObj> colStats, List<String> colNames, Map<String, String> tableProps) throws HiveException, MetaException {
        FieldSchema partCol = table.getPartColByName(colNames.get(0));
        cols.add(partCol);
        PartitionIterable parts = new PartitionIterable(this.context.getDb(), table, null, MetastoreConf.getIntVar((Configuration)this.context.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX));
        ColumnInfo ci = new ColumnInfo(partCol.getName(), TypeInfoUtils.getTypeInfoFromTypeString((String)partCol.getType()), null, false);
        ColStatistics cs = StatsUtils.getColStatsForPartCol(ci, parts, this.context.getConf());
        ColumnStatisticsData data = new ColumnStatisticsData();
        ColStatistics.Range r = cs.getRange();
        StatObjectConverter.fillColumnStatisticsData((String)partCol.getType(), (ColumnStatisticsData)data, (Object)(r == null ? (Number)null : (Number)r.minValue), (Object)(r == null ? (Number)null : (Number)r.maxValue), (Object)(r == null ? (Number)null : (Number)r.minValue), (Object)(r == null ? (Number)null : (Number)r.maxValue), (Object)(r == null ? null : r.minValue.toString()), (Object)(r == null ? null : r.maxValue.toString()), (Object)cs.getNumNulls(), (Object)cs.getCountDistint(), null, null, (Object)cs.getAvgColLen(), (Object)cs.getAvgColLen(), (Object)cs.getNumTrues(), (Object)cs.getNumFalses());
        ColumnStatisticsObj cso = new ColumnStatisticsObj(partCol.getName(), partCol.getType(), data);
        colStats.add(cso);
        StatsSetupConst.setColumnStatsState(tableProps, colNames);
    }

    private void getColumnsForNotPartitionKeyColumn(Table table, List<FieldSchema> cols, List<ColumnStatisticsObj> colStats, Deserializer deserializer, List<String> colNames, Map<String, String> tableProps) throws HiveException {
        cols.addAll(Hive.getFieldsFromDeserializer(((DescTableDesc)this.desc).getColumnPath(), deserializer, (Configuration)this.context.getConf()));
        List<String> parts = this.context.getDb().getPartitionNames(table, (short)-1);
        AggrStats aggrStats = this.context.getDb().getAggrColStatsFor(table, colNames, parts, false);
        colStats.addAll(aggrStats.getColStats());
        if ((long)parts.size() == aggrStats.getPartsFound()) {
            StatsSetupConst.setColumnStatsState(tableProps, colNames);
        } else {
            StatsSetupConst.removeColumnStatsState(tableProps, colNames);
        }
    }

    private static void fixDecimalColumnTypeName(List<FieldSchema> cols) {
        for (FieldSchema col : cols) {
            if (!"decimal".equals(col.getType())) continue;
            col.setType(DecimalTypeInfo.getQualifiedName((int)10, (int)0));
        }
    }

    private void setConstraintsAndStorageHandlerInfo(Table table) throws HiveException {
        if (((DescTableDesc)this.desc).isExtended() || ((DescTableDesc)this.desc).isFormatted()) {
            TableConstraintsInfo tableConstraintsInfo = this.context.getDb().getTableConstraints(table.getDbName(), table.getTableName(), false, false);
            table.setTableConstraintsInfo(tableConstraintsInfo);
            table.setStorageHandlerInfo(this.context.getDb().getStorageHandlerInfo(table));
        }
    }

    private void handleMaterializedView(Table table) throws HiveException {
        if (table.isMaterializedView()) {
            table.setOutdatedForRewriting(this.context.getDb().isOutdatedMaterializedView(table, table.getMVMetadata().getSourceTableNames(), false, () -> this.context.getConf().get("hive.txn.valid.txns"), SessionState.get().getTxnMgr()));
        }
    }
}

