/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.privilege.revoke;

import java.util.List;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.privilege.PrivilegeUtils;
import org.apache.hadoop.hive.ql.ddl.privilege.revoke.RevokeDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.security.authorization.AuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;

public class RevokeOperation
extends DDLOperation<RevokeDesc> {
    public RevokeOperation(DDLOperationContext context, RevokeDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        HiveAuthorizer authorizer = PrivilegeUtils.getSessionAuthorizer(this.context.getConf());
        List<HivePrincipal> hivePrincipals = AuthorizationUtils.getHivePrincipals(((RevokeDesc)this.desc).getPrincipals(), PrivilegeUtils.getAuthorizationTranslator(authorizer));
        List<HivePrivilege> hivePrivileges = AuthorizationUtils.getHivePrivileges(((RevokeDesc)this.desc).getPrivileges(), PrivilegeUtils.getAuthorizationTranslator(authorizer));
        HivePrivilegeObject hivePrivilegeObject = PrivilegeUtils.getAuthorizationTranslator(authorizer).getHivePrivilegeObject(((RevokeDesc)this.desc).getPrivilegeSubject());
        HivePrincipal grantorPrincipal = new HivePrincipal(null, null);
        authorizer.revokePrivileges(hivePrincipals, hivePrivileges, hivePrivilegeObject, grantorPrincipal, ((RevokeDesc)this.desc).isGrantOption());
        return 0;
    }
}

