/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.show;

import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.database.show.ShowDatabasesDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1210})
public class ShowDatabasesAnalyzer
extends BaseSemanticAnalyzer {
    public ShowDatabasesAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (root.getChildCount() > 1) {
            throw new SemanticException("Unexpected Tokens at SHOW DATABASES");
        }
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        String databasePattern = root.getChildCount() == 1 ? ShowDatabasesAnalyzer.unescapeSQLString(root.getChild(0).getText()) : null;
        ShowDatabasesDesc desc = new ShowDatabasesDesc(this.ctx.getResFile(), databasePattern);
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        task.setFetchSource(true);
        this.setFetchTask(this.createFetchTask("database_name#string"));
    }
}

