/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.hll;

import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;

class ObjectInspectorValidator {
    ObjectInspectorValidator() {
    }

    static void validateCategoryPrimitive(ObjectInspector inspector, int index) throws UDFArgumentTypeException {
        if (inspector.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(index, "Primitive parameter expected, but " + inspector.getCategory().name() + " was recieved as parameter " + (index + 1));
        }
    }

    static void validateGivenPrimitiveCategory(ObjectInspector inspector, int index, PrimitiveObjectInspector.PrimitiveCategory category) throws UDFArgumentTypeException {
        ObjectInspectorValidator.validateCategoryPrimitive(inspector, index);
        PrimitiveObjectInspector primitiveInspector = (PrimitiveObjectInspector)inspector;
        if (primitiveInspector.getPrimitiveCategory() != category) {
            throw new UDFArgumentTypeException(index, category.name() + " value expected as parameter " + (index + 1) + " but " + primitiveInspector.getPrimitiveCategory().name() + " was received");
        }
    }

    static void validateIntegralParameter(ObjectInspector inspector, int index) throws UDFArgumentTypeException {
        ObjectInspectorValidator.validateCategoryPrimitive(inspector, index);
        PrimitiveObjectInspector primitiveInspector = (PrimitiveObjectInspector)inspector;
        switch (primitiveInspector.getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                break;
            }
            default: {
                throw new UDFArgumentTypeException(index, "Only integral type parameters are expected but " + primitiveInspector.getPrimitiveCategory().name() + " was passed as parameter " + (index + 1));
            }
        }
    }
}

