/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal;

import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.exporter.internal.IncubatingExporterBuilderUtil;
import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporter;
import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporterBuilder;
import io.opentelemetry.exporter.otlp.internal.OtlpDeclarativeConfigUtil;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ComponentProvider;
import io.opentelemetry.sdk.metrics.export.MetricExporter;

public class OtlpMetricExporterComponentProvider
implements ComponentProvider<MetricExporter> {
    public Class<MetricExporter> getType() {
        return MetricExporter.class;
    }

    public String getName() {
        return "otlp";
    }

    public MetricExporter create(DeclarativeConfigProperties config) {
        String protocol = OtlpDeclarativeConfigUtil.getStructuredConfigOtlpProtocol(config);
        if (protocol.equals("http/protobuf")) {
            OtlpHttpMetricExporterBuilder builder = this.httpBuilder();
            OtlpDeclarativeConfigUtil.configureOtlpExporterBuilder("metrics", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            IncubatingExporterBuilderUtil.configureOtlpAggregationTemporality((DeclarativeConfigProperties)config, builder::setAggregationTemporalitySelector);
            IncubatingExporterBuilderUtil.configureOtlpHistogramDefaultAggregation((DeclarativeConfigProperties)config, builder::setDefaultAggregationSelector);
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            OtlpGrpcMetricExporterBuilder builder = this.grpcBuilder();
            OtlpDeclarativeConfigUtil.configureOtlpExporterBuilder("metrics", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            IncubatingExporterBuilderUtil.configureOtlpAggregationTemporality((DeclarativeConfigProperties)config, builder::setAggregationTemporalitySelector);
            IncubatingExporterBuilderUtil.configureOtlpHistogramDefaultAggregation((DeclarativeConfigProperties)config, builder::setDefaultAggregationSelector);
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP metrics protocol: " + protocol);
    }

    OtlpHttpMetricExporterBuilder httpBuilder() {
        return OtlpHttpMetricExporter.builder();
    }

    OtlpGrpcMetricExporterBuilder grpcBuilder() {
        return OtlpGrpcMetricExporter.builder();
    }
}

