/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.tasks;

import io.questdb.Telemetry;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableWriter;
import io.questdb.griffin.QueryBuilder;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.ObjectFactory;
import io.questdb.tasks.AbstractTelemetryTask;
import org.jetbrains.annotations.NotNull;

public class TelemetryWalTask
implements AbstractTelemetryTask {
    public static final String NAME = "WAL TELEMETRY";
    public static final String TABLE_NAME = "telemetry_wal";
    public static final Telemetry.TelemetryTypeBuilder<TelemetryWalTask> WAL_TELEMETRY = configuration -> {
        final String tableName = String.valueOf(configuration.getSystemTableNamePrefix()) + TABLE_NAME;
        return new Telemetry.TelemetryType<TelemetryWalTask>(){

            @Override
            public QueryBuilder getCreateSql(QueryBuilder builder) {
                return builder.$("CREATE TABLE IF NOT EXISTS '").$(tableName).$("' (created TIMESTAMP, event SHORT, tableId INT, walId INT, seqTxn LONG, rowCount LONG, physicalRowCount LONG, latency FLOAT ) TIMESTAMP(created) PARTITION BY DAY TTL 1 WEEK BYPASS WAL");
            }

            @Override
            public String getName() {
                return TelemetryWalTask.NAME;
            }

            @Override
            public String getTableName() {
                return tableName;
            }

            @Override
            public ObjectFactory<TelemetryWalTask> getTaskFactory() {
                return () -> new TelemetryWalTask();
            }
        };
    };
    private static final Log LOG = LogFactory.getLog(TelemetryWalTask.class);
    private short event;
    private float latency;
    private long physicalRowCount;
    private long queueCursor;
    private long rowCount;
    private long seqTxn;
    private int tableId;
    private int walId;

    private TelemetryWalTask() {
    }

    public static void store(@NotNull Telemetry<TelemetryWalTask> telemetry, short event, int tableId, int walId, long seqTxn, long rowCount, long physicalRowCount, long latencyUs) {
        TelemetryWalTask task = telemetry.nextTask();
        if (task != null) {
            task.event = event;
            task.tableId = tableId;
            task.walId = walId;
            task.seqTxn = seqTxn;
            task.rowCount = rowCount;
            task.physicalRowCount = physicalRowCount;
            task.latency = (float)latencyUs / 1000.0f;
            telemetry.store(task);
        }
    }

    @Override
    public long getQueueCursor() {
        return this.queueCursor;
    }

    @Override
    public void setQueueCursor(long cursor) {
        this.queueCursor = cursor;
    }

    @Override
    public void writeTo(TableWriter writer, long timestamp) {
        try {
            TableWriter.Row row = writer.newRow(timestamp);
            row.putShort(1, this.event);
            row.putInt(2, this.tableId);
            row.putInt(3, this.walId);
            row.putLong(4, this.seqTxn);
            row.putLong(5, this.rowCount);
            row.putLong(6, this.physicalRowCount);
            row.putFloat(7, this.latency);
            row.append();
        }
        catch (CairoException e) {
            LOG.error().$("Could not insert a new ").$(TABLE_NAME).$(" row [errno=").$(e.getErrno()).$(", error=").$safe(e.getFlyweightMessage()).$(']').$();
        }
    }
}

