/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSequence;
import io.questdb.std.str.DirectCharSequence;
import io.questdb.std.str.StableStringSource;

public class DirectString
extends AbstractCharSequence
implements DirectCharSequence,
Mutable {
    private final StableStringSource stableSource;
    private long hi;
    private int len;
    private long lo;

    public DirectString() {
        this.stableSource = StableStringSource.UNSTABLE_SOURCE;
    }

    public DirectString(StableStringSource stableSource) {
        this.stableSource = stableSource;
    }

    @Override
    public char charAt(int index) {
        return Unsafe.getUnsafe().getChar(this.lo + ((long)index << 1));
    }

    @Override
    public void clear() {
        this.lo = 0L;
        this.hi = 0L;
        this.len = 0;
    }

    @Override
    public int hashCode() {
        if (this.lo == this.hi) {
            return 0;
        }
        int h = 0;
        for (long p = this.lo; p < this.hi; p += 2L) {
            h = 31 * h + Unsafe.getUnsafe().getChar(p);
        }
        return h;
    }

    @Override
    public long hi() {
        return this.hi;
    }

    public boolean isStable() {
        return this.stableSource.isStable();
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public long lo() {
        return this.lo;
    }

    public DirectString of(long lo, long hi) {
        this.lo = lo;
        this.hi = hi;
        this.len = (int)(hi - lo >>> 1);
        return this;
    }

    public DirectString of(long address, int len) {
        this.lo = address;
        this.hi = address + ((long)len << 1);
        this.len = len;
        return this;
    }

    @Override
    public long ptr() {
        return this.lo;
    }

    @Override
    public int size() {
        return (int)(this.hi - this.lo);
    }

    @Override
    protected CharSequence _subSequence(int start, int end) {
        DirectString seq = new DirectString();
        seq.lo = this.lo + ((long)start << 1);
        seq.hi = this.lo + ((long)end << 1);
        seq.len = end - start;
        return seq;
    }
}

