/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractUtf8SequenceHashSet;
import io.questdb.std.Numbers;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8s;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class CompactUtf8SequenceHashSet
extends AbstractUtf8SequenceHashSet {
    private static final int MIN_INITIAL_CAPACITY = 16;

    public CompactUtf8SequenceHashSet() {
        this(16);
    }

    public CompactUtf8SequenceHashSet(int initialCapacity) {
        this(initialCapacity, 0.6);
    }

    public CompactUtf8SequenceHashSet(int initialCapacity, double loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public boolean add(@NotNull Utf8Sequence key) {
        int index = this.keyIndex(key);
        if (index < 0) {
            return false;
        }
        this.addAt(index, key);
        return true;
    }

    public void addAt(int index, @NotNull Utf8Sequence key) {
        Utf8String s = Utf8s.toUtf8String(key);
        this.keys[index] = s;
        this.hashCodes[index] = Utf8s.hashCode(key);
        if (--this.free < 1) {
            this.rehash();
        }
    }

    @Override
    public final void clear() {
        Arrays.fill(this.keys, null);
        this.free = this.capacity;
    }

    @Override
    public Utf8Sequence keyAt(int index) {
        int index1 = -index - 1;
        return this.keys[index1];
    }

    public void resetCapacity() {
        this.free = this.capacity = this.initialCapacity;
        int len = Numbers.ceilPow2((int)((double)this.capacity / this.loadFactor));
        this.keys = new Utf8String[len];
        this.hashCodes = new int[len];
        this.mask = len - 1;
    }

    private void rehash() {
        int newCapacity;
        int size = this.size();
        this.free = this.capacity = (newCapacity = this.capacity * 2);
        int len = Numbers.ceilPow2((int)((double)newCapacity / this.loadFactor));
        Utf8Sequence[] oldKeys = this.keys;
        int[] oldHashCodes = this.hashCodes;
        this.keys = new Utf8Sequence[len];
        this.hashCodes = new int[len];
        Arrays.fill(this.keys, null);
        this.mask = len - 1;
        this.free -= size;
        int i = oldKeys.length;
        while (i-- > 0) {
            Utf8Sequence key = oldKeys[i];
            if (key == null) continue;
            int index = this.keyIndex(key);
            this.keys[index] = key;
            this.hashCodes[index] = oldHashCodes[i];
        }
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = noEntryKey;
        this.hashCodes[index] = 0;
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.hashCodes[to] = this.hashCodes[from];
        this.erase(from);
    }
}

