/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.std.Files;

public class EpollAccessor {
    public static final short DATA_OFFSET = EpollAccessor.getDataOffset();
    public static final int EPOLLET;
    public static final int EPOLLIN;
    public static final int EPOLLONESHOT;
    public static final int EPOLLOUT;
    public static final int EPOLL_CTL_ADD;
    public static final int EPOLL_CTL_DEL;
    public static final int EPOLL_CTL_MOD;
    public static final short EVENTS_OFFSET;
    static final short SIZEOF_EVENT;

    private static native int epollWait(int var0, long var1, int var3, int var4);

    private static native long readEventFd(int var0);

    private static native int writeEventFd(int var0);

    static native int epollCreate();

    static native int epollCtl(int var0, int var1, int var2, long var3);

    static int epollWait(long epfd, long eventPtr, int eventCount, int timeout) {
        return EpollAccessor.epollWait(Files.toOsFd(epfd), eventPtr, eventCount, timeout);
    }

    static native int eventFd();

    static native int getCtlAdd();

    static native int getCtlDel();

    static native int getCtlMod();

    static native short getDataOffset();

    static native int getEPOLLET();

    static native int getEPOLLIN();

    static native int getEPOLLONESHOT();

    static native int getEPOLLOUT();

    static native short getEventSize();

    static native short getEventsOffset();

    static long readEventFd(long fd) {
        return EpollAccessor.readEventFd(Files.toOsFd(fd));
    }

    static int writeEventFd(long fd) {
        return EpollAccessor.writeEventFd(Files.toOsFd(fd));
    }

    static {
        EVENTS_OFFSET = EpollAccessor.getEventsOffset();
        SIZEOF_EVENT = EpollAccessor.getEventSize();
        EPOLLIN = EpollAccessor.getEPOLLIN();
        EPOLLET = EpollAccessor.getEPOLLET();
        EPOLLOUT = EpollAccessor.getEPOLLOUT();
        EPOLLONESHOT = EpollAccessor.getEPOLLONESHOT();
        EPOLL_CTL_ADD = EpollAccessor.getCtlAdd();
        EPOLL_CTL_MOD = EpollAccessor.getCtlMod();
        EPOLL_CTL_DEL = EpollAccessor.getCtlDel();
    }
}

