/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.log;

import io.questdb.Metrics;
import io.questdb.cairo.CairoException;
import io.questdb.log.GuaranteedLogger;
import io.questdb.log.Log;
import io.questdb.log.LogConsoleWriter;
import io.questdb.log.LogError;
import io.questdb.log.LogLevel;
import io.questdb.log.LogRecord;
import io.questdb.log.LogRecordUtf8Sink;
import io.questdb.log.LogWriter;
import io.questdb.log.LogWriterConfig;
import io.questdb.log.Logger;
import io.questdb.mp.FanOut;
import io.questdb.mp.Job;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.Sequence;
import io.questdb.mp.WorkerPool;
import io.questdb.mp.WorkerPoolConfiguration;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.IntObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjHashSet;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.datetime.microtime.MicrosecondClockImpl;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.Sinkable;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogFactory
implements Closeable {
    public static final String CONFIG_SYSTEM_PROPERTY = "out";
    public static final String DEBUG_TRIGGER = "ebug";
    public static final String DEBUG_TRIGGER_ENV = "QDB_DEBUG";
    public static final String DEFAULT_CONFIG_NAME = "log.conf";
    public static final String LOG_DIR_VAR = "${log.dir}";
    private static final String DEFAULT_CONFIG = "/io/questdb/site/conf/log.conf";
    private static final int DEFAULT_LOG_LEVEL = LogLevel.INFO | LogLevel.ERROR | LogLevel.CRITICAL | LogLevel.ADVISORY;
    private static final int DEFAULT_MSG_SIZE = 4096;
    private static final int DEFAULT_QUEUE_DEPTH = 1024;
    private static final String EMPTY_STR = "";
    private static final LengthDescendingComparator LDC = new LengthDescendingComparator();
    private static final CharSequenceHashSet reserved = new CharSequenceHashSet();
    private static LogFactory INSTANCE;
    private static boolean envEnabled;
    private static boolean guaranteedLogging;
    private static String rootDir;
    private final MicrosecondClock clock;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final ObjList<DeferredLogger> deferredLoggers = new ObjList();
    private final ObjHashSet<LogWriter> jobs = new ObjHashSet();
    private final AtomicBoolean running = new AtomicBoolean();
    private final CharSequenceObjHashMap<ScopeConfiguration> scopeConfigMap = new CharSequenceObjHashMap();
    private final ObjList<ScopeConfiguration> scopeConfigs = new ObjList();
    private final StringSink sink = new StringSink();
    private final WorkerPool loggingWorkerPool;
    private boolean configured = false;
    private int queueDepth = 1024;
    private int recordLength = 4096;

    public LogFactory() {
        this(MicrosecondClockImpl.INSTANCE);
    }

    private LogFactory(MicrosecondClock clock) {
        this.clock = clock;
        this.loggingWorkerPool = new WorkerPool(new WorkerPoolConfiguration(){

            @Override
            public Metrics getMetrics() {
                return Metrics.DISABLED;
            }

            @Override
            public String getPoolName() {
                return "logging";
            }

            @Override
            public int getWorkerCount() {
                return 1;
            }

            @Override
            public boolean isDaemonPool() {
                return true;
            }
        });
    }

    public static synchronized void closeInstance() {
        LogFactory logFactory = INSTANCE;
        if (logFactory != null) {
            logFactory.close(true);
            INSTANCE = null;
        }
    }

    public static void configureRootDir(String rootDir) {
        LogFactory.rootDir = rootDir;
    }

    public static void disableEnv() {
        envEnabled = false;
    }

    public static void disableGuaranteedLogging() {
        guaranteedLogging = false;
    }

    public static void disableGuaranteedLogging(Class<?> ... classes) {
        LogFactory.setGuaranteedLogging(false, classes);
    }

    public static void enableEnv() {
        envEnabled = true;
    }

    public static void enableGuaranteedLogging() {
        guaranteedLogging = true;
    }

    public static void enableGuaranteedLogging(Class<?> ... classes) {
        LogFactory.setGuaranteedLogging(true, classes);
    }

    public static synchronized LogFactory getInstance() {
        LogFactory logFactory = INSTANCE;
        if (logFactory == null) {
            INSTANCE = logFactory = new LogFactory();
            logFactory.init(rootDir);
        }
        return logFactory;
    }

    public static Log getLog(Class<?> clazz) {
        return LogFactory.getLog(clazz.getName());
    }

    public static Log getLog(String key) {
        return LogFactory.getInstance().create(key);
    }

    public static synchronized void haltInstance() {
        LogFactory logFactory = INSTANCE;
        if (logFactory != null) {
            logFactory.haltThread();
        }
    }

    public static void init() {
    }

    public synchronized void add(LogWriterConfig config) {
        ScopeConfiguration scopeConf;
        assert (!this.configured);
        int index = this.scopeConfigMap.keyIndex(config.getScope());
        if (index > -1) {
            scopeConf = new ScopeConfiguration(LogLevel.MAX);
            this.scopeConfigMap.putAt(index, config.getScope(), scopeConf);
            this.scopeConfigs.add(scopeConf);
        } else {
            scopeConf = this.scopeConfigMap.valueAtQuick(index);
        }
        scopeConf.add(config);
    }

    public synchronized void bind() {
        int i;
        if (this.configured) {
            return;
        }
        this.configured = true;
        int n = this.scopeConfigs.size();
        for (i = 0; i < n; ++i) {
            ScopeConfiguration conf = this.scopeConfigs.get(i);
            conf.bind(this.jobs, this.queueDepth, this.recordLength);
        }
        this.scopeConfigMap.sortKeys(LDC);
        n = this.jobs.size();
        for (i = 0; i < n; ++i) {
            LogWriter job = this.jobs.get(i);
            job.bindProperties(this);
            this.loggingWorkerPool.assign(job);
        }
    }

    @Override
    public void close() {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean flush) {
        if (this.closed.compareAndSet(false, true)) {
            int i;
            this.haltThread();
            int n = this.jobs.size();
            for (i = 0; i < n; ++i) {
                LogWriter job = this.jobs.get(i);
                try {
                    if (job == null || !flush) continue;
                    try {
                        while (job.run(0, Job.TERMINATING_STATUS)) {
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                        continue;
                    }
                }
                finally {
                    Misc.freeIfCloseable(job);
                }
            }
            n = this.scopeConfigs.size();
            for (i = 0; i < n; ++i) {
                Misc.free(this.scopeConfigs.getQuick(i));
            }
        }
    }

    public Log create(Class<?> clazz) {
        return this.create(clazz.getName());
    }

    public synchronized Log create(String key) {
        return this.create(key, guaranteedLogging);
    }

    public synchronized Log create(String key, boolean guaranteedLogging) {
        if (!this.configured) {
            DeferredLogger log = new DeferredLogger(key);
            this.deferredLoggers.add(log);
            return log;
        }
        ScopeConfiguration scopeConfiguration = this.find(key);
        if (scopeConfiguration == null) {
            return new Logger(this.clock, LogFactory.compressScope(key, this.sink), null, null, null, null, null, null, null, null, null, null);
        }
        Holder dbg = scopeConfiguration.getHolder(Numbers.msb(LogLevel.DEBUG));
        Holder inf = scopeConfiguration.getHolder(Numbers.msb(LogLevel.INFO));
        Holder err = scopeConfiguration.getHolder(Numbers.msb(LogLevel.ERROR));
        Holder cri = scopeConfiguration.getHolder(Numbers.msb(LogLevel.CRITICAL));
        Holder adv = scopeConfiguration.getHolder(Numbers.msb(LogLevel.ADVISORY));
        if (!guaranteedLogging) {
            return this.createLogger(key, dbg, inf, err, cri, adv);
        }
        return this.createGuaranteedLogger(key, dbg, inf, err, cri, adv);
    }

    public void flushJobs() {
        this.pauseThread();
        int n = this.jobs.size();
        for (int i = 0; i < n; ++i) {
            LogWriter job = this.jobs.get(i);
            if (job == null) continue;
            try {
                job.drain(0);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.startThread();
    }

    public ObjHashSet<LogWriter> getJobs() {
        return this.jobs;
    }

    public int getQueueDepth() {
        return this.queueDepth;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public synchronized void init(@Nullable String rootDir) {
        block29: {
            FileInputStream fis;
            String logPath;
            File f;
            if (this.configured) {
                return;
            }
            String conf = System.getProperty(CONFIG_SYSTEM_PROPERTY);
            if (conf == null) {
                conf = DEFAULT_CONFIG;
            }
            boolean initialized = false;
            if (rootDir != null && DEFAULT_CONFIG.equals(conf) && (f = new File(logPath = Paths.get(rootDir, "conf", DEFAULT_CONFIG_NAME).toAbsolutePath().toString())).isFile() && f.canRead()) {
                System.err.printf("Reading log configuration from %s%n", logPath);
                try {
                    fis = new FileInputStream(logPath);
                    try {
                        this.configure(fis, rootDir);
                        initialized = true;
                    }
                    finally {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    throw new LogError("Cannot read " + logPath, e);
                }
            }
            if (!initialized) {
                try (InputStream is = LogFactory.class.getResourceAsStream(conf);){
                    if (is != null) {
                        this.configure(is, rootDir);
                        System.err.println("Log configuration loaded from default internal file.");
                        break block29;
                    }
                    f = new File(conf);
                    if (f.canRead()) {
                        fis = new FileInputStream(f);
                        try {
                            this.configure(fis, rootDir);
                            System.err.printf("Log configuration loaded from: %s%n", conf);
                            break block29;
                        }
                        finally {
                            fis.close();
                        }
                    }
                    this.configureDefaultWriter();
                    System.err.println("Log configuration loaded using factory defaults.");
                }
                catch (IOException e) {
                    if (!DEFAULT_CONFIG.equals(conf)) {
                        throw new LogError("Cannot read " + conf, e);
                    }
                    this.configureDefaultWriter();
                }
            }
        }
        int n = this.deferredLoggers.size();
        for (int i = 0; i < n; ++i) {
            this.deferredLoggers.get(i).init(this);
        }
        this.deferredLoggers.clear();
        this.startThread();
    }

    public void startThread() {
        assert (!this.closed.get());
        if (this.running.compareAndSet(false, true)) {
            int n = this.jobs.size();
            for (int i = 0; i < n; ++i) {
                this.loggingWorkerPool.assign(this.jobs.get(i));
            }
            this.loggingWorkerPool.start();
        }
    }

    private static CharSequence compressScope(CharSequence key, StringSink builder) {
        builder.clear();
        char c = '\u0000';
        boolean pick = true;
        int z = 0;
        int n = key.length();
        for (int i = 0; i < n; ++i) {
            char a = key.charAt(i);
            if (a == '.') {
                if (pick) continue;
                builder.put(c).put('.');
                pick = true;
                continue;
            }
            if (!pick) continue;
            c = a;
            z = i;
            pick = false;
        }
        while (z < key.length()) {
            builder.put(key.charAt(z));
            ++z;
        }
        builder.put(' ');
        return builder.toString();
    }

    private static LogWriterConfig createWriter(Properties properties, String writerName) {
        Constructor<?> constructor;
        Class<?> cl;
        String writer = "w." + writerName + ".";
        String clazz = LogFactory.getProperty(properties, writer + "class");
        String levelStr = LogFactory.getProperty(properties, writer + "level");
        String scope = LogFactory.getProperty(properties, writer + "scope");
        if (clazz == null) {
            return null;
        }
        try {
            cl = Class.forName(clazz);
            constructor = cl.getDeclaredConstructor(RingQueue.class, SCSequence.class, Integer.TYPE);
        }
        catch (ClassNotFoundException e) {
            throw new LogError("Class not found " + clazz, e);
        }
        catch (NoSuchMethodException e) {
            throw new LogError("Constructor(RingQueue, Sequence, int) expected: " + clazz, e);
        }
        int level = 0;
        if (levelStr != null) {
            block17: for (String s : levelStr.split(",")) {
                switch (s.toUpperCase()) {
                    case "DEBUG": {
                        level |= LogLevel.DEBUG;
                        continue block17;
                    }
                    case "INFO": {
                        level |= LogLevel.INFO;
                        continue block17;
                    }
                    case "ERROR": {
                        level |= LogLevel.ERROR;
                        continue block17;
                    }
                    case "CRITICAL": {
                        level |= LogLevel.CRITICAL;
                        continue block17;
                    }
                    case "ADVISORY": {
                        level |= LogLevel.ADVISORY;
                        continue block17;
                    }
                    default: {
                        throw new LogError("Unknown level: " + s);
                    }
                }
            }
        }
        if (LogFactory.isForcedDebug()) {
            level |= LogLevel.DEBUG;
        }
        int msb = Numbers.msb(level);
        level = (-1 >>> msb - 1 << msb | level) & LogLevel.MASK;
        return new LogWriterConfig(scope == null ? EMPTY_STR : scope, level, (ring, seq, level1) -> {
            try {
                LogWriter w1 = (LogWriter)constructor.newInstance(ring, seq, level1);
                for (String n : properties.stringPropertyNames()) {
                    String p;
                    if (!n.startsWith(writer) || reserved.contains(p = n.substring(writer.length()))) continue;
                    try {
                        Field f = cl.getDeclaredField(p);
                        if (f.getType() != String.class) continue;
                        String value = LogFactory.getProperty(properties, n);
                        Unsafe.getUnsafe().putObject(w1, Unsafe.getUnsafe().objectFieldOffset(f), value);
                    }
                    catch (Exception e) {
                        throw new LogError("Unknown property: " + n, e);
                    }
                }
                return w1;
            }
            catch (Exception e) {
                throw new LogError("Error creating log writer", e);
            }
        });
    }

    private static String getProperty(Properties properties, String key) {
        if (envEnabled) {
            String envKey = "QDB_LOG_" + key.replace('.', '_').toUpperCase();
            String envValue = System.getenv(envKey);
            if (envValue == null) {
                return properties.getProperty(key);
            }
            System.err.println("    Using env: " + envKey + "=" + envValue);
            return envValue;
        }
        return properties.getProperty(key);
    }

    private static boolean isForcedDebug() {
        return System.getProperty(DEBUG_TRIGGER) != null || System.getenv().containsKey(DEBUG_TRIGGER_ENV);
    }

    private static void setGuaranteedLogging(boolean guaranteedLogging, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            LogFactory.setLogger(clazz, LogFactory.getInstance().create(clazz.getName(), guaranteedLogging));
        }
    }

    private static void setLogger(Class<?> clazz, Log logger) {
        try {
            Field field = clazz.getDeclaredField("LOG");
            field.setAccessible(true);
            field.set(null, logger);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Could not set logger", e);
        }
    }

    private void configure(InputStream fis, String rootDir) throws IOException {
        File logDirFile;
        Properties properties = new Properties();
        properties.load(fis);
        String logDir = LogFactory.getProperty(properties, "log.dir");
        if (logDir == null) {
            logDir = rootDir != null ? Paths.get(rootDir, "log").toAbsolutePath().toString() : ".";
        }
        boolean usesLogDirVar = false;
        for (String n : properties.stringPropertyNames()) {
            String value = LogFactory.getProperty(properties, n);
            if (!value.contains(LOG_DIR_VAR)) continue;
            usesLogDirVar = true;
            value = value.replace(LOG_DIR_VAR, logDir);
            properties.put(n, value);
        }
        if (usesLogDirVar && !(logDirFile = new File(logDir)).exists() && logDirFile.mkdirs()) {
            System.err.printf("Created log directory: %s%n", logDir);
        }
        this.configureFromProperties(properties);
    }

    private void configureDefaultWriter() {
        int level = DEFAULT_LOG_LEVEL;
        if (LogFactory.isForcedDebug()) {
            level |= LogLevel.DEBUG;
        }
        this.add(new LogWriterConfig(level, LogConsoleWriter::new));
        this.bind();
    }

    private void configureFromProperties(Properties properties) {
        String writers = LogFactory.getProperty(properties, "writers");
        if (writers == null) {
            this.configured = true;
            return;
        }
        String s = LogFactory.getProperty(properties, "queueDepth");
        if (s != null && !s.isEmpty()) {
            try {
                this.setQueueDepth(Numbers.parseInt(s));
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for queueDepth");
            }
        }
        if ((s = LogFactory.getProperty(properties, "recordLength")) != null && !s.isEmpty()) {
            try {
                this.setRecordLength(Numbers.parseInt(s));
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for recordLength");
            }
        }
        if (properties.getProperty("w.file.location") == null) {
            properties.put("w.file.location", EMPTY_STR);
        }
        for (String w : writers.split(",")) {
            LogWriterConfig conf = LogFactory.createWriter(properties, w.trim());
            if (conf == null) continue;
            this.add(conf);
        }
        this.bind();
    }

    @NotNull
    private GuaranteedLogger createGuaranteedLogger(String key, Holder dbg, Holder inf, Holder err, Holder cri, Holder adv) {
        return new GuaranteedLogger(this.clock, LogFactory.compressScope(key, this.sink), dbg == null ? null : dbg.ring, dbg == null ? null : dbg.lSeq, inf == null ? null : inf.ring, inf == null ? null : inf.lSeq, err == null ? null : err.ring, err == null ? null : err.lSeq, cri == null ? null : cri.ring, cri == null ? null : cri.lSeq, adv == null ? null : adv.ring, adv == null ? null : adv.lSeq);
    }

    @NotNull
    private Logger createLogger(String key, Holder dbg, Holder inf, Holder err, Holder cri, Holder adv) {
        return new Logger(this.clock, LogFactory.compressScope(key, this.sink), dbg == null ? null : dbg.ring, dbg == null ? null : dbg.lSeq, inf == null ? null : inf.ring, inf == null ? null : inf.lSeq, err == null ? null : err.ring, err == null ? null : err.lSeq, cri == null ? null : cri.ring, cri == null ? null : cri.lSeq, adv == null ? null : adv.ring, adv == null ? null : adv.lSeq);
    }

    private ScopeConfiguration find(CharSequence key) {
        ObjList<CharSequence> keys = this.scopeConfigMap.keys();
        CharSequence k = null;
        int n = keys.size();
        for (int i = 0; i < n; ++i) {
            CharSequence s = keys.getQuick(i);
            if (!Chars.startsWith(key, s)) continue;
            k = s;
            break;
        }
        if (k == null) {
            return null;
        }
        return this.scopeConfigMap.get(k);
    }

    private void haltThread() {
        if (this.running.compareAndSet(true, false)) {
            this.loggingWorkerPool.halt();
        }
    }

    private void pauseThread() {
        if (this.running.compareAndSet(true, false)) {
            this.loggingWorkerPool.pause();
        }
    }

    private void setQueueDepth(int queueDepth) {
        this.queueDepth = queueDepth;
    }

    private void setRecordLength(int recordLength) {
        this.recordLength = recordLength;
    }

    static {
        envEnabled = true;
        guaranteedLogging = false;
        reserved.add("scope");
        reserved.add("class");
        reserved.add("level");
        Os.init();
    }

    private static class ScopeConfiguration
    implements Closeable {
        private final int[] channels;
        private final ObjList<Holder> holderList = new ObjList();
        private final IntObjHashMap<Holder> holderMap = new IntObjHashMap();
        private final ObjList<LogWriterConfig> writerConfigs = new ObjList();
        private int ci = 0;

        public ScopeConfiguration(int levels) {
            this.channels = new int[levels];
        }

        public void bind(ObjHashSet<LogWriter> jobs, int queueDepth, int recordLength) {
            int i;
            for (int index : this.channels) {
                int keyIndex;
                if (index <= 0 || (keyIndex = this.holderMap.keyIndex(index)) <= -1) continue;
                Holder h = new Holder(queueDepth, recordLength);
                this.holderMap.putAt(keyIndex, index, h);
                this.holderList.add(h);
            }
            int n = this.writerConfigs.size();
            for (i = 0; i < n; ++i) {
                LogWriterConfig c = this.writerConfigs.getQuick(i);
                if (c.getLevel() < 1) {
                    throw CairoException.nonCritical().put("logging level not set");
                }
                Holder h = this.holderMap.get(this.channels[Numbers.msb(c.getLevel())]);
                if (h.wSeq != null) {
                    if (h.fanOut == null) {
                        h.wSeq = new SCSequence();
                        h.fanOut = FanOut.to(h.wSeq).and(h.wSeq);
                    } else {
                        h.wSeq = new SCSequence();
                        h.fanOut.and(h.wSeq);
                    }
                } else {
                    h.wSeq = new SCSequence();
                }
                jobs.add(c.getFactory().createLogWriter(h.ring, h.wSeq, c.getLevel()));
            }
            n = this.holderList.size();
            for (i = 0; i < n; ++i) {
                Holder h = this.holderList.getQuick(i);
                if (h.fanOut != null) {
                    h.lSeq.then(h.fanOut).then(h.lSeq);
                    continue;
                }
                h.lSeq.then(h.wSeq).then(h.lSeq);
            }
        }

        @Override
        public void close() {
            int n = this.holderList.size();
            for (int i = 0; i < n; ++i) {
                Misc.free(this.holderList.getQuick(i));
            }
        }

        private void add(LogWriterConfig conf) {
            int i;
            int mask = conf.getLevel();
            int min = Integer.MAX_VALUE;
            int q = ++this.ci;
            int n = this.channels.length;
            for (i = 0; i < n; ++i) {
                if ((mask >> i & 1) != 1) continue;
                int that = this.channels[i];
                if (that == 0) {
                    this.channels[i] = q;
                }
                if (that <= 0 || that >= min) continue;
                min = that;
            }
            if (mask > 1 && min < Integer.MAX_VALUE) {
                n = this.channels.length;
                for (i = 0; i < n; ++i) {
                    if ((mask >> i & 1) != 1) continue;
                    this.channels[i] = min;
                }
            }
            this.writerConfigs.add(conf);
        }

        private Holder getHolder(int index) {
            return this.holderMap.get(this.channels[index]);
        }
    }

    private static class LengthDescendingComparator
    implements Comparator<CharSequence>,
    Serializable {
        private LengthDescendingComparator() {
        }

        @Override
        public int compare(CharSequence o1, CharSequence o2) {
            int l2;
            int l1 = o1.length();
            if (l1 < (l2 = o2.length())) {
                return 1;
            }
            if (l1 > l2) {
                return -11;
            }
            return 0;
        }
    }

    private static class DeferredLogger
    implements Log {
        private static final NoOpLogRecord noOpRecord = new NoOpLogRecord();
        private final String key;
        private Log delegate;

        public DeferredLogger(String key) {
            this.key = key;
        }

        @Override
        public LogRecord advisory() {
            if (this.delegate != null) {
                return this.delegate.advisory();
            }
            return noOpRecord;
        }

        @Override
        public LogRecord advisoryW() {
            if (this.delegate != null) {
                return this.delegate.advisoryW();
            }
            return noOpRecord;
        }

        @Override
        public LogRecord critical() {
            if (this.delegate != null) {
                return this.delegate.critical();
            }
            return noOpRecord;
        }

        @Override
        public LogRecord debug() {
            if (this.delegate != null) {
                return this.delegate.debug();
            }
            return noOpRecord;
        }

        @Override
        public LogRecord debugW() {
            if (this.delegate != null) {
                return this.delegate.debugW();
            }
            return noOpRecord;
        }

        @Override
        public LogRecord error() {
            if (this.delegate != null) {
                return this.delegate.error();
            }
            return noOpRecord;
        }

        @Override
        public LogRecord errorW() {
            if (this.delegate != null) {
                return this.delegate.errorW();
            }
            return noOpRecord;
        }

        @Override
        public LogRecord info() {
            if (this.delegate != null) {
                return this.delegate.info();
            }
            return noOpRecord;
        }

        @Override
        public LogRecord infoW() {
            if (this.delegate != null) {
                return this.delegate.infoW();
            }
            return noOpRecord;
        }

        public void init(LogFactory logFactory) {
            this.delegate = logFactory.create(this.key);
        }

        @Override
        public LogRecord xDebugW() {
            if (this.delegate != null) {
                return this.delegate.xDebugW();
            }
            return noOpRecord;
        }

        @Override
        public LogRecord xInfoW() {
            if (this.delegate != null) {
                return this.delegate.xInfoW();
            }
            return noOpRecord;
        }

        @Override
        public LogRecord xadvisory() {
            if (this.delegate != null) {
                return this.delegate.xadvisory();
            }
            return noOpRecord;
        }

        @Override
        public LogRecord xcritical() {
            if (this.delegate != null) {
                return this.delegate.xcritical();
            }
            return noOpRecord;
        }

        @Override
        public LogRecord xdebug() {
            if (this.delegate != null) {
                return this.delegate.xdebug();
            }
            return noOpRecord;
        }

        @Override
        public LogRecord xerror() {
            if (this.delegate != null) {
                return this.delegate.xerror();
            }
            return noOpRecord;
        }

        @Override
        public LogRecord xinfo() {
            if (this.delegate != null) {
                return this.delegate.xinfo();
            }
            return noOpRecord;
        }
    }

    private static class Holder
    implements Closeable {
        private final Sequence lSeq;
        private final RingQueue<LogRecordUtf8Sink> ring;
        private FanOut fanOut;
        private SCSequence wSeq;

        public Holder(int queueDepth, int recordLength) {
            this.ring = new RingQueue<LogRecordUtf8Sink>(LogRecordUtf8Sink::new, Numbers.ceilPow2(recordLength), queueDepth, 41);
            this.lSeq = new MPSequence(queueDepth);
        }

        @Override
        public void close() {
            Misc.free(this.ring);
        }
    }

    private static class NoOpLogRecord
    implements LogRecord {
        private NoOpLogRecord() {
        }

        @Override
        public void $() {
        }

        @Override
        public LogRecord $(@Nullable CharSequence sequence) {
            return this;
        }

        @Override
        public LogRecord $(@Nullable Utf8Sequence sequence) {
            return this;
        }

        @Override
        public LogRecord $(@Nullable DirectUtf8Sequence sequence) {
            return this;
        }

        @Override
        public LogRecord $(int x) {
            return this;
        }

        @Override
        public LogRecord $(double x) {
            return this;
        }

        @Override
        public LogRecord $(long l) {
            return this;
        }

        @Override
        public LogRecord $(boolean x) {
            return this;
        }

        @Override
        public LogRecord $(char c) {
            return this;
        }

        @Override
        public LogRecord $(@Nullable Throwable e) {
            return this;
        }

        @Override
        public LogRecord $(@Nullable File x) {
            return this;
        }

        @Override
        public LogRecord $(@Nullable Object x) {
            return this;
        }

        @Override
        public LogRecord $(@Nullable Sinkable x) {
            return this;
        }

        @Override
        public LogRecord $256(long a, long b, long c, long d) {
            return this;
        }

        @Override
        public LogRecord $hex(long value) {
            return this;
        }

        @Override
        public LogRecord $hexPadded(long value) {
            return this;
        }

        @Override
        public LogRecord $ip(long ip) {
            return this;
        }

        @Override
        public LogRecord $safe(@NotNull CharSequence sequence, int lo, int hi) {
            return this;
        }

        @Override
        public LogRecord $safe(@Nullable DirectUtf8Sequence sequence) {
            return this;
        }

        @Override
        public LogRecord $safe(@Nullable Utf8Sequence sequence) {
            return this;
        }

        @Override
        public LogRecord $safe(long lo, long hi) {
            return this;
        }

        @Override
        public LogRecord $safe(@Nullable CharSequence sequence) {
            return this;
        }

        @Override
        public LogRecord $size(long memoryBytes) {
            return this;
        }

        @Override
        public LogRecord $substr(int from, @Nullable DirectUtf8Sequence sequence) {
            return this;
        }

        @Override
        public LogRecord $ts(long x) {
            return this;
        }

        @Override
        public LogRecord $uuid(long lo, long hi) {
            return this;
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public LogRecord microTime(long x) {
            return this;
        }

        @Override
        public LogRecord put(@Nullable Utf8Sequence us) {
            return this;
        }

        @Override
        public LogRecord put(byte b) {
            return this;
        }

        @Override
        public LogRecord put(char c) {
            return this;
        }

        @Override
        public LogRecord putNonAscii(long lo, long hi) {
            return this;
        }

        @Override
        public LogRecord ts() {
            return this;
        }
    }
}

