/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.PartitionFrameCursor;
import io.questdb.cairo.sql.PartitionFrameCursorFactory;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.cairo.sql.TimeFrameRecordCursor;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractPageFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.BwdTableReaderPageFrameCursor;
import io.questdb.griffin.engine.table.FwdTableReaderPageFrameCursor;
import io.questdb.griffin.engine.table.PageFrameRecordCursor;
import io.questdb.griffin.engine.table.PageFrameRecordCursorImpl;
import io.questdb.griffin.engine.table.TablePageFrameCursor;
import io.questdb.griffin.engine.table.TimeFrameRecordCursorImpl;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.str.CharSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PageFrameRecordCursorFactory
extends AbstractPageFrameRecordCursorFactory {
    private final CairoConfiguration configuration;
    private final PageFrameRecordCursor cursor;
    private final Function filter;
    private final boolean followsOrderByAdvice;
    private final boolean framingSupported;
    private final RowCursorFactory rowCursorFactory;
    private final boolean singleRowFactory;
    private final boolean supportsRandomAccess;
    protected FwdTableReaderPageFrameCursor fwdPageFrameCursor;
    private BwdTableReaderPageFrameCursor bwdPageFrameCursor;
    private TimeFrameRecordCursorImpl timeFrameCursor;

    public PageFrameRecordCursorFactory(@NotNull CairoConfiguration configuration, RecordMetadata metadata, PartitionFrameCursorFactory partitionFrameCursorFactory, RowCursorFactory rowCursorFactory, boolean followsOrderByAdvice, @Nullable Function filter, boolean framingSupported, @NotNull IntList columnIndexes, @NotNull IntList columnSizeShifts, boolean supportsRandomAccess, boolean singleRowFactory) {
        super(configuration, metadata, partitionFrameCursorFactory, columnIndexes, columnSizeShifts);
        this.configuration = configuration;
        this.rowCursorFactory = rowCursorFactory;
        this.cursor = new PageFrameRecordCursorImpl(configuration, metadata, rowCursorFactory, rowCursorFactory.isEntity(), filter);
        this.followsOrderByAdvice = followsOrderByAdvice;
        this.filter = filter;
        this.framingSupported = framingSupported;
        this.supportsRandomAccess = supportsRandomAccess;
        this.singleRowFactory = singleRowFactory;
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.followsOrderByAdvice;
    }

    @Override
    public PageFrameCursor getPageFrameCursor(SqlExecutionContext executionContext, int order) throws SqlException {
        if (this.framingSupported) {
            PartitionFrameCursor partitionFrameCursor = this.partitionFrameCursorFactory.getCursor(executionContext, order);
            if (order == 0 || order == 2) {
                return this.initFwdPageFrameCursor(partitionFrameCursor, executionContext);
            }
            return this.initBwdPageFrameCursor(partitionFrameCursor, executionContext);
        }
        return null;
    }

    @Override
    public int getScanDirection() {
        if (this.singleRowFactory) {
            return 1;
        }
        switch (this.partitionFrameCursorFactory.getOrder()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        throw CairoException.critical(0).put("Unexpected factory order [order=").put(this.partitionFrameCursorFactory.getOrder()).put("]");
    }

    @Override
    public TimeFrameRecordCursor getTimeFrameCursor(SqlExecutionContext executionContext) throws SqlException {
        if (this.framingSupported) {
            TablePageFrameCursor pageFrameCursor = this.initPageFrameCursor(executionContext);
            if (this.timeFrameCursor == null) {
                this.timeFrameCursor = new TimeFrameRecordCursorImpl(this.configuration, this.getMetadata());
            }
            return this.timeFrameCursor.of(pageFrameCursor);
        }
        return null;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.supportsRandomAccess;
    }

    @Override
    public boolean supportsPageFrameCursor() {
        return this.framingSupported;
    }

    @Override
    public boolean supportsTimeFrameCursor() {
        return this.framingSupported && this.supportsRandomAccess && this.rowCursorFactory.isEntity() && !this.rowCursorFactory.isUsingIndex() && this.getMetadata().getTimestampIndex() != -1 && this.partitionFrameCursorFactory.getOrder() == 0 && this.filter == null;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("PageFrame");
        this.toPlanInner(sink);
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        sink.putAscii("{\"name\":\"PageFrameRecordCursorFactory\", \"cursorFactory\":");
        this.partitionFrameCursorFactory.toSink(sink);
        sink.putAscii('}');
    }

    @Override
    public boolean usesIndex() {
        return this.rowCursorFactory.isUsingIndex();
    }

    @Override
    protected void _close() {
        super._close();
        Misc.free(this.cursor);
        Misc.free(this.filter);
        Misc.free(this.fwdPageFrameCursor);
        Misc.free(this.bwdPageFrameCursor);
        Misc.free(this.timeFrameCursor);
    }

    protected PageFrameCursor initBwdPageFrameCursor(PartitionFrameCursor partitionFrameCursor, SqlExecutionContext executionContext) {
        if (this.bwdPageFrameCursor == null) {
            this.bwdPageFrameCursor = new BwdTableReaderPageFrameCursor(this.columnIndexes, this.columnSizeShifts, executionContext.getSharedQueryWorkerCount(), this.pageFrameMinRows, this.pageFrameMaxRows);
        }
        return this.bwdPageFrameCursor.of(partitionFrameCursor);
    }

    protected PageFrameCursor initFwdPageFrameCursor(PartitionFrameCursor partitionFrameCursor, SqlExecutionContext executionContext) {
        if (this.fwdPageFrameCursor == null) {
            this.fwdPageFrameCursor = new FwdTableReaderPageFrameCursor(this.columnIndexes, this.columnSizeShifts, executionContext.getSharedQueryWorkerCount(), this.pageFrameMinRows, this.pageFrameMaxRows);
        }
        return this.fwdPageFrameCursor.of(partitionFrameCursor);
    }

    @Override
    protected RecordCursor initRecordCursor(PageFrameCursor frameCursor, SqlExecutionContext executionContext) throws SqlException {
        this.cursor.of(frameCursor, executionContext);
        if (this.filter != null) {
            this.filter.init(this.cursor, executionContext);
        }
        return this.cursor;
    }

    protected void toPlanInner(PlanSink sink) {
        sink.child(this.rowCursorFactory);
        sink.child(this.partitionFrameCursorFactory);
    }
}

