/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.PartitionFrameCursorFactory;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractPageFrameRecordCursor;
import io.questdb.griffin.engine.table.AbstractTreeSetRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValuesFilteredRecordCursor;
import io.questdb.griffin.engine.table.LatestByValuesIndexedFilteredRecordCursor;
import io.questdb.griffin.engine.table.LatestByValuesIndexedRecordCursor;
import io.questdb.griffin.engine.table.LatestByValuesRecordCursor;
import io.questdb.griffin.engine.table.PageFrameRecordCursor;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LatestBySubQueryRecordCursorFactory
extends AbstractTreeSetRecordCursorFactory {
    private final int columnIndex;
    private final Function filter;
    private final Record.CharSequenceFunction func;
    private final boolean indexed;
    private final RecordCursorFactory recordCursorFactory;
    private final IntHashSet symbolKeys;

    public LatestBySubQueryRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull PartitionFrameCursorFactory partitionFrameCursorFactory, int columnIndex, @NotNull RecordCursorFactory recordCursorFactory, @Nullable Function filter, boolean indexed, @NotNull Record.CharSequenceFunction func, @NotNull IntList columnIndexes, @NotNull IntList columnSizeShifts) {
        super(configuration, metadata, partitionFrameCursorFactory, columnIndexes, columnSizeShifts);
        try {
            this.symbolKeys = new IntHashSet();
            this.indexed = indexed;
            AbstractPageFrameRecordCursor cursor = indexed ? (filter != null ? new LatestByValuesIndexedFilteredRecordCursor(configuration, metadata, columnIndex, this.rows, this.symbolKeys, null, filter) : new LatestByValuesIndexedRecordCursor(configuration, metadata, columnIndex, this.symbolKeys, null, this.rows)) : (filter != null ? new LatestByValuesFilteredRecordCursor(configuration, metadata, columnIndex, this.rows, this.symbolKeys, null, filter) : new LatestByValuesRecordCursor(configuration, metadata, columnIndex, this.rows, this.symbolKeys, null));
            this.cursor = new PageFrameRecordCursorWrapper(cursor);
            this.recordCursorFactory = recordCursorFactory;
            this.filter = filter;
            this.columnIndex = columnIndex;
            this.func = func;
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("LatestBySubQuery");
        sink.child("Subquery", this.recordCursorFactory);
        sink.child(this.cursor);
        sink.child(this.partitionFrameCursorFactory);
    }

    @Override
    public boolean usesIndex() {
        return this.indexed;
    }

    @Override
    protected void _close() {
        super._close();
        Misc.free(this.recordCursorFactory);
        Misc.free(this.filter);
        Misc.free(this.cursor);
    }

    private class PageFrameRecordCursorWrapper
    implements PageFrameRecordCursor {
        private final PageFrameRecordCursor delegate;
        private RecordCursor baseCursor;

        private PageFrameRecordCursorWrapper(PageFrameRecordCursor delegate) {
            this.delegate = delegate;
        }

        @Override
        public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
            if (this.baseCursor != null) {
                this.buildSymbolKeys();
                this.baseCursor = Misc.free(this.baseCursor);
            }
            this.delegate.calculateSize(circuitBreaker, counter);
        }

        @Override
        public void close() {
            this.baseCursor = Misc.free(this.baseCursor);
            this.delegate.close();
        }

        @Override
        public PageFrameCursor getPageFrameCursor() {
            return this.delegate.getPageFrameCursor();
        }

        @Override
        public Record getRecord() {
            return this.delegate.getRecord();
        }

        @Override
        public Record getRecordB() {
            return this.delegate.getRecordB();
        }

        @Override
        public StaticSymbolTable getSymbolTable(int columnIndex) {
            return this.delegate.getSymbolTable(columnIndex);
        }

        @Override
        public boolean hasNext() {
            if (this.baseCursor != null) {
                this.buildSymbolKeys();
                this.baseCursor = Misc.free(this.baseCursor);
            }
            return this.delegate.hasNext();
        }

        @Override
        public boolean isUsingIndex() {
            return this.delegate.isUsingIndex();
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.delegate.newSymbolTable(columnIndex);
        }

        @Override
        public void of(PageFrameCursor cursor, SqlExecutionContext executionContext) throws SqlException {
            if (this.baseCursor != null) {
                this.baseCursor = Misc.free(this.baseCursor);
            }
            executionContext.setColumnPreTouchEnabled(false);
            this.baseCursor = LatestBySubQueryRecordCursorFactory.this.recordCursorFactory.getCursor(executionContext);
            LatestBySubQueryRecordCursorFactory.this.symbolKeys.clear();
            this.delegate.of(cursor, executionContext);
        }

        @Override
        public long preComputedStateSize() {
            return this.baseCursor == null ? 1L : 0L;
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            this.delegate.recordAt(record, atRowId);
        }

        @Override
        public long size() {
            return this.delegate.size();
        }

        @Override
        public void skipRows(RecordCursor.Counter rowCount) {
            if (this.baseCursor != null) {
                this.buildSymbolKeys();
                this.baseCursor = Misc.free(this.baseCursor);
            }
            this.delegate.skipRows(rowCount);
        }

        @Override
        public void toPlan(PlanSink sink) {
            this.delegate.toPlan(sink);
        }

        @Override
        public void toTop() {
            this.delegate.toTop();
        }

        private void buildSymbolKeys() {
            StaticSymbolTable symbolTable = this.delegate.getSymbolTable(LatestBySubQueryRecordCursorFactory.this.columnIndex);
            Record record = this.baseCursor.getRecord();
            StringSink sink = Misc.getThreadLocalSink();
            while (this.baseCursor.hasNext()) {
                int symbolKey = symbolTable.keyOf(LatestBySubQueryRecordCursorFactory.this.func.get(record, 0, sink));
                if (symbolKey == -2) continue;
                LatestBySubQueryRecordCursorFactory.this.symbolKeys.add(TableUtils.toIndexKey(symbolKey));
            }
        }
    }
}

