/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.PartitionFrameCursorFactory;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractPageFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueListRecordCursor;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LatestByDeferredListValuesFilteredRecordCursorFactory
extends AbstractPageFrameRecordCursorFactory {
    private final int columnIndex;
    private final LatestByValueListRecordCursor cursor;
    private final ObjList<Function> excludedSymbolFuncs;
    private final Function filter;
    private final ObjList<Function> includedSymbolFuncs;

    public LatestByDeferredListValuesFilteredRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull PartitionFrameCursorFactory partitionFrameCursorFactory, int columnIndex, @Nullable ObjList<Function> includedSymbolFuncs, @Nullable ObjList<Function> excludedSymbolFuncs, @Nullable Function filter, @NotNull IntList columnIndexes, @NotNull IntList columnSizeShifts) {
        super(configuration, metadata, partitionFrameCursorFactory, columnIndexes, columnSizeShifts);
        this.includedSymbolFuncs = includedSymbolFuncs != null ? new ObjList<Function>(includedSymbolFuncs) : null;
        this.excludedSymbolFuncs = excludedSymbolFuncs != null ? new ObjList<Function>(excludedSymbolFuncs) : null;
        this.filter = filter;
        this.columnIndex = columnIndex;
        this.cursor = new LatestByValueListRecordCursor(configuration, metadata, columnIndex, filter, configuration.getDefaultSymbolCapacity(), includedSymbolFuncs != null && includedSymbolFuncs.size() > 0, excludedSymbolFuncs != null && excludedSymbolFuncs.size() > 0);
    }

    public LatestByDeferredListValuesFilteredRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull PartitionFrameCursorFactory partitionFrameCursorFactory, int latestByIndex, Function filter, @NotNull IntList columnIndexes, @NotNull IntList columnSizeShifts) {
        this(configuration, metadata, partitionFrameCursorFactory, latestByIndex, null, null, filter, columnIndexes, columnSizeShifts);
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("LatestByDeferredListValuesFiltered");
        sink.optAttr((CharSequence)"filter", this.filter);
        sink.optAttr((CharSequence)"includedSymbols", this.includedSymbolFuncs);
        sink.optAttr((CharSequence)"excludedSymbols", this.excludedSymbolFuncs);
        sink.child(this.partitionFrameCursorFactory);
    }

    private void lookupDeferredSymbols(PageFrameCursor pageFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        int key;
        Function symbolFunc;
        int i;
        int n;
        StaticSymbolTable symbolMapReader;
        IntHashSet symbolKeys;
        if (this.includedSymbolFuncs != null) {
            symbolKeys = this.cursor.getIncludedSymbolKeys();
            symbolKeys.clear();
            symbolMapReader = pageFrameCursor.getSymbolTable(this.columnIndex);
            n = this.includedSymbolFuncs.size();
            for (i = 0; i < n; ++i) {
                symbolFunc = this.includedSymbolFuncs.getQuick(i);
                symbolFunc.init(pageFrameCursor, executionContext);
                key = symbolMapReader.keyOf(symbolFunc.getStrA(null));
                if (key == -2) continue;
                symbolKeys.add(key);
            }
        }
        if (this.excludedSymbolFuncs != null) {
            symbolKeys = this.cursor.getExcludedSymbolKeys();
            symbolKeys.clear();
            symbolMapReader = pageFrameCursor.getSymbolTable(this.columnIndex);
            n = this.excludedSymbolFuncs.size();
            for (i = 0; i < n; ++i) {
                symbolFunc = this.excludedSymbolFuncs.getQuick(i);
                symbolFunc.init(pageFrameCursor, executionContext);
                key = symbolMapReader.keyOf(symbolFunc.getStrA(null));
                if (key == -2) continue;
                symbolKeys.add(key);
            }
        }
    }

    @Override
    protected void _close() {
        super._close();
        Misc.free(this.filter);
        Misc.free(this.cursor);
    }

    @Override
    protected RecordCursor initRecordCursor(PageFrameCursor pageFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        this.lookupDeferredSymbols(pageFrameCursor, executionContext);
        this.cursor.of(pageFrameCursor, executionContext);
        return this.cursor;
    }
}

