/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.DirectArray;
import io.questdb.cairo.sql.ArrayFunction;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.constants.NullConstant;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndDoubleArrayFunctionFactory
implements FunctionFactory {
    private static final int MAX_DIM_LEN = 16;

    @Override
    public String getSignature() {
        return "rnd_double_array(lv)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int nDims = RndDoubleArrayFunctionFactory.validateAndGetArg(args, argPositions, 0, "nDims");
        if (nDims > 32) {
            throw SqlException.$(argPositions.getQuick(0), "maximum for nDims is ").put(32).put(" [nDims=").put(nDims).put(']');
        }
        if (nDims == 0) {
            return NullConstant.NULL;
        }
        if (args.size() == 1) {
            return new RndDoubleArrayRndDimLenFunction(configuration, nDims, 0, 16, position);
        }
        int nanRate = RndDoubleArrayFunctionFactory.validateAndGetArg(args, argPositions, 1, "nanRate");
        if (args.size() == 2) {
            return new RndDoubleArrayRndDimLenFunction(configuration, nDims, nanRate, 16, position);
        }
        int maxDimLen = RndDoubleArrayFunctionFactory.validateAndGetArg(args, argPositions, 2, "maxDimLength");
        if (args.size() == 3) {
            if (maxDimLen <= 0) {
                throw SqlException.$(argPositions.getQuick(2), "maxDimLength must be a positive integer [maxDimLength=").put(maxDimLen).put(']');
            }
            return new RndDoubleArrayRndDimLenFunction(configuration, nDims, nanRate, maxDimLen, position);
        }
        if (args.size() < nDims + 3) {
            throw SqlException.$(argPositions.getQuick(args.size() - 1), "not enough dim lengths [nDims=").put(nDims).put(", nDimLengths=").put(args.size() - 3).put(']');
        }
        if (args.size() > nDims + 3) {
            throw SqlException.$(argPositions.getQuick(nDims + 3), "too many dim lengths [nDims=").put(nDims).put(", nDimLengths=").put(args.size() - 3).put(']');
        }
        IntList dimLens = new IntList(nDims);
        int n = args.size();
        for (int i = 3; i < n; ++i) {
            dimLens.add(RndDoubleArrayFunctionFactory.validateAndGetArg(args, argPositions, i, "dimLength"));
        }
        return new RndDoubleArrayFixDimLenFunction(configuration, nDims, nanRate, dimLens, position);
    }

    private static int validateAndGetArg(ObjList<Function> args, IntList argPositions, int argIndex, String argName) throws SqlException {
        Function arg = args.getQuick(argIndex);
        int argPosition = argPositions.getQuick(argIndex);
        if (!ColumnType.isAssignableFrom(arg.getType(), 6)) {
            throw SqlException.$(argPosition, argName).put(" must be an integer");
        }
        long valueLong = arg.getLong(null);
        if (valueLong < 0L || valueLong > Integer.MAX_VALUE) {
            throw SqlException.$(argPosition, "invalid ").put(argName).put(" [").put(argName).put('=').put(valueLong).put(']');
        }
        return (int)valueLong;
    }

    public static class RndDoubleArrayRndDimLenFunction
    extends ArrayFunction {
        private final int functionPosition;
        private final int maxDimLen;
        private final int nDims;
        private final int nanRate;
        private DirectArray array;
        private Rnd rnd;

        public RndDoubleArrayRndDimLenFunction(CairoConfiguration configuration, int nDims, int nanRate, int maxDimLen, int functionPosition) {
            try {
                this.nanRate = nanRate;
                this.nDims = nDims;
                this.array = new DirectArray(configuration);
                this.type = ColumnType.encodeArrayType((short)10, nDims);
                this.array.setType(this.type);
                this.maxDimLen = maxDimLen;
                this.functionPosition = functionPosition;
            }
            catch (Throwable th) {
                this.close();
                throw th;
            }
        }

        @Override
        public void close() {
            this.array = Misc.free(this.array);
        }

        @Override
        public ArrayView getArray(Record rec) {
            this.rnd.nextDoubleArray(this.nDims, this.array, this.nanRate, this.maxDimLen, this.functionPosition);
            return this.array;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            super.init(symbolTableSource, executionContext);
            this.rnd = executionContext.getRandom();
        }

        @Override
        public boolean isNonDeterministic() {
            return true;
        }

        @Override
        public boolean isRandom() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("rnd_double_array").val('(').val(this.array.getDimCount()).val(',').val(this.nanRate).val(',').val(this.maxDimLen).val(')');
        }
    }

    public static class RndDoubleArrayFixDimLenFunction
    extends ArrayFunction {
        private final IntList dimLens;
        private final int functionPosition;
        private final int nDims;
        private final int nanRate;
        private DirectArray array;
        private Rnd rnd;

        public RndDoubleArrayFixDimLenFunction(CairoConfiguration configuration, int nDims, int nanRate, IntList dimLens, int functionPosition) {
            try {
                this.nanRate = nanRate;
                this.nDims = nDims;
                this.array = new DirectArray(configuration);
                this.type = ColumnType.encodeArrayType((short)10, nDims);
                this.array.setType(this.type);
                this.dimLens = dimLens;
                this.functionPosition = functionPosition;
            }
            catch (Throwable th) {
                this.close();
                throw th;
            }
        }

        @Override
        public void close() {
            this.array = Misc.free(this.array);
        }

        @Override
        public ArrayView getArray(Record rec) {
            this.rnd.nextDoubleArray(this.nDims, this.array, this.nanRate, this.dimLens, this.functionPosition);
            return this.array;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            super.init(symbolTableSource, executionContext);
            this.rnd = executionContext.getRandom();
        }

        @Override
        public boolean isNonDeterministic() {
            return true;
        }

        @Override
        public boolean isRandom() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("rnd_double_array").val('(').val(this.array.getDimCount()).val(',').val(this.nanRate).val(',').val("ignored,");
            int n = this.dimLens.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    sink.val(',');
                }
                sink.val(this.dimLens.getQuick(i));
            }
            sink.val(')');
        }
    }
}

