/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GeoLongFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;

class FirstGeoHashGroupByFunctionLong
extends GeoLongFunction
implements GroupByFunction,
UnaryFunction {
    protected final Function arg;
    protected int valueIndex;

    public FirstGeoHashGroupByFunctionLong(int type, Function arg) {
        super(type);
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        mapValue.putLong(this.valueIndex, rowId);
        mapValue.putLong(this.valueIndex + 1, this.arg.getGeoLong(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public long getGeoLong(Record rec) {
        return rec.getGeoLong(this.valueIndex + 1);
    }

    @Override
    public String getName() {
        return "first";
    }

    @Override
    public int getSampleByFlags() {
        return 31;
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(6);
        columnTypes.add(6);
    }

    @Override
    public boolean isThreadSafe() {
        return UnaryFunction.super.isThreadSafe();
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        long srcRowId = srcValue.getLong(this.valueIndex);
        long destRowId = destValue.getLong(this.valueIndex);
        if (srcRowId != Long.MIN_VALUE && (srcRowId < destRowId || destRowId == Long.MIN_VALUE)) {
            destValue.putLong(this.valueIndex, srcRowId);
            destValue.putLong(this.valueIndex + 1, srcValue.getGeoLong(this.valueIndex + 1));
        }
    }

    @Override
    public void setLong(MapValue mapValue, long value) {
        mapValue.putLong(this.valueIndex, Long.MIN_VALUE);
        mapValue.putLong(this.valueIndex + 1, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        this.setLong(mapValue, -1L);
    }

    @Override
    public boolean supportsParallelism() {
        return UnaryFunction.super.supportsParallelism();
    }
}

