/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.finance;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.finance.FinanceUtils;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class SpreadBpsFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "spread_bps(DD)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new SpreadBpsFunction(args.getQuick(0), args.getQuick(1));
    }

    private static class SpreadBpsFunction
    extends DoubleFunction
    implements BinaryFunction {
        private final Function ask;
        private final Function bid;

        public SpreadBpsFunction(Function bid, Function ask) {
            this.bid = bid;
            this.ask = ask;
        }

        @Override
        public double getDouble(Record rec) {
            double b = this.bid.getDouble(rec);
            double a = this.ask.getDouble(rec);
            return FinanceUtils.spread(b, a) / FinanceUtils.mid(b, a) * 10000.0;
        }

        @Override
        public Function getLeft() {
            return this.bid;
        }

        @Override
        public String getName() {
            return "spread_bps";
        }

        @Override
        public Function getRight() {
            return this.ask;
        }
    }
}

