/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.griffin.engine.functions.eq.AbstractEqBinaryFunction;
import io.questdb.griffin.engine.functions.eq.EqStrFunctionFactory;
import io.questdb.std.NumericException;
import io.questdb.std.Uuid;
import org.jetbrains.annotations.NotNull;

final class UuidEqUtils {
    private UuidEqUtils() {
    }

    @NotNull
    static BooleanFunction eqStrUuid(Function strFunc, Function uuidFunc) {
        if (strFunc.isConstant()) {
            long hi;
            long lo;
            CharSequence uuidStr = strFunc.getStrA(null);
            if (uuidStr == null) {
                lo = Long.MIN_VALUE;
                hi = Long.MIN_VALUE;
            } else {
                try {
                    Uuid.checkDashesAndLength(uuidStr);
                    lo = Uuid.parseLo(uuidStr);
                    hi = Uuid.parseHi(uuidStr);
                }
                catch (NumericException e) {
                    return BooleanConstant.FALSE;
                }
            }
            return new ConstStrFunc(lo, hi, uuidFunc);
        }
        if (strFunc.isRuntimeConstant()) {
            return new RuntimeConstStrFunc(strFunc, uuidFunc);
        }
        if (uuidFunc.isConstant()) {
            long hi;
            long lo = uuidFunc.getLong128Lo(null);
            if (Uuid.isNull(lo, hi = uuidFunc.getLong128Hi(null))) {
                return new EqStrFunctionFactory.NullCheckFunc(strFunc);
            }
            return new ConstUuidFunc(lo, hi, strFunc);
        }
        return new Func(strFunc, uuidFunc);
    }

    private static class ConstStrFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final long constStrHi;
        private final long constStrLo;
        private final Function uuidFunc;

        private ConstStrFunc(long constStrLo, long constStrHi, Function uuidFunc) {
            this.constStrLo = constStrLo;
            this.constStrHi = constStrHi;
            this.uuidFunc = uuidFunc;
        }

        @Override
        public Function getArg() {
            return this.uuidFunc;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.constStrHi == this.uuidFunc.getLong128Hi(rec) && this.constStrLo == this.uuidFunc.getLong128Lo(rec));
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.uuidFunc);
            if (this.negated) {
                sink.val('!');
            }
            sink.val("='").valUuid(this.constStrLo, this.constStrHi).val('\'');
        }
    }

    private static class RuntimeConstStrFunc
    extends NegatableBooleanFunction
    implements BinaryFunction {
        private final Function strFunc;
        private final Function uuidFunc;
        private long constStrHi;
        private long constStrLo;
        private boolean validUuidStr;

        private RuntimeConstStrFunc(Function strFunc, Function uuidFunc) {
            this.strFunc = strFunc;
            this.uuidFunc = uuidFunc;
        }

        @Override
        public boolean getBool(Record rec) {
            if (!this.validUuidStr) {
                return this.negated;
            }
            return this.negated != (this.constStrHi == this.uuidFunc.getLong128Hi(rec) && this.constStrLo == this.uuidFunc.getLong128Lo(rec));
        }

        @Override
        public Function getLeft() {
            return this.uuidFunc;
        }

        @Override
        public Function getRight() {
            return this.strFunc;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            BinaryFunction.super.init(symbolTableSource, executionContext);
            this.validUuidStr = true;
            CharSequence uuidStr = this.strFunc.getStrA(null);
            if (uuidStr == null) {
                this.constStrLo = Long.MIN_VALUE;
                this.constStrHi = Long.MIN_VALUE;
            } else {
                try {
                    Uuid.checkDashesAndLength(uuidStr);
                    this.constStrLo = Uuid.parseLo(uuidStr);
                    this.constStrHi = Uuid.parseHi(uuidStr);
                }
                catch (NumericException e) {
                    this.validUuidStr = false;
                }
            }
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.uuidFunc);
            if (this.negated) {
                sink.val('!');
            }
            sink.val("='").val(this.strFunc).val('\'');
        }
    }

    private static class ConstUuidFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final long constUuidHi;
        private final long constUuidLo;
        private final Function fun;

        private ConstUuidFunc(long constUuidLo, long constUuidHi, Function fun) {
            this.constUuidLo = constUuidLo;
            this.constUuidHi = constUuidHi;
            this.fun = fun;
        }

        @Override
        public Function getArg() {
            return this.fun;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence uuidStr = this.fun.getStrA(rec);
            if (uuidStr == null) {
                return this.negated != (this.constUuidHi == Long.MIN_VALUE && this.constUuidLo == Long.MIN_VALUE);
            }
            try {
                Uuid.checkDashesAndLength(uuidStr);
                return this.negated != (this.constUuidHi == Uuid.parseHi(uuidStr) && this.constUuidLo == Uuid.parseLo(uuidStr));
            }
            catch (NumericException e) {
                return this.negated;
            }
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.fun);
            if (this.negated) {
                sink.val('!');
            }
            sink.val("='").valUuid(this.constUuidLo, this.constUuidHi).val('\'');
        }
    }

    private static class Func
    extends AbstractEqBinaryFunction
    implements BinaryFunction {
        private Func(Function strFunc, Function uuidFunc) {
            super(strFunc, uuidFunc);
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence str = this.left.getStrA(rec);
            long lo = this.right.getLong128Lo(rec);
            long hi = this.right.getLong128Hi(rec);
            if (str == null) {
                return this.negated != Uuid.isNull(lo, hi);
            }
            try {
                Uuid.checkDashesAndLength(str);
                return this.negated != (hi == Uuid.parseHi(str) && lo == Uuid.parseLo(str));
            }
            catch (NumericException e) {
                return this.negated;
            }
        }
    }
}

