/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.date.TimestampFloorOffsetFunctions;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.microtime.Timestamps;

public class TimestampFloorFromFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "timestamp_floor(sNn)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        CharSequence str = args.getQuick(0).getStrA(null);
        int stride = Timestamps.getStrideMultiple(str, argPositions.getQuick(0));
        char unit = Timestamps.getStrideUnit(str, argPositions.getQuick(0));
        Function timestampFunc = args.getQuick(1);
        long from = args.getQuick(2).getTimestamp(null);
        if (from == Long.MIN_VALUE) {
            from = 0L;
        }
        switch (unit) {
            case 'M': {
                return new TimestampFloorOffsetFunctions.TimestampFloorOffsetMMFunction(timestampFunc, stride, from);
            }
            case 'y': {
                return new TimestampFloorOffsetFunctions.TimestampFloorOffsetYYYYFunction(timestampFunc, stride, from);
            }
            case 'w': {
                return new TimestampFloorOffsetFunctions.TimestampFloorOffsetWWFunction(timestampFunc, stride, from);
            }
            case 'd': {
                return new TimestampFloorOffsetFunctions.TimestampFloorOffsetDDFunction(timestampFunc, stride, from);
            }
            case 'h': {
                return new TimestampFloorOffsetFunctions.TimestampFloorOffsetHHFunction(timestampFunc, stride, from);
            }
            case 'm': {
                return new TimestampFloorOffsetFunctions.TimestampFloorOffsetMIFunction(timestampFunc, stride, from);
            }
            case 's': {
                return new TimestampFloorOffsetFunctions.TimestampFloorOffsetSSFunction(timestampFunc, stride, from);
            }
            case 'T': {
                return new TimestampFloorOffsetFunctions.TimestampFloorOffsetMSFunction(timestampFunc, stride, from);
            }
            case 'U': {
                return new TimestampFloorOffsetFunctions.TimestampFloorOffsetMCFunction(timestampFunc, stride, from);
            }
            case '\u0000': {
                throw SqlException.position(argPositions.getQuick(0)).put("invalid unit 'null'");
            }
        }
        throw SqlException.position(argPositions.getQuick(0)).put("invalid unit '").put(str).put('\'');
    }
}

