/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.date.AbstractDayIntervalFunction;
import io.questdb.std.Interval;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.datetime.TimeZoneRules;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.datetime.microtime.Timestamps;

public abstract class AbstractDayIntervalWithTimezoneFunction
extends AbstractDayIntervalFunction
implements UnaryFunction {
    protected final Function tzFunc;

    public AbstractDayIntervalWithTimezoneFunction(Function tzFunc) {
        this.tzFunc = tzFunc;
    }

    @Override
    public Function getArg() {
        return this.tzFunc;
    }

    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
        UnaryFunction.super.init(symbolTableSource, executionContext);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isThreadSafe() {
        return UnaryFunction.super.isThreadSafe();
    }

    @Override
    public boolean isRuntimeConstant() {
        return UnaryFunction.super.isRuntimeConstant();
    }

    protected Interval calculateInterval(long now, CharSequence tz) {
        if (tz == null) {
            long start = this.intervalStart(now);
            long end = this.intervalEnd(start);
            return this.interval.of(start, end);
        }
        try {
            long l = Timestamps.parseOffset(tz);
            if (l != Long.MIN_VALUE) {
                long offset = (long)Numbers.decodeLowInt(l) * 60000000L;
                long nowWithTz = now + offset;
                long startWithTz = this.intervalStart(nowWithTz);
                long endWithTz = this.intervalEnd(startWithTz);
                return this.interval.of(startWithTz - offset, endWithTz - offset);
            }
            TimeZoneRules tzRules = TimestampFormatUtils.EN_LOCALE.getZoneRules(Numbers.decodeLowInt(TimestampFormatUtils.EN_LOCALE.matchZone(tz, 0, tz.length())), 1);
            long offset = tzRules.getOffset(now);
            long nowWithTz = now + offset;
            long startWithTz = this.intervalStart(nowWithTz);
            long endWithTz = this.intervalEnd(startWithTz);
            return this.interval.of(Timestamps.toUTC(startWithTz, tzRules), Timestamps.toUTC(endWithTz, tzRules));
        }
        catch (NumericException e) {
            return this.interval.of(Interval.NULL.getLo(), Interval.NULL.getHi());
        }
    }
}

