/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.constants;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.ArrayTypeDriver;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.DirectArray;
import io.questdb.cairo.arr.FunctionArray;
import io.questdb.cairo.arr.NoopArrayWriteState;
import io.questdb.cairo.sql.ArrayFunction;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.std.str.StringSink;

public final class ArrayConstant
extends ArrayFunction
implements ConstantFunction {
    public static final DirectArray NULL = new DirectArray();
    private final DirectArray array = new DirectArray();

    public ArrayConstant(FunctionArray arrayIn) {
        try {
            this.type = arrayIn.getType();
            if (ColumnType.isNull(this.type)) {
                this.array.ofNull();
                return;
            }
            MemoryA mem = this.array.copyShapeAndStartMemoryA(arrayIn);
            arrayIn.appendToMemFlat(mem, 0, arrayIn.getFlatViewLength());
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    private ArrayConstant(int nDims) {
        try {
            this.array.setType(ColumnType.encodeArrayType((short)0, nDims));
            this.array.applyShape();
            this.type = this.array.getType();
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    public ArrayConstant(double[] vals) {
        try {
            this.type = ColumnType.encodeArrayType((short)10, 1);
            this.array.setType(this.type);
            this.array.setDimLen(0, vals.length);
            this.array.applyShape();
            MemoryA memA = this.array.startMemoryA();
            int n = vals.length;
            for (int i = 0; i < n; ++i) {
                memA.putDouble(vals[i]);
            }
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    public ArrayConstant(double[][] vals) {
        try {
            this.type = ColumnType.encodeArrayType((short)10, 2);
            this.array.setType(this.type);
            this.array.setDimLen(0, vals.length);
            this.array.setDimLen(1, vals[0].length);
            this.array.applyShape();
            MemoryA memA = this.array.startMemoryA();
            int n = vals.length;
            for (int i = 0; i < n; ++i) {
                int m = vals[0].length;
                for (int j = 0; j < m; ++j) {
                    memA.putDouble(vals[i][j]);
                }
            }
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    public static ArrayConstant emptyUntyped(int nDims) {
        return new ArrayConstant(nDims);
    }

    @Override
    public void assignType(int type, BindVariableService bindVariableService) throws SqlException {
        this.type = type;
        this.array.setType(type);
    }

    @Override
    public void close() {
        this.array.close();
    }

    @Override
    public ArrayView getArray(Record rec) {
        return this.array;
    }

    @Override
    public void toPlan(PlanSink sink) {
        StringSink strSink = new StringSink();
        ArrayTypeDriver.arrayToJson(this.array, strSink, NoopArrayWriteState.INSTANCE);
        sink.val("ARRAY" + String.valueOf(strSink));
    }

    static {
        NULL.ofNull();
    }
}

