/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.engine.functions.catalogue.Constants;

class PgNamespaceRecordCursor
implements NoRandomAccessRecordCursor {
    static final RecordMetadata METADATA;
    private static final int rowCount;
    private final NamespaceCatalogueRecord record = new NamespaceCatalogueRecord();
    private int row = -1;

    PgNamespaceRecordCursor() {
    }

    @Override
    public void close() {
        this.row = -1;
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public boolean hasNext() {
        return ++this.row < rowCount;
    }

    @Override
    public long preComputedStateSize() {
        return 0L;
    }

    @Override
    public long size() {
        return rowCount;
    }

    @Override
    public void toTop() {
        this.row = -1;
    }

    static {
        rowCount = Constants.NAMESPACES.length;
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("nspname", 11));
        metadata.add(new TableColumnMetadata("oid", 5));
        metadata.add(new TableColumnMetadata("xmin", 6));
        metadata.add(new TableColumnMetadata("nspowner", 5));
        METADATA = metadata;
    }

    private class NamespaceCatalogueRecord
    implements Record {
        private NamespaceCatalogueRecord() {
        }

        @Override
        public int getInt(int col) {
            if (col == 1) {
                return Constants.NAMESPACE_OIDS[PgNamespaceRecordCursor.this.row];
            }
            return 1;
        }

        @Override
        public long getLong(int col) {
            return 0L;
        }

        @Override
        public CharSequence getStrA(int col) {
            return Constants.NAMESPACES[PgNamespaceRecordCursor.this.row];
        }

        @Override
        public CharSequence getStrB(int col) {
            return this.getStrA(col);
        }

        @Override
        public int getStrLen(int col) {
            return TableUtils.lengthOf(this.getStrA(col));
        }
    }
}

