/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class InformationSchemaCharacterSetsFunctionFactory
implements FunctionFactory {
    public static final RecordMetadata METADATA;
    public static final String SIGNATURE = "information_schema.character_sets()";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CursorFunction(new CharSetsCursorFactory());
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("character_set_catalog", 11));
        metadata.add(new TableColumnMetadata("character_set_schema", 11));
        metadata.add(new TableColumnMetadata("character_set_name", 11));
        metadata.add(new TableColumnMetadata("character_repertoire", 11));
        metadata.add(new TableColumnMetadata("form_of_use", 11));
        metadata.add(new TableColumnMetadata("default_collate_catalog", 11));
        metadata.add(new TableColumnMetadata("default_collate_schema", 11));
        metadata.add(new TableColumnMetadata("default_collate_name ", 11));
        METADATA = metadata;
    }

    private static class CharSetsCursorFactory
    extends AbstractRecordCursorFactory {
        private final CharSetsRecordCursor cursor = new CharSetsRecordCursor();

        private CharSetsCursorFactory() {
            super(METADATA);
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            this.cursor.toTop();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.type(InformationSchemaCharacterSetsFunctionFactory.SIGNATURE);
        }

        private static class CharSetsRecordCursor
        implements NoRandomAccessRecordCursor {
            private final CharSetsRecord record = new CharSetsRecord();
            private int rowIndex = -1;

            private CharSetsRecordCursor() {
            }

            @Override
            public void close() {
                this.rowIndex = -1;
            }

            @Override
            public Record getRecord() {
                return this.record;
            }

            @Override
            public boolean hasNext() {
                return this.rowIndex++ < 0;
            }

            @Override
            public long preComputedStateSize() {
                return 0L;
            }

            @Override
            public long size() {
                return 1L;
            }

            @Override
            public void toTop() {
                this.rowIndex = -1;
            }

            private static class CharSetsRecord
            implements Record {
                private CharSetsRecord() {
                }

                @Override
                public CharSequence getStrA(int col) {
                    switch (col) {
                        case 0: {
                            return null;
                        }
                        case 1: {
                            return null;
                        }
                        case 2: {
                            return "UTF8";
                        }
                        case 3: {
                            return "UCS";
                        }
                        case 4: {
                            return "UTF8";
                        }
                        case 5: {
                            return "public";
                        }
                        case 6: {
                            return "public";
                        }
                        case 7: {
                            return "en_US.utf8";
                        }
                    }
                    return null;
                }

                @Override
                public CharSequence getStrB(int col) {
                    return this.getStrA(col);
                }

                @Override
                public int getStrLen(int col) {
                    return TableUtils.lengthOf(this.getStrA(col));
                }
            }
        }
    }
}

