/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

public class DumpThreadStacksFunctionFactory
implements FunctionFactory {
    private static final Log LOG = LogFactory.getLog("dump-thread-stacks");
    private static final String SIGNATURE = "dump_thread_stacks()";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpThreadStacks() {
        ThreadInfo[] threadInfos;
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : threadInfos = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), 20)) {
            if (threadInfo == null) continue;
            LogRecord record = LOG.advisory();
            try {
                StackTraceElement[] stackTraceElements;
                Thread.State state = threadInfo.getThreadState();
                record.$('\n');
                record.$('\'').$(threadInfo.getThreadName()).$("': ").$((Object)state);
                for (StackTraceElement stackTraceElement : stackTraceElements = threadInfo.getStackTrace()) {
                    record.$("\n\t\tat ").$(stackTraceElement);
                }
                record.$("\n\n");
            }
            catch (Throwable th) {
                record.$("error dumping threads: ").$(th);
            }
            finally {
                record.$();
            }
        }
    }

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new DumpThreadStacksFunction();
    }

    private static class DumpThreadStacksFunction
    extends BooleanFunction {
        private DumpThreadStacksFunction() {
        }

        @Override
        public boolean getBool(Record rec) {
            DumpThreadStacksFunctionFactory.dumpThreadStacks();
            return true;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            executionContext.getSecurityContext().authorizeSystemAdmin();
            super.init(symbolTableSource, executionContext);
        }

        @Override
        public boolean isThreadSafe() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(DumpThreadStacksFunctionFactory.SIGNATURE);
        }
    }
}

