/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.SingleElementDoubleArray;
import io.questdb.cairo.sql.ArrayFunction;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.ArrayConstant;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class CastDoubleToDoubleArray
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Dd[])";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int arrType = args.getQuick(1).getType();
        return new Func(args.getQuick(0), arrType);
    }

    public static class Func
    extends ArrayFunction
    implements UnaryFunction {
        private final Function arg;
        private final SingleElementDoubleArray array;

        public Func(Function arg, int arrType) {
            this.type = arrType;
            this.arg = arg;
            this.array = new SingleElementDoubleArray(ColumnType.decodeArrayDimensionality(arrType));
        }

        @Override
        public void close() {
            UnaryFunction.super.close();
            Misc.free(this.array);
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public ArrayView getArray(Record rec) {
            double val = this.arg.getDouble(rec);
            if (Numbers.isNull(val)) {
                return ArrayConstant.NULL;
            }
            this.array.of(val);
            return this.array;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getArg()).val("::").val(ColumnType.nameOf(this.type));
        }
    }
}

