/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.array;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class DoubleArraySumFunctionFactory
implements FunctionFactory {
    private static final String FUNCTION_NAME = "array_sum";

    @Override
    public String getSignature() {
        return "array_sum(D[])";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return new Func(args.getQuick(0));
    }

    static class Func
    extends DoubleFunction
    implements UnaryFunction {
        private final Function arrayArg;
        private double compensation;
        private double sum;

        Func(Function arrayArg) {
            this.arrayArg = arrayArg;
        }

        @Override
        public Function getArg() {
            return this.arrayArg;
        }

        @Override
        public double getDouble(Record rec) {
            ArrayView arr = this.arrayArg.getArray(rec);
            if (arr.isNull()) {
                return Double.NaN;
            }
            if (arr.isVanilla()) {
                return arr.flatView().sumDouble(arr.getFlatViewOffset(), arr.getFlatViewLength());
            }
            this.sum = Double.NaN;
            this.compensation = 0.0;
            this.calculateRecursive(arr, 0, 0);
            return this.sum;
        }

        @Override
        public String getName() {
            return DoubleArraySumFunctionFactory.FUNCTION_NAME;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        private void calculateRecursive(ArrayView view, int dim, int flatIndex) {
            boolean atDeepestDim;
            int count = view.getDimLen(dim);
            int stride = view.getStride(dim);
            boolean bl = atDeepestDim = dim == view.getDimCount() - 1;
            if (atDeepestDim) {
                for (int i = 0; i < count; ++i) {
                    double v = view.getDouble(flatIndex);
                    if (Numbers.isFinite(v)) {
                        if (this.compensation == 0.0 && Numbers.isNull(this.sum)) {
                            this.sum = 0.0;
                        }
                        double y = v - this.compensation;
                        double t = this.sum + y;
                        this.compensation = t - this.sum - y;
                        this.sum = t;
                    }
                    flatIndex += stride;
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    this.calculateRecursive(view, dim + 1, flatIndex);
                    flatIndex += stride;
                }
            }
        }
    }
}

